/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.git.v2;

import com.atlassian.bamboo.build.fileserver.BuildDirectoryManager;
import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.build.logger.BuildLoggingContext;
import com.atlassian.bamboo.build.logger.NullBuildLogger;
import com.atlassian.bamboo.credentials.CredentialsAccessor;
import com.atlassian.bamboo.plugins.git.GitCacheDirectory;
import com.atlassian.bamboo.plugins.git.GitOperationHelper;
import com.atlassian.bamboo.plugins.git.GitOperationHelperFactory;
import com.atlassian.bamboo.plugins.git.GitRepositoryAccessData;
import com.atlassian.bamboo.plugins.git.v2.AbstractGitExecutor;
import com.atlassian.bamboo.repository.RepositoryException;
import com.atlassian.bamboo.security.TrustedKeyHelper;
import com.atlassian.bamboo.ssh.SshProxyService;
import com.atlassian.bamboo.tag.TagAndRevision;
import com.atlassian.bamboo.utils.SystemProperty;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityContext;
import com.atlassian.bamboo.variable.CustomVariableContext;
import com.atlassian.bamboo.vcs.configuration.VcsRepositoryData;
import com.atlassian.bamboo.vcs.runtime.ContextualVcsId;
import com.atlassian.bamboo.vcs.runtime.IdentifyingExecutor;
import com.atlassian.bamboo.vcs.runtime.VcsTagsHandler;
import com.atlassian.sal.api.message.I18nResolver;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.io.File;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitTagsHandler
extends AbstractGitExecutor
implements VcsTagsHandler {
    private static final String EXPECTED_ERR_NO_TAG = "error: malformed object name ";
    private static final String EXPECTED_ERR_NO_REV = "error: no such commit ";

    @Inject
    public GitTagsHandler(CapabilityContext capabilityContext, CredentialsAccessor credentialsAccessor, CustomVariableContext customVariableContext, BuildDirectoryManager buildDirectoryManager, I18nResolver i18nResolver, TrustedKeyHelper trustedKeyHelper, SshProxyService sshProxyService, BuildLoggingContext buildLoggingContext) {
        super(capabilityContext, credentialsAccessor, customVariableContext, buildDirectoryManager, i18nResolver, trustedKeyHelper, sshProxyService, buildLoggingContext);
    }

    public List<TagAndRevision> getAllTagsFromRepository(@NotNull VcsRepositoryData vcsRepositoryData) throws RepositoryException {
        try {
            GitRepositoryAccessData substitutedAccessData = this.getSubstitutedAccessData(vcsRepositoryData);
            GitOperationHelper helper = GitOperationHelperFactory.createGitOperationHelper(this, substitutedAccessData, this.sshProxyService, (BuildLogger)new NullBuildLogger(), this.i18nResolver, this.trustedKeyHelper);
            List<TagAndRevision> tags = helper.getTagsForRepository(substitutedAccessData);
            return tags;
        }
        catch (UncheckedExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RepositoryException) {
                throw (RepositoryException)cause;
            }
            throw new RepositoryException(e.getMessage(), (Throwable)e);
        }
        catch (RepositoryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RepositoryException(e.getMessage(), (Throwable)e);
        }
    }

    public boolean isBranchContainTag(VcsRepositoryData vcsRepositoryData, String branchName, TagAndRevision tagAndRevision) throws RepositoryException {
        GitRepositoryAccessData substitutedAccessData = this.getSubstitutedAccessData(vcsRepositoryData);
        Path cacheDirectory = this.getCachePath(substitutedAccessData);
        GitOperationHelper helper = GitOperationHelperFactory.createGitOperationHelper(this, substitutedAccessData, this.sshProxyService, (BuildLogger)new NullBuildLogger(), this.i18nResolver, this.trustedKeyHelper);
        try {
            File sourceDirectory = cacheDirectory.toFile();
            return (Boolean)GitCacheDirectory.getCacheLock(sourceDirectory).withLock(() -> {
                helper.fetch(sourceDirectory, branchName, false, true, SystemProperty.FETCHING_LFS_FILES_ON_SERVER_ENABLED.getTypedValue());
                Optional<String> tagOpt = helper.getBranchForSha(sourceDirectory, tagAndRevision.getName(), branchName);
                Optional<String> revOpt = helper.getBranchForSha(sourceDirectory, tagAndRevision.getRevision(), branchName);
                return tagOpt.filter(t -> t.equals(branchName)).isPresent() && revOpt.filter(t -> t.equals(branchName)).isPresent();
            });
        }
        catch (RepositoryException re) {
            this.handleRepositoryException(re, tagAndRevision);
            return false;
        }
        catch (Exception e) {
            throw new RepositoryException((Throwable)e, vcsRepositoryData.getId());
        }
    }

    private void handleRepositoryException(RepositoryException re, TagAndRevision tagAndRevision) throws RepositoryException {
        String stdErr = re.getStderr();
        String expectedErrorNoTag = EXPECTED_ERR_NO_TAG + tagAndRevision.getName();
        String expectedErrorNoCommit = EXPECTED_ERR_NO_REV + tagAndRevision.getRevision();
        if (!expectedErrorNoTag.equals(stdErr) && !expectedErrorNoCommit.equals(stdErr)) {
            throw re;
        }
    }

    @Nullable
    public ContextualVcsId<VcsTagsHandler> getVcsIdForExecutor(@NotNull VcsRepositoryData vcsRepositoryData) {
        GitRepositoryAccessData substitutedAccessData = this.getSubstitutedAccessData(vcsRepositoryData);
        return new ContextualVcsId((IdentifyingExecutor)this, vcsRepositoryData, new String[]{substitutedAccessData.getRepositoryUrl(), substitutedAccessData.getUsername(), substitutedAccessData.getSshKey()});
    }
}

