/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.git.v2;

import com.atlassian.bamboo.build.fileserver.BuildDirectoryManager;
import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.build.logger.BuildLoggingContext;
import com.atlassian.bamboo.build.logger.NullBuildLogger;
import com.atlassian.bamboo.credentials.CredentialsAccessor;
import com.atlassian.bamboo.plugins.git.GitOperationHelper;
import com.atlassian.bamboo.plugins.git.GitOperationHelperFactory;
import com.atlassian.bamboo.plugins.git.GitRepositoryAccessData;
import com.atlassian.bamboo.plugins.git.v2.AbstractGitExecutor;
import com.atlassian.bamboo.repository.RepositoryException;
import com.atlassian.bamboo.security.TrustedKeyHelper;
import com.atlassian.bamboo.ssh.SshProxyService;
import com.atlassian.bamboo.utils.BambooPreconditions;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityContext;
import com.atlassian.bamboo.variable.CustomVariableContext;
import com.atlassian.bamboo.vcs.configuration.VcsRepositoryData;
import com.atlassian.bamboo.vcs.runtime.VcsTagCreator;
import com.atlassian.sal.api.message.I18nResolver;
import java.io.File;
import javax.inject.Inject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitTagCreator
extends AbstractGitExecutor
implements VcsTagCreator {
    @Inject
    public GitTagCreator(CapabilityContext capabilityContext, CredentialsAccessor credentialsAccessor, CustomVariableContext customVariableContext, BuildDirectoryManager buildDirectoryManager, I18nResolver i18nResolver, TrustedKeyHelper trustedKeyHelper, SshProxyService sshProxyService, BuildLoggingContext buildLoggingContext) {
        super(capabilityContext, credentialsAccessor, customVariableContext, buildDirectoryManager, i18nResolver, trustedKeyHelper, sshProxyService, buildLoggingContext);
    }

    public void createTag(@NotNull VcsRepositoryData repositoryData, @NotNull String tagName, @NotNull String vcsRevisionKey, @Nullable String checkoutLocation, @Nullable BuildLogger buildLogger) throws RepositoryException {
        BambooPreconditions.checkThat((checkoutLocation != null ? 1 : 0) != 0, RepositoryException::new, (String)"Checkout location is required to create a tag for Git repository", (Object[])new Object[0]);
        GitRepositoryAccessData accessData = this.getSubstitutedAccessData(repositoryData);
        BuildLogger effectiveBuildLogger = buildLogger != null ? buildLogger : new NullBuildLogger();
        GitOperationHelper gitOperationHelper = GitOperationHelperFactory.createGitOperationHelper(this, accessData, this.sshProxyService, effectiveBuildLogger, this.i18nResolver, this.trustedKeyHelper);
        File sourceDirectory = new File(checkoutLocation);
        gitOperationHelper.createLightweightTag(sourceDirectory, tagName, vcsRevisionKey);
        gitOperationHelper.pushBranchOrTag(sourceDirectory, tagName);
    }
}

