/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.git.v2;

import com.atlassian.bamboo.build.fileserver.BuildDirectoryManager;
import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.build.logger.BuildLoggingContext;
import com.atlassian.bamboo.build.logger.NullBuildLogger;
import com.atlassian.bamboo.credentials.CredentialsAccessor;
import com.atlassian.bamboo.plugins.git.GitAuthenticationType;
import com.atlassian.bamboo.plugins.git.GitOperationHelper;
import com.atlassian.bamboo.plugins.git.GitOperationHelperFactory;
import com.atlassian.bamboo.plugins.git.GitRepositoryAccessData;
import com.atlassian.bamboo.plugins.git.v2.AbstractGitExecutor;
import com.atlassian.bamboo.repository.HostKeyVerificationException;
import com.atlassian.bamboo.repository.RepositoryException;
import com.atlassian.bamboo.security.TrustedKey;
import com.atlassian.bamboo.security.TrustedKeyHelper;
import com.atlassian.bamboo.ssh.SshProxyService;
import com.atlassian.bamboo.util.BambooStringUtils;
import com.atlassian.bamboo.util.CacheAwareness;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.utils.error.SimpleErrorCollection;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityContext;
import com.atlassian.bamboo.variable.CustomVariableContext;
import com.atlassian.bamboo.vcs.configuration.VcsRepositoryData;
import com.atlassian.bamboo.vcs.runtime.VcsConnectionTester;
import com.atlassian.sal.api.message.I18nResolver;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class GitConnectionTester
extends AbstractGitExecutor
implements VcsConnectionTester {
    @Inject
    public GitConnectionTester(CapabilityContext capabilityContext, CredentialsAccessor credentialsAccessor, CustomVariableContext customVariableContext, BuildDirectoryManager buildDirectoryManager, I18nResolver i18nResolver, TrustedKeyHelper trustedKeyHelper, SshProxyService sshProxyService, BuildLoggingContext buildLoggingContext) {
        super(capabilityContext, credentialsAccessor, customVariableContext, buildDirectoryManager, i18nResolver, trustedKeyHelper, sshProxyService, buildLoggingContext);
    }

    @NotNull
    public ErrorCollection testConnection(@NotNull VcsRepositoryData repositoryData, long timeout, @NotNull TimeUnit unit) {
        GitRepositoryAccessData substitutedAccessData = this.getSubstitutedAccessData(repositoryData);
        if (substitutedAccessData.getAuthenticationType() == GitAuthenticationType.SSH_KEYPAIR && StringUtils.isEmpty((CharSequence)substitutedAccessData.getSshKey())) {
            return new SimpleErrorCollection(new String[]{this.i18nResolver.getText("repository.test.connection.private.key.not.received")});
        }
        AtomicReference errorCollectionReference = new AtomicReference();
        CacheAwareness.withValuesOlderThanTimestampReloaded(() -> {
            ErrorCollection connectionErrors = this.testConnectionToRepository(substitutedAccessData);
            errorCollectionReference.set(connectionErrors);
        }, (long)System.currentTimeMillis(), (CacheAwareness.CacheInfo[])new CacheAwareness.CacheInfo[]{CacheAwareness.ANY});
        return (ErrorCollection)errorCollectionReference.get();
    }

    @NotNull
    private ErrorCollection testConnectionToRepository(GitRepositoryAccessData substitutedAccessData) {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        try {
            NullBuildLogger buildLogger = new NullBuildLogger();
            GitOperationHelper helper = GitOperationHelperFactory.createGitOperationHelper(this, substitutedAccessData, this.sshProxyService, (BuildLogger)buildLogger, this.i18nResolver, this.trustedKeyHelper);
            helper.obtainLatestRevision();
        }
        catch (UncheckedExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RepositoryException) {
                if (cause instanceof HostKeyVerificationException) {
                    this.handleHostKeyVerificationException((ErrorCollection)errorCollection, (HostKeyVerificationException)cause);
                } else {
                    this.handleTestConnectionException((ErrorCollection)errorCollection, (RepositoryException)cause);
                }
            }
            throw new RuntimeException(cause);
        }
        catch (HostKeyVerificationException e) {
            this.handleHostKeyVerificationException((ErrorCollection)errorCollection, e);
        }
        catch (RepositoryException e) {
            this.handleTestConnectionException((ErrorCollection)errorCollection, e);
        }
        return errorCollection;
    }

    protected void handleHostKeyVerificationException(@NotNull ErrorCollection errorCollection, @NotNull HostKeyVerificationException exception) {
        TrustedKey trustedKey = exception.getTrustedKey();
        String errorMessage = trustedKey == null || StringUtils.isBlank((CharSequence)trustedKey.getKey()) ? this.i18nResolver.getText("repository.test.connection.error.host.key.unknown") : this.i18nResolver.getText("repository.test.connection.error.host.key", (Serializable[])new String[]{trustedKey.getHost(), trustedKey.getKey()});
        errorCollection.addError("hostkey", errorMessage);
    }

    private void handleTestConnectionException(@NotNull ErrorCollection errorCollection, @NotNull RepositoryException repositoryException) {
        errorCollection.addErrorMessage(BambooStringUtils.firstNotBlank((String[])new String[]{repositoryException.getStdout(), repositoryException.getStderr(), repositoryException.getMessage(), this.i18nResolver.getText("repository.test.connection.unknown.error")}));
    }
}

