/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.git.v2;

import com.atlassian.bamboo.build.fileserver.BuildDirectoryManager;
import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.build.logger.BuildLoggingContext;
import com.atlassian.bamboo.build.logger.NullBuildLogger;
import com.atlassian.bamboo.commit.CommitContext;
import com.atlassian.bamboo.credentials.CredentialsAccessor;
import com.atlassian.bamboo.plan.branch.VcsBranch;
import com.atlassian.bamboo.plugins.git.GitCacheDirectory;
import com.atlassian.bamboo.plugins.git.GitOperationHelper;
import com.atlassian.bamboo.plugins.git.GitOperationHelperFactory;
import com.atlassian.bamboo.plugins.git.GitRepositoryAccessData;
import com.atlassian.bamboo.plugins.git.domain.HashAndSource;
import com.atlassian.bamboo.plugins.git.v2.AbstractGitExecutor;
import com.atlassian.bamboo.repository.RepositoryException;
import com.atlassian.bamboo.security.TrustedKeyHelper;
import com.atlassian.bamboo.ssh.SshProxyService;
import com.atlassian.bamboo.utils.SystemProperty;
import com.atlassian.bamboo.utils.fage.Result;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityContext;
import com.atlassian.bamboo.variable.CustomVariableContext;
import com.atlassian.bamboo.vcs.configuration.VcsRepositoryData;
import com.atlassian.bamboo.vcs.runtime.ContextualVcsId;
import com.atlassian.bamboo.vcs.runtime.IdentifyingExecutor;
import com.atlassian.bamboo.vcs.runtime.VcsBranchDetector;
import com.atlassian.sal.api.message.I18nResolver;
import java.io.File;
import java.util.List;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitBranchDetector
extends AbstractGitExecutor
implements VcsBranchDetector {
    private static final Logger log = Logger.getLogger(GitBranchDetector.class);

    @Inject
    public GitBranchDetector(CapabilityContext capabilityContext, CredentialsAccessor credentialsAccessor, CustomVariableContext customVariableContext, BuildDirectoryManager buildDirectoryManager, I18nResolver i18nResolver, TrustedKeyHelper trustedKeyHelper, SshProxyService sshProxyService, BuildLoggingContext buildLoggingContext) {
        super(capabilityContext, credentialsAccessor, customVariableContext, buildDirectoryManager, i18nResolver, trustedKeyHelper, sshProxyService, buildLoggingContext);
    }

    @NotNull
    public List<VcsBranch> getOpenBranches(@NotNull VcsRepositoryData repositoryData) throws RepositoryException {
        GitRepositoryAccessData substitutedAccessData = this.getSubstitutedAccessData(repositoryData);
        GitOperationHelper helper = GitOperationHelperFactory.createGitOperationHelper(this, substitutedAccessData, this.sshProxyService, (BuildLogger)new NullBuildLogger(), this.i18nResolver, this.trustedKeyHelper);
        return helper.getOpenBranches(substitutedAccessData, this.getWorkingDirectory());
    }

    @NotNull
    public CommitContext getFirstCommitApproximation(@NotNull VcsRepositoryData repositoryData) throws RepositoryException {
        NullBuildLogger buildLogger = new NullBuildLogger();
        GitRepositoryAccessData substitutedAccessData = this.getSubstitutedAccessData(repositoryData);
        GitOperationHelper helper = GitOperationHelperFactory.createGitOperationHelper(this, substitutedAccessData, this.sshProxyService, (BuildLogger)buildLogger, this.i18nResolver, this.trustedKeyHelper);
        File cacheDirectory = this.getCacheDirectory(substitutedAccessData);
        Result result = (Result)GitCacheDirectory.getCacheLock(cacheDirectory).withLock(() -> {
            try {
                String shaOfRefIfExists = helper.getShaOfRefIfExists(cacheDirectory, substitutedAccessData.getVcsBranch().getName());
                if (shaOfRefIfExists == null) {
                    return Result.result((Object)this.getLastCommit(repositoryData));
                }
                return Result.result((Object)helper.getCommit(cacheDirectory, shaOfRefIfExists));
            }
            catch (RepositoryException e) {
                return Result.exception((Throwable)e);
            }
        });
        return (CommitContext)result.getResultThrowException();
    }

    @NotNull
    public CommitContext getLastCommit(@NotNull VcsRepositoryData repositoryData) throws RepositoryException {
        NullBuildLogger buildLogger = new NullBuildLogger();
        GitRepositoryAccessData substitutedAccessData = this.getSubstitutedAccessData(repositoryData);
        GitOperationHelper helper = GitOperationHelperFactory.createGitOperationHelper(this, substitutedAccessData, this.sshProxyService, (BuildLogger)buildLogger, this.i18nResolver, this.trustedKeyHelper);
        HashAndSource latestHashAndSource = helper.obtainLatestRevision();
        File cacheDirectory = this.getCacheDirectory(substitutedAccessData);
        Result result = (Result)GitCacheDirectory.getCacheLock(cacheDirectory).withLock(() -> this.lambda$getLastCommit$1(helper, cacheDirectory, latestHashAndSource, repositoryData, (BuildLogger)buildLogger));
        return (CommitContext)result.getResultThrowException();
    }

    @Nullable
    public ContextualVcsId<VcsBranchDetector> getVcsIdForExecutor(@NotNull VcsRepositoryData vcsRepositoryData) {
        GitRepositoryAccessData substitutedAccessData = this.getSubstitutedAccessData(vcsRepositoryData);
        return new ContextualVcsId((IdentifyingExecutor)this, vcsRepositoryData, new String[]{substitutedAccessData.getRepositoryUrl(), substitutedAccessData.getUsername(), substitutedAccessData.getSshKey()});
    }

    private /* synthetic */ Result lambda$getLastCommit$1(GitOperationHelper helper, File cacheDirectory, HashAndSource latestHashAndSource, VcsRepositoryData repositoryData, BuildLogger buildLogger) {
        try {
            try {
                CommitContext commit = helper.getCommit(cacheDirectory, latestHashAndSource.getHash());
                log.info((Object)String.format("Found %s as the last commit for %s [%d]", commit.getChangeSetId(), repositoryData.getName(), repositoryData.getId()));
                return Result.result((Object)commit);
            }
            catch (RepositoryException e) {
                try {
                    log.debug((Object)"Fetching remote repository");
                    this.fetchCacheWithRetry(helper, cacheDirectory, latestHashAndSource, buildLogger, false, SystemProperty.FETCHING_LFS_FILES_ON_SERVER_ENABLED.getTypedValue());
                    return Result.result((Object)helper.getCommit(cacheDirectory, latestHashAndSource.getHash()));
                }
                catch (RepositoryException e2) {
                    return Result.exception((Throwable)e2);
                }
            }
        }
        catch (Exception e) {
            return Result.exception((Throwable)new RepositoryException((Throwable)e));
        }
    }
}

