/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.git.jgit.transport.http;

import com.atlassian.bamboo.util.BambooObjectUtils;
import java.io.IOException;
import java.net.Proxy;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.log4j.Logger;
import org.eclipse.jgit.transport.http.HttpConnection;
import org.eclipse.jgit.transport.http.JDKHttpConnectionFactory;
import org.jetbrains.annotations.NotNull;

public class AllTrustingHttpConnectionFactory
extends JDKHttpConnectionFactory {
    private static final Logger log = Logger.getLogger(AllTrustingHttpConnectionFactory.class);

    @Override
    public HttpConnection create(URL url) throws IOException {
        return this.customizeConnection(super.create(url));
    }

    @Override
    public HttpConnection create(URL url, Proxy proxy) throws IOException {
        return this.customizeConnection(super.create(url, proxy));
    }

    @NotNull
    private HttpConnection customizeConnection(@NotNull HttpConnection connection) {
        try {
            if ("https".equals(connection.getURL().getProtocol())) {
                TrustManager[] trustAllCerts = new TrustManager[]{new DummyX509TrustManager()};
                connection.configure(null, trustAllCerts, new SecureRandom());
                connection.setHostnameVerifier(new DummyHostnameVerifier());
            }
        }
        catch (NoSuchAlgorithmException e) {
            log.warn((Object)"Unable to customize connection", (Throwable)e);
            throw BambooObjectUtils.asRuntimeException((Throwable)e);
        }
        catch (KeyManagementException e) {
            log.warn((Object)"Unable to customize connection", (Throwable)e);
            throw BambooObjectUtils.asRuntimeException((Throwable)e);
        }
        return connection;
    }

    private static class DummyHostnameVerifier
    implements HostnameVerifier {
        private DummyHostnameVerifier() {
        }

        @Override
        public boolean verify(String hostname, SSLSession session) {
            return true;
        }
    }

    private static class DummyX509TrustManager
    implements X509TrustManager {
        private DummyX509TrustManager() {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        @Override
        public void checkClientTrusted(X509Certificate[] certs, String authType) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] certs, String authType) {
        }
    }
}

