/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.git.jgit.transport;

import java.util.Collection;
import java.util.HashSet;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.transport.RefSpec;

public class LazyRefSpec
extends RefSpec {
    private final Collection<RefSpec> expandedSources = new HashSet<RefSpec>();
    private final Collection<RefSpec> expandedDestinations = new HashSet<RefSpec>();

    public LazyRefSpec(RefSpec refSpec) {
        super(refSpec.toString());
    }

    @Override
    public RefSpec expandFromSource(String r) {
        return this.addExpandedSource(super.expandFromSource(r));
    }

    @Override
    public RefSpec expandFromSource(Ref r) {
        return this.addExpandedSource(super.expandFromSource(r));
    }

    @Override
    public RefSpec expandFromDestination(String r) {
        return this.addExpandedDestination(super.expandFromDestination(r));
    }

    @Override
    public RefSpec expandFromDestination(Ref r) {
        return this.addExpandedDestination(super.expandFromDestination(r));
    }

    private RefSpec addExpandedSource(RefSpec refSpec) {
        this.expandedSources.add(refSpec);
        return refSpec;
    }

    private RefSpec addExpandedDestination(RefSpec refSpec) {
        this.expandedDestinations.add(refSpec);
        return refSpec;
    }

    public Collection<RefSpec> getExpandedSources() {
        return this.expandedSources;
    }

    public String toBreakingContractString() {
        String plainRefSpecString = this.toString();
        if (this.expandedSources.isEmpty() && this.expandedDestinations.isEmpty()) {
            return plainRefSpecString;
        }
        return plainRefSpecString + " -> " + this.expandedSources + ":" + this.expandedDestinations;
    }
}

