/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.git;

import com.atlassian.bamboo.plugins.git.UriUtils;
import java.net.URI;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;

public class ScpAwareUri {
    URI delegate;
    private final boolean relativePath;

    private ScpAwareUri(URI uri, boolean relativePath) {
        this.delegate = uri;
        this.relativePath = relativePath;
    }

    public static ScpAwareUri create(String url) {
        boolean isRelativePath = false;
        if (UriUtils.hasScpSyntax((String)url)) {
            int slashIndex = ((String)url).indexOf("/");
            int colonIndex = ((String)url).indexOf(":");
            boolean noSlash = slashIndex == -1;
            boolean noSlashAfterColon = colonIndex < slashIndex && colonIndex + 1 != slashIndex;
            isRelativePath = noSlash || noSlashAfterColon;
            url = "ssh://" + (String)(isRelativePath ? ((String)url).replace(":", "/") : url);
        }
        return new ScpAwareUri(URI.create((String)url), isRelativePath);
    }

    public String getRawPath() {
        if (this.relativePath) {
            return StringUtils.removeStart((String)this.delegate.getRawPath(), (String)"/");
        }
        return this.delegate.getRawPath();
    }

    @Nullable
    public String getScheme() {
        return this.delegate.getScheme();
    }

    public String getUserInfo() {
        return this.delegate.getUserInfo();
    }

    public int getPort() {
        return this.delegate.getPort();
    }

    public String getHost() {
        return this.delegate.getHost();
    }

    public String getRawQuery() {
        return this.delegate.getRawQuery();
    }

    public String getRawFragment() {
        return this.delegate.getRawFragment();
    }

    public boolean isRelativePath() {
        return this.relativePath;
    }

    public String getAbsolutePath() {
        return this.delegate.getRawPath();
    }
}

