/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.git;

import com.atlassian.bamboo.plugins.git.GitCommandProcessor;
import com.atlassian.bamboo.repository.RepositoryException;
import com.atlassian.bamboo.tag.TagAndRevision;
import com.atlassian.bamboo.tag.TagAndRevisionImpl;
import com.atlassian.utils.process.LineOutputHandler;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import org.apache.log4j.Logger;

public class RemoteTagsOutputHandler
extends LineOutputHandler
implements GitCommandProcessor.GitOutputHandler {
    private static final Logger log = Logger.getLogger(RemoteTagsOutputHandler.class);
    private static final String DEREFERENCE_MARKER = "^{}";
    private final List<TagAndRevision> tags = new ArrayList<TagAndRevision>(1000);
    private String refName = null;
    private String revision = null;
    private RepositoryException error;

    protected void processLine(int i, String line) {
        log.debug((Object)("Processing line: " + line));
        if (this.error != null) {
            return;
        }
        Matcher matcher = GitCommandProcessor.LS_REMOTE_LINE_PATTERN.matcher(line);
        if (!matcher.matches()) {
            if (!this.tags.isEmpty()) {
                this.error = new RepositoryException(MessageFormat.format("Incorrect output from ls-remote cmd. Incorrect line({0}): {1}", i, line), 1L);
            }
            return;
        }
        String rev = matcher.group(1);
        String name = matcher.group(2);
        if (name.endsWith(DEREFERENCE_MARKER)) {
            if (this.refName == null || name.substring(0, this.refName.length() - DEREFERENCE_MARKER.length()).equals(this.refName)) {
                this.error = new RepositoryException(MessageFormat.format("For annotated tag dereference exist {0} but reference doesn't exist", name), 1L);
                return;
            }
            log.debug((Object)String.format("Found annotated tag %s for revision %s", this.refName, this.revision));
            this.tags.add(this.newGitTag(this.refName, rev, true));
            this.refName = null;
            this.revision = null;
        } else {
            if (this.refName != null && this.revision != null) {
                log.debug((Object)String.format("Found lightweight tag %s for revision %s", this.refName, this.revision));
                this.tags.add(this.newGitTag(this.refName, this.revision, false));
            }
            this.refName = name;
            this.revision = rev;
        }
    }

    private TagAndRevision newGitTag(String name, String revision, boolean annotated) {
        return new TagAndRevisionImpl(name.substring("refs/tags/".length()), revision);
    }

    @Override
    public String getStdout() {
        return "";
    }

    public List<TagAndRevision> finalizeAndGetTags() throws RepositoryException {
        if (this.error != null) {
            throw this.error;
        }
        if (this.refName != null && this.revision != null) {
            this.tags.add(this.newGitTag(this.refName, this.revision, false));
        }
        return this.tags;
    }
}

