/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.git;

import com.atlassian.bamboo.plugins.git.GitHubAccessor;
import com.atlassian.bamboo.plugins.git.GitHubRepository;
import com.atlassian.bamboo.repository.CachedRepositoryDefinitionManager;
import com.atlassian.bamboo.repository.Repository;
import com.atlassian.bamboo.repository.RepositoryDataImpl;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.vcs.configuration.VcsRepositoryData;
import com.atlassian.bamboo.ww2.actions.PlanActionSupport;
import com.atlassian.bamboo.ww2.aware.permissions.PlanEditSecurityAware;
import com.opensymphony.webwork.dispatcher.json.JSONException;
import com.opensymphony.webwork.dispatcher.json.JSONObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class LoadGitHubRepositories
extends PlanActionSupport
implements PlanEditSecurityAware {
    private static final Logger log = Logger.getLogger(LoadGitHubRepositories.class);
    private String username;
    private String password;
    private long repositoryId;
    @Inject
    private CachedRepositoryDefinitionManager cachedRepositoryDefinitionManager;

    public String doLoad() {
        return "success";
    }

    @NotNull
    public JSONObject getJsonObject() throws JSONException {
        RepositoryDataImpl repositoryData;
        Repository repository;
        GitHubRepository ghRepository;
        VcsRepositoryData vcsRepositoryData;
        Map<String, Iterable<String>> gitHubRepositories = null;
        if (this.repositoryId > 0L && StringUtils.isBlank((CharSequence)this.password) && (vcsRepositoryData = this.cachedRepositoryDefinitionManager.getVcsRepositoryData(this.repositoryId)) != null && (ghRepository = (GitHubRepository)Narrow.to((Object)(repository = (repositoryData = new RepositoryDataImpl(vcsRepositoryData)).getRepository()), GitHubRepository.class)) != null) {
            this.password = ghRepository.getPassword();
        }
        if (StringUtils.isBlank((CharSequence)this.username)) {
            this.addFieldError("username", this.getText("repository.github.error.emptyUsername"));
        }
        this.checkFieldXssSafety("username", this.username);
        if (this.hasErrors()) {
            return super.getJsonObject();
        }
        try {
            gitHubRepositories = this.getGitHubRepositoresAndBranches();
        }
        catch (GitHubAccessor.GitHubException e) {
            if (e.isAuthError()) {
                if (this.getPlan() != null) {
                    this.addFieldError("username", this.getText("repository.github.error.notAuthorized"));
                } else {
                    this.addFieldError("temporary.password", this.getText("repository.github.error.notAuthorized"));
                }
            } else {
                this.addActionError(this.getText("repository.github.ajaxError") + e);
                log.error((Object)("Could not load github repositories for " + this.username + "."), (Throwable)e);
            }
        }
        catch (Exception e) {
            this.addActionError(this.getText("repository.github.ajaxError") + e);
            log.error((Object)("Could not load github repositories for " + this.username + "."), (Throwable)e);
        }
        JSONObject jsonObject = super.getJsonObject();
        if (this.hasErrors()) {
            return jsonObject;
        }
        assert (gitHubRepositories != null);
        ArrayList<JSONObject> data = new ArrayList<JSONObject>();
        for (Map.Entry<String, Iterable<String>> entry : gitHubRepositories.entrySet()) {
            String repository2 = entry.getKey();
            for (String branch : entry.getValue()) {
                data.add(new JSONObject().put("value", (Object)branch).put("text", (Object)branch).put("supportedValues", (Object)new String[]{repository2}));
            }
        }
        jsonObject.put("repositoryBranchFilter", (Object)new JSONObject().put("data", data));
        jsonObject.put("gitHubRepositories", (Object)this.newJsonLinkedHashMap(gitHubRepositories));
        return jsonObject;
    }

    private JSONObject newJsonLinkedHashMap(Map<String, Iterable<String>> gitHubRepositories) throws JSONException {
        JSONObject map = new JSONObject();
        for (Map.Entry<String, Iterable<String>> entry : gitHubRepositories.entrySet()) {
            map.put(entry.getKey(), entry.getValue());
        }
        return map;
    }

    @NotNull
    private Map<String, Iterable<String>> getGitHubRepositoresAndBranches() throws IOException, GitHubAccessor.GitHubException {
        GitHubAccessor gitHubAccessor = new GitHubAccessor(this.username, this.password);
        Map<String, Iterable<String>> accessibleRepositoriesAndBranches = gitHubAccessor.getAccessibleRepositoriesAndBranches();
        if (accessibleRepositoriesAndBranches.isEmpty()) {
            this.addFieldError("username", this.getText("repository.github.error.noRepositories", Collections.singletonList(this.username)));
        }
        return accessibleRepositoriesAndBranches;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setRepositoryId(long repositoryId) {
        this.repositoryId = repositoryId;
    }
}

