/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.git;

import com.atlassian.bamboo.commit.CommitContext;
import com.atlassian.bamboo.plan.branch.VcsBranch;
import com.atlassian.bamboo.plugins.git.GitRepositoryAccessData;
import com.atlassian.bamboo.plugins.git.api.GitRef;
import com.atlassian.bamboo.plugins.git.domain.GitHash;
import com.atlassian.bamboo.plugins.git.domain.HashAndSource;
import com.atlassian.bamboo.repository.RepositoryException;
import com.atlassian.bamboo.tag.TagAndRevision;
import com.atlassian.bamboo.utils.Pair;
import com.atlassian.bamboo.v2.build.BuildRepositoryChanges;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface GitOperationHelper {
    public void pushRevision(@NotNull File var1, @NotNull String var2, @Nullable String var3) throws RepositoryException;

    public void pushBranchOrTag(@NotNull File var1, @NotNull String var2) throws RepositoryException;

    @NotNull
    default public String commit(@NotNull File sourceDirectory, @NotNull String message, @NotNull String committerName, @NotNull String committerEmail) throws RepositoryException {
        return this.commit(sourceDirectory, message, committerName, committerEmail, true);
    }

    @NotNull
    public String commit(@NotNull File var1, @NotNull String var2, @NotNull String var3, @NotNull String var4, boolean var5) throws RepositoryException;

    public void stageChanges(@NotNull File var1, @NotNull Collection<String> var2) throws RepositoryException;

    @NotNull
    public String checkout(@Nullable File var1, @NotNull File var2, @NotNull String var3, @Nullable String var4, boolean var5) throws RepositoryException;

    @NotNull
    public String checkout(@Nullable File var1, @NotNull File var2, @NotNull String var3, @Nullable String var4) throws RepositoryException;

    public void fetch(@NotNull File var1, @NotNull String var2, boolean var3) throws RepositoryException;

    public void fetch(@NotNull File var1, @NotNull String var2, boolean var3, boolean var4) throws RepositoryException;

    public void fetch(@NotNull File var1, @NotNull String var2, boolean var3, boolean var4, boolean var5) throws RepositoryException;

    public void fetch(@NotNull File var1, @NotNull HashAndSource var2, boolean var3) throws RepositoryException;

    public void fetch(@NotNull File var1, @NotNull HashAndSource var2, boolean var3, boolean var4) throws RepositoryException;

    public void fetch(@NotNull File var1, @NotNull HashAndSource var2, boolean var3, boolean var4, boolean var5) throws RepositoryException;

    @NotNull
    public String getCurrentRevision(@NotNull File var1) throws RepositoryException;

    public List<TagAndRevision> getTagsForRepository(@NotNull GitRepositoryAccessData var1) throws RepositoryException;

    public boolean isClean(@NotNull File var1) throws RepositoryException;

    @Nullable
    public String getShaOfRefIfExists(@NotNull File var1, @NotNull String var2);

    @NotNull
    public HashAndSource obtainLatestRevision() throws RepositoryException;

    @NotNull
    public List<VcsBranch> getOpenBranches(@NotNull GitRepositoryAccessData var1, File var2) throws RepositoryException;

    public boolean checkRevisionExistsInCacheRepository(@NotNull File var1, @NotNull String var2) throws IOException, RepositoryException;

    @NotNull
    public CommitContext getCommit(File var1, String var2) throws RepositoryException;

    public boolean merge(@NotNull File var1, @NotNull String var2, @NotNull String var3, @NotNull String var4) throws RepositoryException;

    public Pair<Boolean, String> mergeAndReturnHead(@NotNull File var1, @NotNull String var2, @NotNull String var3, @NotNull String var4, @NotNull String var5) throws RepositoryException;

    public BuildRepositoryChanges extractCommits(File var1, @NotNull String var2, String var3) throws RepositoryException;

    @NotNull
    public Optional<String> getBranchForSha(@NotNull File var1, String var2, String var3) throws RepositoryException;

    public Optional<GitHash> obtainLatestRevision(@NotNull File var1, GitRef var2, String var3) throws RepositoryException;

    public boolean isAncestor(@NotNull Path var1, @NotNull GitHash var2, @NotNull GitHash var3) throws RepositoryException;

    public BuildRepositoryChanges extractCommits(File var1, @NotNull String var2, String var3, String var4) throws RepositoryException;

    public BuildRepositoryChanges extractCommitsBetweenBranches(File var1, VcsBranch var2, boolean var3) throws RepositoryException;

    public void createBranch(@NotNull File var1, @NotNull String var2) throws RepositoryException;

    public void createLightweightTag(@NotNull File var1, @NotNull String var2, @NotNull String var3) throws RepositoryException;

    public String getCurrentBranch(File var1) throws RepositoryException;
}

