/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.git;

import com.atlassian.bamboo.plugins.github.GitHubRepositoryHelper;
import com.atlassian.bamboo.plugins.github.dto.GithubPullRequestDto;
import com.atlassian.bamboo.plugins.github.dto.GithubRepositoryInfoDto;
import com.atlassian.bamboo.repository.RepositoryException;
import com.atlassian.bamboo.rest.utils.Delete;
import com.atlassian.bamboo.rest.utils.Get;
import com.atlassian.bamboo.rest.utils.Post;
import com.atlassian.bamboo.util.UrlUtils;
import com.atlassian.bamboo.utils.Pair;
import com.atlassian.bamboo.vcs.configuration.VcsRepositoryData;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.collect.Ordering;
import com.google.gson.Gson;
import com.opensymphony.webwork.dispatcher.json.JSONArray;
import com.opensymphony.webwork.dispatcher.json.JSONException;
import com.opensymphony.webwork.dispatcher.json.JSONObject;
import io.atlassian.fugue.Functions;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.ws.rs.core.UriBuilder;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitHubAccessor {
    private static final Logger log = Logger.getLogger(GitHubAccessor.class);
    static final String GITHUB_API_BASE_URL = "https://api.github.com/";
    private final Function<String, UriBuilder> COMMIT_COMMENT_URL = Functions.weakMemoize(apiBaseUrl -> UriBuilder.fromUri((String)UrlUtils.appendSlashIfDoesntExist((String)apiBaseUrl)).path("repos/{owner}/{repo}/commits/{changesetId}/comments"));
    private final Function<String, UriBuilder> MANAGER_COMMIT_COMMENT_URL = Functions.weakMemoize(apiBaseUrl -> UriBuilder.fromUri((String)UrlUtils.appendSlashIfDoesntExist((String)apiBaseUrl)).path("repos/{owner}/{repo}/comments/{commentId}"));
    private final Function<String, UriBuilder> COMMIT_URL = Functions.weakMemoize(apiBaseUrl -> UriBuilder.fromUri((String)UrlUtils.appendSlashIfDoesntExist((String)apiBaseUrl)).path("repos/{owner}/{repo}/commits"));
    private final Function<String, UriBuilder> PULL_REQUESTS_URL = Functions.weakMemoize(apiBaseUrl -> UriBuilder.fromUri((String)UrlUtils.appendSlashIfDoesntExist((String)apiBaseUrl)).path("repos/{owner}/{repo}/pulls"));
    private static final String JSON_ERROR_MESSAGE_FIELD = "message";
    @VisibleForTesting
    static final String QUERY_PARAM_PER_PAGE = "per_page";
    @VisibleForTesting
    static final String QUERY_PARAM_PAGE = "page";
    @VisibleForTesting
    static final int MAX_PAGE_SIZE = 100;
    private final String username;
    private final String password;
    private final boolean onlyPublic;
    private String apiBaseUrl = "https://api.github.com/";

    @Deprecated
    public GitHubAccessor(String username, String password) {
        this.username = username;
        this.password = password;
        this.onlyPublic = StringUtils.isBlank((CharSequence)password);
    }

    public GitHubAccessor(String username, String password, String apiBaseUrl2) {
        this.username = username;
        this.password = password;
        this.onlyPublic = StringUtils.isBlank((CharSequence)password);
        this.apiBaseUrl = UrlUtils.stripQueryAndRef((String)apiBaseUrl2);
    }

    public Iterable<String> getAccessibleRepositories() throws IOException, GitHubException {
        Iterable<String> userRepos = this.getUserRepositories();
        ArrayList orgRepos = new ArrayList();
        for (String org : this.getUserOrganisations()) {
            Iterables.addAll(orgRepos, this.getOrganisationRepositories(org));
        }
        return Iterables.concat(userRepos, orgRepos);
    }

    public Map<String, Iterable<String>> getAccessibleRepositoriesAndBranches() throws IOException, GitHubException {
        Iterable<String> accessibleRepositories = this.getAccessibleRepositories();
        LinkedHashMap<String, Iterable<String>> accessibleRepositoriesAndBranches = new LinkedHashMap<String, Iterable<String>>();
        for (String accessibleRepository : accessibleRepositories) {
            accessibleRepositoriesAndBranches.put(accessibleRepository, this.getBranches(accessibleRepository));
        }
        return accessibleRepositoriesAndBranches;
    }

    public Iterable<String> getBranches(String userRepo) throws IOException, GitHubException {
        return this.getFoldedListFromGitHubApi(UrlUtils.appendSlashIfDoesntExist((String)this.apiBaseUrl) + "repos/" + userRepo + "/branches", GitHubAccessorFieldNames.NAME.get());
    }

    public Iterable<String> getUserOrganisations() throws IOException, GitHubException {
        Pair<JSONArray, Multimap<String, String>> repoJson = this.getJSONArrayResponseFromUrl(UrlUtils.appendSlashIfDoesntExist((String)this.apiBaseUrl) + this.getEndPointForCurrentCredentials("orgs"));
        return this.foldArrayAndSort((JSONArray)repoJson.getFirst(), GitHubAccessorFieldNames.LOGIN.get());
    }

    public Iterable<String> getUserRepositories() throws IOException, GitHubException {
        return this.getRepositories(UrlUtils.appendSlashIfDoesntExist((String)this.apiBaseUrl) + this.getEndPointForCurrentCredentials("repos"));
    }

    public Iterable<String> getOrganisationRepositories(String org) throws IOException, GitHubException {
        return this.getRepositories(UrlUtils.appendSlashIfDoesntExist((String)this.apiBaseUrl) + "orgs/" + org + "/repos");
    }

    public boolean commentOnCommit(String commitId, VcsRepositoryData repositoryData, String message) throws RepositoryException {
        URI requestUri = this.COMMIT_COMMENT_URL.apply(this.apiBaseUrl).build(new Object[]{GitHubRepositoryHelper.getRepositoryOwner(repositoryData), GitHubRepositoryHelper.getRepositorySlug(repositoryData), commitId});
        HashMap<String, String> payload = new HashMap<String, String>();
        payload.put("body", message);
        try {
            boolean result;
            HttpResponse response = this.post(requestUri.toString(), new Gson().toJson(payload), null);
            int statusCode = response.getStatusCode();
            boolean bl = result = 201 == statusCode;
            if (!result && log.isDebugEnabled()) {
                log.debug((Object)response.getResponse());
            }
            return result;
        }
        catch (IOException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new RepositoryException(e.getMessage(), repositoryData.getRootVcsRepositoryId());
        }
    }

    public List<GithubPullRequestDto> getPullRequests(VcsRepositoryData repositoryData) throws IOException, GitHubException {
        String currentEndpoint;
        String endpoint = this.PULL_REQUESTS_URL.apply(this.apiBaseUrl).build(new Object[]{GitHubRepositoryHelper.getRepositoryOwner(repositoryData), GitHubRepositoryHelper.getRepositorySlug(repositoryData)}).toString();
        ArrayList<GithubPullRequestDto> results = new ArrayList<GithubPullRequestDto>();
        try {
            currentEndpoint = GitHubAccessor.appendMaxPageSize(endpoint);
        }
        catch (URISyntaxException e) {
            log.warn((Object)"An invalid URI was used to access GitHub API", (Throwable)e);
            throw new RuntimeException(e);
        }
        while (currentEndpoint != null) {
            Pair<JSONArray, Multimap<String, String>> jsonResponse = this.getJSONArrayResponseFromUrl(currentEndpoint);
            if (jsonResponse.getFirst() != null) {
                results.addAll(this.parsePullRequestResponseToDtos((JSONArray)jsonResponse.getFirst()));
            }
            currentEndpoint = jsonResponse.getSecond() != null ? this.getNextUrl((Multimap<String, String>)((Multimap)jsonResponse.getSecond())) : null;
        }
        return results;
    }

    public List<String> getCommits(String repo) throws IOException, GitHubException {
        return this.getFoldedListFromGitHubApi(this.COMMIT_URL.apply(this.apiBaseUrl).build(new Object[]{this.username, repo}).toString(), GitHubAccessorFieldNames.SHA.get());
    }

    public List<String> getCommentIds(String repo, String commitId) throws IOException, GitHubException {
        return this.getFoldedListFromGitHubApi(this.COMMIT_COMMENT_URL.apply(this.apiBaseUrl).build(new Object[]{this.username, repo, commitId}).toString(), "id");
    }

    public void deleteComment(String repo, String commentId) throws IOException {
        URI url = this.MANAGER_COMMIT_COMMENT_URL.apply(this.apiBaseUrl).build(new Object[]{this.username, repo, commentId});
        this.delete(url.toString(), null);
    }

    @NotNull
    @VisibleForTesting
    List<String> getFoldedListFromGitHubApi(@NotNull String endpoint, @NotNull String fieldName) throws IOException, GitHubException {
        String currentEndpoint;
        ArrayList<String> result = new ArrayList<String>();
        try {
            currentEndpoint = GitHubAccessor.appendMaxPageSize(endpoint);
        }
        catch (URISyntaxException e) {
            log.warn((Object)"An invalid URI was used to access GitHub API", (Throwable)e);
            throw new RuntimeException(e);
        }
        while (currentEndpoint != null) {
            Pair<JSONArray, Multimap<String, String>> jsonResponse = this.getJSONArrayResponseFromUrl(currentEndpoint);
            result.addAll(this.foldArrayAndSort((JSONArray)jsonResponse.getFirst(), fieldName));
            currentEndpoint = jsonResponse.getSecond() != null ? this.getNextUrl((Multimap<String, String>)((Multimap)jsonResponse.getSecond())) : null;
        }
        return result;
    }

    @VisibleForTesting
    @Nullable
    String getNextUrl(@NotNull Multimap<String, String> headers) {
        Collection links = headers.get((Object)"Link");
        if (links != null) {
            for (String linkHeader : links) {
                String url = this.extractNextURLFromHeader(linkHeader);
                if (url == null) continue;
                return url;
            }
        }
        return null;
    }

    private String extractNextURLFromHeader(String linkHeader) {
        String[] headerParts;
        for (String header : headerParts = linkHeader.split(",")) {
            String[] headerElements = header.split(";");
            String url = "";
            for (String element : headerElements) {
                String trimmed = element.trim().replaceAll("\"", "");
                if (trimmed.startsWith("rel") && trimmed.endsWith("next")) {
                    return url;
                }
                if (!trimmed.startsWith("<") || !trimmed.endsWith(">")) continue;
                url = trimmed.substring(1, trimmed.length() - 1);
            }
        }
        return null;
    }

    private String getEndPointForCurrentCredentials(String endPath) {
        return this.onlyPublic ? "users/" + this.username + "/" + endPath : "user/" + endPath;
    }

    @NotNull
    @VisibleForTesting
    static String appendMaxPageSize(@NotNull String endpoint) throws URISyntaxException {
        URI endpointUri = new URI(endpoint);
        boolean shouldAppend = true;
        if (StringUtils.isNotEmpty((CharSequence)endpointUri.getQuery())) {
            Multimap queryParams = UrlUtils.extractQueryParams((URI)endpointUri);
            shouldAppend = !queryParams.containsKey((Object)QUERY_PARAM_PER_PAGE) && !queryParams.containsKey((Object)QUERY_PARAM_PAGE);
        }
        return shouldAppend ? new URIBuilder(endpoint).addParameter(QUERY_PARAM_PER_PAGE, Integer.toString(100)).toString() : endpoint;
    }

    @VisibleForTesting
    Pair<JSONArray, Multimap<String, String>> getJSONArrayResponseFromUrl(String url) throws IOException, GitHubException {
        HttpResponse response = this.getStringFromUrl(url);
        try {
            return Pair.make((Object)new JSONArray(response.getResponse()), response.getHeaders());
        }
        catch (JSONException e) {
            JSONObject jsonObject = this.createQuietly(response.getResponse());
            if (jsonObject != null && jsonObject.has(JSON_ERROR_MESSAGE_FIELD)) {
                throw new GitHubException(this.getStringQuietly(jsonObject));
            }
            throw new GitHubException("The server returned invalid response (not a JSON object)");
        }
    }

    @Nullable
    private String getStringQuietly(JSONObject jsonObject) {
        try {
            return jsonObject.getString(JSON_ERROR_MESSAGE_FIELD);
        }
        catch (JSONException e) {
            return null;
        }
    }

    @Nullable
    private JSONObject createQuietly(String stringFromUrl) {
        try {
            return new JSONObject(stringFromUrl);
        }
        catch (JSONException e) {
            return null;
        }
    }

    private Iterable<String> getRepositories(String endpoint) throws IOException, GitHubException {
        return this.getFoldedListFromGitHubApi(endpoint, GitHubAccessorFieldNames.FULL_NAME.get());
    }

    private List<GithubPullRequestDto> parsePullRequestResponseToDtos(JSONArray jsonArray) throws GitHubException {
        try {
            ArrayList<GithubPullRequestDto> results = new ArrayList<GithubPullRequestDto>();
            for (int index = 0; index < jsonArray.length(); ++index) {
                JSONObject json = jsonArray.getJSONObject(index);
                JSONObject source = json.getJSONObject(GitHubAccessorFieldNames.HEAD.get());
                JSONObject sourceRepository = source.getJSONObject(GitHubAccessorFieldNames.REPO.get());
                JSONObject target = json.getJSONObject(GitHubAccessorFieldNames.BASE.get());
                JSONObject targetRepository = target.getJSONObject(GitHubAccessorFieldNames.REPO.get());
                GithubPullRequestDto pullRequestDto = new GithubPullRequestDto(json.getString(GitHubAccessorFieldNames.NUMBER.get()), GithubRepositoryInfoDto.extractInfoFromFullName(sourceRepository.getString(GitHubAccessorFieldNames.FULL_NAME.get()), sourceRepository.getLong(GitHubAccessorFieldNames.ID.get()), source.getString(GitHubAccessorFieldNames.REF.get())), GithubRepositoryInfoDto.extractInfoFromFullName(targetRepository.getString(GitHubAccessorFieldNames.FULL_NAME.get()), targetRepository.getLong(GitHubAccessorFieldNames.ID.get()), target.getString(GitHubAccessorFieldNames.REF.get())));
                results.add(pullRequestDto);
            }
            return results;
        }
        catch (JSONException e) {
            log.debug((Object)"Invalid response received.", (Throwable)e);
            throw new GitHubException("The server returned invalid response. Cannot parse.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HttpResponse getStringFromUrl(String url) throws IOException {
        Get call = new Get(url);
        if (!this.onlyPublic) {
            call.setBasicCredentials(this.username, this.password);
        }
        try {
            call.execute();
            String response = IOUtils.toString((InputStream)call.getResponseAsStream(), (Charset)StandardCharsets.UTF_8);
            HttpResponse httpResponse = new HttpResponse(call.getStatusCode(), response, (Multimap<String, String>)call.getResponseHeaders());
            return httpResponse;
        }
        finally {
            call.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HttpResponse post(@NotNull String url, @NotNull String payload, @Nullable Multimap<String, String> headers) throws IOException {
        Post call = new Post(url);
        if (!this.onlyPublic) {
            call.setBasicCredentials(this.username, this.password);
        }
        try {
            if (headers != null) {
                for (String headerKey : headers.keySet()) {
                    headers.get((Object)headerKey).forEach(headerValue -> call.addRequestHeader(headerKey, headerValue));
                }
            }
            call.setRequestBody(payload.getBytes(), ContentType.APPLICATION_JSON);
            call.execute();
            String response = IOUtils.toString((InputStream)call.getResponseAsStream(), (Charset)StandardCharsets.UTF_8);
            HttpResponse httpResponse = new HttpResponse(call.getStatusCode(), response, (Multimap<String, String>)call.getResponseHeaders());
            return httpResponse;
        }
        finally {
            call.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HttpResponse delete(@NotNull String url, @Nullable Multimap<String, String> headers) throws IOException {
        Delete call = new Delete(url);
        if (!this.onlyPublic) {
            call.setBasicCredentials(this.username, this.password);
        }
        try {
            if (headers != null) {
                for (String headerKey : headers.keySet()) {
                    headers.get((Object)headerKey).forEach(headerValue -> call.addRequestHeader(headerKey, headerValue));
                }
            }
            call.execute();
            String response = call.getResponseBody() == null ? "" : IOUtils.toString((InputStream)call.getResponseAsStream(), (Charset)StandardCharsets.UTF_8);
            HttpResponse httpResponse = new HttpResponse(call.getStatusCode(), response, (Multimap<String, String>)call.getResponseHeaders());
            return httpResponse;
        }
        finally {
            call.release();
        }
    }

    private List<String> foldArrayAndSort(JSONArray repoJson, String field) throws GitHubException {
        return Ordering.natural().sortedCopy(this.foldArray(repoJson, field));
    }

    private Iterable<String> foldArray(JSONArray jsonArray, String field) throws GitHubException {
        try {
            ArrayList<String> results = new ArrayList<String>();
            for (int index = 0; index < jsonArray.length(); ++index) {
                JSONObject jsonRepository = jsonArray.getJSONObject(index);
                String repository = jsonRepository.getString(field);
                results.add(repository);
            }
            return results;
        }
        catch (JSONException e) {
            throw new GitHubException("The server returned invalid response (the field [" + field + "] not found in returned objects)");
        }
    }

    public static String transformBaseUrlToApiUrl(@Nullable String baseUrl) {
        return StringUtils.isBlank((CharSequence)baseUrl) || baseUrl.startsWith("https://github.com") ? GITHUB_API_BASE_URL : UrlUtils.appendSlashIfDoesntExist((String)baseUrl) + "api/v3/";
    }

    protected static class HttpResponse {
        private final int statusCode;
        private final String response;
        private final Multimap<String, String> headers;

        HttpResponse(int statusCode, String response, Multimap<String, String> headers) {
            this.response = response;
            this.headers = headers;
            this.statusCode = statusCode;
        }

        public int getStatusCode() {
            return this.statusCode;
        }

        public String getResponse() {
            return this.response;
        }

        public Multimap<String, String> getHeaders() {
            return this.headers;
        }
    }

    public static class GitHubException
    extends Exception {
        public GitHubException(String message) {
            super(message);
        }

        public GitHubException(JSONException e) {
            super((Throwable)e);
        }

        public boolean isAuthError() {
            return this.getMessage().equalsIgnoreCase("Bad credentials");
        }
    }

    private static enum GitHubAccessorFieldNames {
        HEAD,
        REPO,
        BASE,
        NUMBER,
        FULL_NAME,
        ID,
        REF,
        LOGIN,
        NAME,
        SHA;


        String get() {
            return this.name().toLowerCase();
        }
    }
}

