/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.git;

import com.atlassian.bamboo.plugins.git.GitRepositoryAccessData;
import com.google.common.annotations.VisibleForTesting;
import io.atlassian.util.concurrent.ManagedLock;
import io.atlassian.util.concurrent.ManagedLocks;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.Callable;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class GitCacheDirectory {
    private static final Logger log = Logger.getLogger(GitCacheDirectory.class);
    static final String GIT_REPOSITORY_CACHE_DIRECTORY = "_git-repositories-cache";
    static final Function<File, ManagedLock> cacheLockFactory = ManagedLocks.weakManagedLockFactory();

    private GitCacheDirectory() {
    }

    @NotNull
    public static File getCacheDirectoryRoot(@NotNull File workingDirectory) {
        return new File(workingDirectory, GIT_REPOSITORY_CACHE_DIRECTORY);
    }

    @NotNull
    public static File getCacheDirectory(@NotNull File workingDirectory, @NotNull GitRepositoryAccessData repositoryData) {
        return new File(GitCacheDirectory.getCacheDirectoryRoot(workingDirectory), GitCacheDirectory.calculateRepositorySha(repositoryData));
    }

    @NotNull
    public static Path getCachePath(@NotNull File workingDirectory, @NotNull GitRepositoryAccessData repositoryData) {
        String cacheRoot = GitCacheDirectory.getCacheDirectoryRoot(workingDirectory).getAbsolutePath();
        return Paths.get(cacheRoot, GitCacheDirectory.calculateRepositorySha(repositoryData));
    }

    @VisibleForTesting
    static String calculateRepositorySha(@NotNull GitRepositoryAccessData repositoryData) {
        return GitCacheDirectory.calculateAggregateSha(repositoryData.getRepositoryUrl(), repositoryData.getUsername());
    }

    static String calculateAggregateSha(String ... params) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        for (String param : params) {
            if (param != null) {
                try {
                    baos.write(param.getBytes(StandardCharsets.UTF_8));
                }
                catch (IOException e) {
                    throw new RuntimeException("Cannot happen: Error writing string to byte array", e);
                }
            }
            baos.write(0);
        }
        return DigestUtils.sha1Hex(baos.toByteArray());
    }

    public static ManagedLock getCacheLock(@NotNull File cache) {
        return new LoggingManagedLock(cacheLockFactory.apply(cache), cache);
    }

    private static class LoggingManagedLock
    implements ManagedLock {
        private final ManagedLock delegate;
        private final File lockedDir;

        public LoggingManagedLock(ManagedLock delegate, File lockedDir) {
            this.delegate = delegate;
            this.lockedDir = lockedDir;
        }

        public <R> R withLock(Callable<R> callable) throws Exception {
            if (!log.isDebugEnabled()) {
                return (R)this.delegate.withLock(callable);
            }
            this.beforeCall();
            try {
                Object object = this.delegate.withLock(callable);
                return (R)object;
            }
            finally {
                this.afterCall();
            }
        }

        private void beforeCall() {
            log.debug((Object)("GIT_CACHE_LOCKS: Acquiring lock for " + this.lockedDir.getAbsolutePath()));
        }

        private void afterCall() {
            log.debug((Object)("GIT_CACHE_LOCKS: Released lock for " + this.lockedDir.getAbsolutePath()));
        }

        public <R> R withLock(Supplier<R> supplier) {
            if (!log.isDebugEnabled()) {
                return (R)this.delegate.withLock(supplier);
            }
            this.beforeCall();
            try {
                Object object = this.delegate.withLock(supplier);
                return (R)object;
            }
            finally {
                this.afterCall();
            }
        }

        public void withLock(Runnable runnable) {
            if (!log.isDebugEnabled()) {
                this.delegate.withLock(runnable);
            }
            this.beforeCall();
            try {
                this.delegate.withLock(runnable);
            }
            finally {
                this.afterCall();
            }
        }
    }
}

