/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.artifact.export;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.bamboo.build.Job;
import com.atlassian.bamboo.chains.Chain;
import com.atlassian.bamboo.configuration.external.helpers.PlanImportHelper;
import com.atlassian.bamboo.deployments.environments.Environment;
import com.atlassian.bamboo.deployments.environments.InternalEnvironment;
import com.atlassian.bamboo.deployments.projects.DeploymentProject;
import com.atlassian.bamboo.deployments.projects.service.DeploymentProjectService;
import com.atlassian.bamboo.exception.RssPermissionException;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.PlanManager;
import com.atlassian.bamboo.plan.artifact.ArtifactDefinition;
import com.atlassian.bamboo.plan.artifact.ArtifactDefinitionManager;
import com.atlassian.bamboo.plan.artifact.ImmutableArtifactDefinitionBase;
import com.atlassian.bamboo.plan.branch.ChainBranchManager;
import com.atlassian.bamboo.plan.branch.ChainBranchUtils;
import com.atlassian.bamboo.plan.branch.VcsBranch;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.plan.cache.ImmutableChainBranch;
import com.atlassian.bamboo.plan.cache.ImmutableJob;
import com.atlassian.bamboo.plugin.ArtifactDownloaderTaskConfigurationHelper;
import com.atlassian.bamboo.security.BambooPermissionManager;
import com.atlassian.bamboo.security.acegi.acls.BambooPermission;
import com.atlassian.bamboo.specs.api.builders.plan.PlanIdentifier;
import com.atlassian.bamboo.specs.api.exceptions.PropertiesValidationException;
import com.atlassian.bamboo.specs.api.model.BambooKeyProperties;
import com.atlassian.bamboo.specs.api.model.deployment.DeploymentProperties;
import com.atlassian.bamboo.specs.api.model.plan.JobProperties;
import com.atlassian.bamboo.specs.api.model.plan.PlanIdentifierProperties;
import com.atlassian.bamboo.specs.api.model.plan.PlanProperties;
import com.atlassian.bamboo.specs.api.model.plan.StageProperties;
import com.atlassian.bamboo.specs.api.model.plan.artifact.ArtifactProperties;
import com.atlassian.bamboo.specs.api.model.task.TaskProperties;
import com.atlassian.bamboo.specs.api.validators.common.ValidationContext;
import com.atlassian.bamboo.specs.api.validators.common.ValidationProblem;
import com.atlassian.bamboo.specs.builders.task.ArtifactDownloaderTask;
import com.atlassian.bamboo.specs.builders.task.DownloadItem;
import com.atlassian.bamboo.specs.model.task.ArtifactDownloaderTaskProperties;
import com.atlassian.bamboo.specs.model.task.DownloadItemProperties;
import com.atlassian.bamboo.specs.yaml.ListNode;
import com.atlassian.bamboo.specs.yaml.MapNode;
import com.atlassian.bamboo.specs.yaml.Node;
import com.atlassian.bamboo.specs.yaml.StringNode;
import com.atlassian.bamboo.specs.yaml.YamlSpecsValidationException;
import com.atlassian.bamboo.task.TaskContainer;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.task.export.TaskDefinitionExporter;
import com.atlassian.bamboo.task.export.TaskValidationContext;
import com.atlassian.bamboo.user.BambooAuthenticationContext;
import com.atlassian.bamboo.util.BambooConstantUtils;
import com.atlassian.bamboo.utils.i18n.I18nBean;
import com.atlassian.plugin.spring.scanner.annotation.imports.BambooImport;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.acegisecurity.acls.Permission;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArtifactDownloaderTaskExporter
implements TaskDefinitionExporter {
    private static final ValidationContext VALIDATION_CONTEXT = ValidationContext.of((String)"Artifact download");
    @BambooImport
    @Inject
    private PlanManager planManager;
    @BambooImport
    @Inject
    private ArtifactDefinitionManager artifactDefinitionManager;
    @BambooImport
    @Inject
    private DeploymentProjectService deploymentProjectService;
    @BambooImport
    @Inject
    private BambooPermissionManager bambooPermissionManager;
    @BambooImport
    @Inject
    private BambooAuthenticationContext bambooAuthenticationContext;
    @BambooImport
    @Inject
    private ChainBranchManager chainBranchManager;

    @NotNull
    public Map<String, String> toTaskConfiguration(@NotNull TaskContainer taskContainer, @NotNull TaskProperties taskProperties) {
        return this.toTaskConfiguration(taskContainer, Collections.emptyList(), taskProperties, null);
    }

    @NotNull
    public Map<String, String> toTaskConfiguration(@NotNull TaskContainer taskContainer, @NotNull List<TaskDefinition> precedingTasks, @NotNull TaskProperties taskProperties, @Nullable VcsBranch importedBranch) {
        HashMap<String, String> configuration = new HashMap<String, String>();
        ArtifactDownloaderTaskProperties properties = (ArtifactDownloaderTaskProperties)taskProperties;
        PlanIdentifierProperties sourcePlanIdentifier = properties.getSourcePlan();
        Optional chain = sourcePlanIdentifier == null ? this.getAssociatedChain(taskContainer) : PlanImportHelper.findExistingPlanByOidOrKey((PlanIdentifierProperties)sourcePlanIdentifier, (PlanManager)this.planManager, Chain.class);
        if (!chain.isPresent()) {
            throw new PropertiesValidationException("Chain " + sourcePlanIdentifier + " does not exist.");
        }
        ImmutableChain sourcePlanOrBranch = this.getSourceBranch((ImmutableChain)chain.get(), importedBranch);
        ArtifactDownloaderTaskConfigurationHelper.setSourcePlanKey(configuration, (Object)sourcePlanOrBranch.getPlanKey().getKey());
        List artifacts = this.artifactDefinitionManager.findSharedArtifactsByChain(sourcePlanOrBranch);
        int index = 0;
        for (DownloadItemProperties downloadItem : properties.getArtifacts()) {
            ArtifactDownloaderTaskConfigurationHelper.setLocalPath(configuration, (int)index, (String)downloadItem.getPath());
            if (downloadItem.isAllArtifacts()) {
                ArtifactDownloaderTaskConfigurationHelper.setArtifactId(configuration, (int)index, (Object)"-1");
            } else {
                ArtifactDefinition artifactDefinition = this.findArtifactByName(artifacts, downloadItem.getArtifactName()).get();
                ArtifactDownloaderTaskConfigurationHelper.setArtifactId(configuration, (int)index, (Object)Long.toString(artifactDefinition.getId()));
                ArtifactDownloaderTaskConfigurationHelper.setArtifactName(configuration, (int)index, (Object)artifactDefinition.getName());
            }
            ++index;
        }
        return configuration;
    }

    private Optional<Chain> getAssociatedChain(TaskContainer taskContainer) {
        if (taskContainer instanceof Job) {
            return Optional.of(((Job)taskContainer).getParent());
        }
        if (taskContainer instanceof InternalEnvironment) {
            long deploymentProjectId = ((InternalEnvironment)taskContainer).getDeploymentProjectId();
            DeploymentProject deploymentProject = this.deploymentProjectService.getDeploymentProject(deploymentProjectId);
            if (deploymentProject != null && deploymentProject.getPlanKey() != null) {
                return Optional.ofNullable((Chain)this.planManager.getPlanByKey(deploymentProject.getPlanKey(), Chain.class));
            }
            return Optional.empty();
        }
        throw new IllegalStateException("Task container is neither job nor environment");
    }

    @Nullable
    private PlanKey getAssociatedChainKey(TaskContainer taskContainer) {
        if (taskContainer instanceof ImmutableJob) {
            return ((ImmutableJob)taskContainer).getParent().getPlanKey();
        }
        if (taskContainer instanceof InternalEnvironment) {
            long deploymentProjectId = ((InternalEnvironment)taskContainer).getDeploymentProjectId();
            DeploymentProject deploymentProject = this.deploymentProjectService.getDeploymentProject(deploymentProjectId);
            if (deploymentProject != null) {
                return deploymentProject.getPlanKey();
            }
            return null;
        }
        throw new IllegalStateException("Task container is neither job nor environment");
    }

    private Optional<Chain> getAssociatedChain(TaskValidationContext taskValidationContext) {
        if (taskValidationContext.getOwnerPlan().isPresent()) {
            return PlanImportHelper.findExistingPlanByOidOrKey((PlanProperties)((PlanProperties)taskValidationContext.getOwnerPlan().get()), (PlanManager)this.planManager, Chain.class);
        }
        if (taskValidationContext.getOwnerDeployment().isPresent()) {
            return PlanImportHelper.findExistingPlanByOidOrKey((PlanIdentifierProperties)((DeploymentProperties)taskValidationContext.getOwnerDeployment().get()).getPlan(), (PlanManager)this.planManager, Chain.class);
        }
        throw new IllegalStateException("Task container is neither job nor environment");
    }

    @NotNull
    public ArtifactDownloaderTask toSpecsEntity(@NotNull TaskDefinition taskDefinition) {
        Map configuration = taskDefinition.getConfiguration();
        ArtifactDownloaderTask builder = new ArtifactDownloaderTask();
        PlanKey planKey = PlanKeys.getPlanKey((String)((String)ArtifactDownloaderTaskConfigurationHelper.getSourcePlanKey((Map)configuration)));
        ImmutableChain chain = (ImmutableChain)this.planManager.getPlanByKey(planKey, Chain.class);
        if (chain == null) {
            throw new PropertiesValidationException(VALIDATION_CONTEXT.with("source plan"), "Chain " + planKey + " does not exist.");
        }
        builder.sourcePlan(new PlanIdentifier(PlanKeys.getProjectKeyPart((PlanKey)planKey), planKey.getPartialKey()));
        this.addDownloadItemsToSpec(chain, configuration, builder);
        return builder;
    }

    @NotNull
    public ArtifactDownloaderTask toSpecsEntity(@NotNull TaskContainer taskContainer, @NotNull TaskDefinition taskDefinition) {
        Map configuration = taskDefinition.getConfiguration();
        ArtifactDownloaderTask builder = new ArtifactDownloaderTask();
        PlanKey planKey = PlanKeys.getPlanKey((String)((String)ArtifactDownloaderTaskConfigurationHelper.getSourcePlanKey((Map)configuration)));
        ImmutableChain chain = (ImmutableChain)this.planManager.getPlanByKey(planKey, Chain.class);
        if (chain == null) {
            throw new PropertiesValidationException("Chain " + planKey + " does not exist.");
        }
        if (!chain.getPlanKey().equals((Object)this.getAssociatedChainKey(taskContainer))) {
            builder.sourcePlan(new PlanIdentifier(PlanKeys.getProjectKeyPart((PlanKey)planKey), planKey.getPartialKey()));
            if (taskContainer instanceof Environment) {
                throw new PropertiesValidationException(VALIDATION_CONTEXT.with("source plan"), "Invalid artifact source: it must be the same as plan associated with the deployment project");
            }
        }
        this.addDownloadItemsToSpec(chain, configuration, builder);
        return builder;
    }

    private void addDownloadItemsToSpec(@NotNull ImmutableChain artifactSource, Map<String, String> configuration, ArtifactDownloaderTask builder) {
        Map artsById = this.artifactDefinitionManager.findSharedArtifactsByChain(artifactSource).stream().collect(Collectors.toMap(ImmutableArtifactDefinitionBase::getId, Function.identity()));
        for (String artifactKey : ArtifactDownloaderTaskConfigurationHelper.getArtifactKeys(configuration)) {
            DownloadItem downloadItem = new DownloadItem();
            int i = ArtifactDownloaderTaskConfigurationHelper.getIndexFromKey((String)artifactKey);
            long artifactId = Long.parseLong(configuration.get(artifactKey));
            if (artifactId == -1L) {
                downloadItem.allArtifacts(true);
            } else if (artsById.containsKey(artifactId)) {
                String artifactName = ((ArtifactDefinition)artsById.get(artifactId)).getName();
                downloadItem.artifact(artifactName);
            } else {
                throw new IllegalStateException("Cannot find artifact with id: " + artifactId);
            }
            downloadItem.path(ArtifactDownloaderTaskConfigurationHelper.getLocalPath(configuration, (int)i));
            builder.artifacts(new DownloadItem[]{downloadItem});
        }
    }

    private Optional<ArtifactDefinition> findArtifactByName(List<ArtifactDefinition> artifacts, String name) {
        return artifacts.stream().filter(a -> name.equals(a.getName())).findFirst();
    }

    @NotNull
    public List<ValidationProblem> validate(@NotNull TaskValidationContext taskValidationContext, @NotNull TaskProperties taskProperties) {
        Optional chain;
        ArrayList<ValidationProblem> problems = new ArrayList<ValidationProblem>();
        ArtifactDownloaderTaskProperties properties = (ArtifactDownloaderTaskProperties)taskProperties;
        PlanIdentifierProperties sourcePlanIdentifier = properties.getSourcePlan();
        if (this.isDownloadingFromCurrentPlan(taskValidationContext, sourcePlanIdentifier)) {
            return this.validateForCurrentPlan(taskValidationContext, properties);
        }
        if (taskValidationContext.getOwnerDeployment().isPresent()) {
            this.validateUsesDeploymentPlan(problems, (DeploymentProperties)taskValidationContext.getOwnerDeployment().get(), properties);
            if (!problems.isEmpty()) {
                return problems;
            }
        }
        if (!(chain = sourcePlanIdentifier != null ? PlanImportHelper.findExistingPlanByOidOrKey((PlanIdentifierProperties)sourcePlanIdentifier, (PlanManager)this.planManager, Chain.class) : this.getAssociatedChain(taskValidationContext)).isPresent()) {
            problems.add(new ValidationProblem(VALIDATION_CONTEXT.with("source plan"), this.getI18nBean().getText("artifact.export.chain.missing"), new Object[]{sourcePlanIdentifier}));
        } else {
            ImmutableChain sourcePlanOrBranch = this.getSourceBranch((ImmutableChain)chain.get(), taskValidationContext.getImportedBranch().orElse(null));
            if (!this.bambooPermissionManager.hasPlanPermission((Permission)BambooPermission.READ, ((Chain)chain.get()).getPlanKey())) {
                problems.add(new ValidationProblem(VALIDATION_CONTEXT.with("source plan"), this.getI18nBean().getText("artifact.export.chain.unauthorized"), new Object[]{sourcePlanIdentifier}));
                return problems;
            }
            String projectKey = ((Chain)chain.get()).getProject().getKey();
            if (!taskValidationContext.getRssPermissions().isProjectAllowed(projectKey)) {
                throw new RssPermissionException("This repository doesn't have access to project " + projectKey, (Set)Sets.newHashSet((Object[])new String[]{projectKey}), null);
            }
            List artifacts = this.artifactDefinitionManager.findSharedArtifactsByChain(sourcePlanOrBranch);
            for (DownloadItemProperties downloadItem : properties.getArtifacts()) {
                Optional<ArtifactDefinition> artifactDefinition;
                if (downloadItem.isAllArtifacts() || (artifactDefinition = this.findArtifactByName(artifacts, downloadItem.getArtifactName())).isPresent()) continue;
                String availableArtifacts = artifacts.stream().map(ImmutableArtifactDefinitionBase::getName).collect(Collectors.joining(", "));
                problems.add(new ValidationProblem(VALIDATION_CONTEXT.with("artifact name"), this.getI18nBean().getText("artifact.export.artifact.missing"), new Object[]{downloadItem.getArtifactName(), ((Chain)chain.get()).getPlanKey(), availableArtifacts}));
            }
        }
        return problems;
    }

    @Nullable
    public <T extends TaskProperties> Node toYaml(@NotNull T genericTaskProperties) {
        if (genericTaskProperties instanceof ArtifactDownloaderTaskProperties) {
            ArtifactDownloaderTaskProperties taskProperties = (ArtifactDownloaderTaskProperties)genericTaskProperties;
            LinkedHashMap<String, Object> taskDataMap = new LinkedHashMap<String, Object>();
            taskDataMap.put(Config.ARTIFACTS, taskProperties.getArtifacts().stream().map(downloadItemProperties -> {
                LinkedHashMap<String, String> itemDataMap = new LinkedHashMap<String, String>();
                if (StringUtils.isNotBlank((CharSequence)downloadItemProperties.getPath())) {
                    itemDataMap.put(Config.DESTINATION, downloadItemProperties.getPath());
                }
                if (!downloadItemProperties.isAllArtifacts()) {
                    itemDataMap.put(Config.ARTIFACT_NAME, downloadItemProperties.getArtifactName());
                }
                return itemDataMap;
            }).collect(Collectors.toList()));
            if (taskProperties.getSourcePlan() != null) {
                String sourcePlanKey = PlanKeys.getPlanKey((String)taskProperties.getSourcePlan().getProjectKey().getKey(), (String)taskProperties.getSourcePlan().getKey().getKey()).getKey();
                taskDataMap.put(Config.SOURCE_PLAN, sourcePlanKey);
            }
            LinkedHashMap<String, LinkedHashMap<String, Object>> taskMap = new LinkedHashMap<String, LinkedHashMap<String, Object>>();
            taskMap.put(Config.YAML_ROOT, taskDataMap);
            return new MapNode(taskMap, ValidationContext.of((String)Config.YAML_ROOT));
        }
        return null;
    }

    @Nullable
    public ArtifactDownloaderTask fromYaml(@NotNull Node node, @NotNull TaskValidationContext context) {
        ArtifactDownloaderTask result = new ArtifactDownloaderTask();
        if (node instanceof StringNode) {
            if (Objects.equals(Config.YAML_ROOT, ((StringNode)node).get())) {
                result.artifacts(new DownloadItem[]{new DownloadItem().allArtifacts(true)});
                return result;
            }
        } else if (node instanceof MapNode) {
            Node innerTaskStructure = ((MapNode)node).getOptionalNode(Config.YAML_ROOT).orElse(null);
            if (innerTaskStructure == null) {
                return null;
            }
            if (innerTaskStructure instanceof MapNode) {
                Optional artifactsOptionalNode;
                MapNode innerTaskStructureMap = (MapNode)innerTaskStructure;
                String sourcePlan = innerTaskStructureMap.getOptionalString(Config.SOURCE_PLAN).map(StringNode::get).orElse(null);
                this.validateArtifactDownloadTask(sourcePlan, context.getOwnerPlan().isPresent());
                if (StringUtils.isNotBlank((CharSequence)sourcePlan)) {
                    try {
                        PlanKey planKey = PlanKeys.getPlanKey((String)sourcePlan);
                        result.sourcePlan(new PlanIdentifier(PlanKeys.getProjectKeyPart((PlanKey)planKey), PlanKeys.getPlanKeyPart((PlanKey)planKey)));
                    }
                    catch (Exception e) {
                        throw new YamlSpecsValidationException(e.getMessage(), (Throwable)e);
                    }
                }
                if ((artifactsOptionalNode = innerTaskStructureMap.getOptionalNode(Config.ARTIFACTS)).isPresent()) {
                    Node artifacts = (Node)artifactsOptionalNode.get();
                    if (artifacts instanceof ListNode) {
                        ListNode listNode = ((ListNode)artifacts).asListOf(MapNode.class);
                        result.artifacts((DownloadItem[])listNode.stream().map(this::getArtifactForDownloadTask).toArray(DownloadItem[]::new));
                        return result;
                    }
                    throw new PropertiesValidationException(artifacts.getValidationContext(), "Unknown configuration format of artifact download task");
                }
                DownloadItem artifact = this.getArtifactForDownloadTask(innerTaskStructureMap);
                result.artifacts(new DownloadItem[]{artifact});
                return result;
            }
            throw new PropertiesValidationException(innerTaskStructure.getValidationContext(), "Unknown configuration format of artifact download task");
        }
        return null;
    }

    @NotNull
    private DownloadItem getArtifactForDownloadTask(@NotNull MapNode innerTaskStructureMap) {
        DownloadItem downloadItem = new DownloadItem();
        innerTaskStructureMap.getOptionalString(Config.DESTINATION).map(StringNode::get).ifPresent(arg_0 -> ((DownloadItem)downloadItem).path(arg_0));
        String name = innerTaskStructureMap.getOptionalString(Config.ARTIFACT_NAME).map(StringNode::get).orElse(null);
        if (StringUtils.isBlank((CharSequence)name)) {
            downloadItem.allArtifacts(true);
        } else {
            downloadItem.artifact(name);
        }
        return downloadItem;
    }

    private void validateArtifactDownloadTask(@Nullable String sourcePlan, boolean isPlan) {
        if (StringUtils.isNotBlank((CharSequence)sourcePlan)) {
            if (isPlan) {
                try {
                    PlanKeys.getPlanKey((String)sourcePlan);
                }
                catch (Exception e) {
                    throw new YamlSpecsValidationException("Wrong plan key for " + Config.SOURCE_PLAN + " of " + Config.YAML_ROOT + " task: " + e.getMessage(), (Throwable)e);
                }
            } else {
                throw new YamlSpecsValidationException(Config.SOURCE_PLAN + " is not allowed for " + Config.YAML_ROOT + " task in deployment project");
            }
        }
    }

    @NotNull
    private ImmutableChain getSourceBranch(ImmutableChain sourcePlan, VcsBranch importedBranch) {
        if (sourcePlan instanceof ImmutableChainBranch) {
            return sourcePlan;
        }
        if (importedBranch != null) {
            for (ImmutableChainBranch branch : this.chainBranchManager.getBranchesForChain(sourcePlan)) {
                if (!ChainBranchUtils.getValidChainBranchName((String)importedBranch.getName()).equals(branch.getBuildName())) continue;
                if (branch.isDivergent()) {
                    return branch;
                }
                return sourcePlan;
            }
        }
        return sourcePlan;
    }

    private void validateUsesDeploymentPlan(List<ValidationProblem> problems, DeploymentProperties ownerDeployment, ArtifactDownloaderTaskProperties taskProperties) {
        PlanIdentifierProperties sourcePlan = taskProperties.getSourcePlan();
        if (sourcePlan != null && !Objects.equals(sourcePlan, ownerDeployment.getPlan())) {
            problems.add(new ValidationProblem(VALIDATION_CONTEXT.with("source plan"), this.getI18nBean().getText("artifact.export.deployment.invalid.plan")));
        }
    }

    private List<ValidationProblem> validateForCurrentPlan(TaskValidationContext taskValidationContext, ArtifactDownloaderTaskProperties taskProperties) {
        StageProperties stageProperties;
        ArrayList<ValidationProblem> problems = new ArrayList<ValidationProblem>();
        ArrayList<ArtifactProperties> sharedArtifacts = new ArrayList<ArtifactProperties>();
        BambooKeyProperties taskOwner = ((JobProperties)taskValidationContext.getOwnerJob().get()).toPlanIdentifier();
        Iterator iterator = ((PlanProperties)taskValidationContext.getOwnerPlan().get()).getStages().iterator();
        while (iterator.hasNext() && !(stageProperties = (StageProperties)iterator.next()).getJobs().stream().anyMatch(j -> taskOwner.equals((Object)j.getKey()))) {
            stageProperties.getJobs().stream().flatMap(j -> j.getArtifacts().stream()).filter(ArtifactProperties::isShared).forEach(sharedArtifacts::add);
        }
        for (DownloadItemProperties downloadItem : taskProperties.getArtifacts()) {
            Optional<ArtifactProperties> artifactDefinition;
            if (downloadItem.isAllArtifacts() || (artifactDefinition = this.findArtifactPropertiesByName(sharedArtifacts, downloadItem.getArtifactName())).isPresent()) continue;
            String availableArtifacts = sharedArtifacts.stream().map(ArtifactProperties::getName).collect(Collectors.joining(", "));
            problems.add(new ValidationProblem(VALIDATION_CONTEXT.with("artifact name"), this.getI18nBean().getText("artifact.export.preceding.stage"), new Object[]{downloadItem.getArtifactName(), availableArtifacts}));
        }
        return problems;
    }

    private Optional<ArtifactProperties> findArtifactPropertiesByName(List<ArtifactProperties> artifacts, String name) {
        return artifacts.stream().filter(a -> name.equals(a.getName())).findFirst();
    }

    private boolean isDownloadingFromCurrentPlan(TaskValidationContext taskValidationContext, @Nullable PlanIdentifierProperties sourcePlanIdentifier) {
        if (taskValidationContext.getOwnerPlan().isPresent()) {
            if (sourcePlanIdentifier == null) {
                return true;
            }
            if (sourcePlanIdentifier.isOidDefined() && Objects.equals(sourcePlanIdentifier.getOid(), ((PlanProperties)taskValidationContext.getOwnerPlan().get()).getOid()) || sourcePlanIdentifier.getProjectKey().equals((Object)((PlanProperties)taskValidationContext.getOwnerPlan().get()).getProject().getKey()) && Objects.equals(sourcePlanIdentifier.getKey(), ((PlanProperties)taskValidationContext.getOwnerPlan().get()).getKey())) {
                return true;
            }
        }
        return false;
    }

    public void setPlanManager(PlanManager planManager) {
        this.planManager = planManager;
    }

    public void setArtifactDefinitionManager(ArtifactDefinitionManager artifactDefinitionManager) {
        this.artifactDefinitionManager = artifactDefinitionManager;
    }

    public void setDeploymentProjectService(DeploymentProjectService deploymentProjectService) {
        this.deploymentProjectService = deploymentProjectService;
    }

    public void setBambooPermissionManager(BambooPermissionManager bambooPermissionManager) {
        this.bambooPermissionManager = bambooPermissionManager;
    }

    public void setBambooAuthenticationContext(BambooAuthenticationContext bambooAuthenticationContext) {
        this.bambooAuthenticationContext = bambooAuthenticationContext;
    }

    private I18nBean getI18nBean() {
        return this.bambooAuthenticationContext.getI18NBean();
    }

    @VisibleForTesting
    static interface Config {
        public static final String YAML_ROOT = (String)BambooConstantUtils.preventInlining((Object)"artifact-download");
        public static final String SOURCE_PLAN = (String)BambooConstantUtils.preventInlining((Object)"source-plan");
        public static final String ARTIFACTS = (String)BambooConstantUtils.preventInlining((Object)"artifacts");
        public static final String ARTIFACT_NAME = (String)BambooConstantUtils.preventInlining((Object)"name");
        public static final String DESTINATION = (String)BambooConstantUtils.preventInlining((Object)"destination");
    }
}

