/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.artifact;

import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.docker.DockerContainerServiceImpl;
import com.atlassian.bamboo.process.ExternalProcessBuilder;
import com.atlassian.bamboo.process.ProcessService;
import com.atlassian.bamboo.setup.HomeDirectoryLayout;
import com.atlassian.bamboo.task.CommonTaskContext;
import com.atlassian.bamboo.task.CommonTaskType;
import com.atlassian.bamboo.task.PreparationTask;
import com.atlassian.bamboo.task.TaskException;
import com.atlassian.bamboo.task.TaskResult;
import com.atlassian.bamboo.task.TaskResultBuilder;
import com.atlassian.bamboo.util.BambooFileUtils;
import com.atlassian.bamboo.util.BambooIOUtils;
import com.atlassian.bamboo.util.SecureTemporaryFiles;
import com.atlassian.bamboo.utils.BambooFiles;
import com.atlassian.bamboo.utils.BambooPathUtils;
import com.atlassian.bamboo.variable.VariableDefinitionContext;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.utils.process.ExternalProcess;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class CleanWorkingDirectoryTask
implements CommonTaskType,
PreparationTask {
    private static final Logger log = Logger.getLogger(CleanWorkingDirectoryTask.class);
    @Inject
    @ComponentImport
    private ProcessService processService;
    @Inject
    @ComponentImport
    private HomeDirectoryLayout homeDirectoryLayout;

    public TaskResult execute(@NotNull CommonTaskContext taskContext) throws TaskException {
        this.cleanWorkingDir(taskContext);
        return TaskResultBuilder.newBuilder((CommonTaskContext)taskContext).build();
    }

    private void cleanWorkingDir(CommonTaskContext taskContext) throws TaskException {
        BuildLogger buildLogger = taskContext.getBuildLogger();
        File workingDirectory = taskContext.getWorkingDirectory();
        if (BambooFileUtils.isDirectoryImportant((File)workingDirectory)) {
            String errorMessage = "Cleaning working directory cannot be run as the directory '" + workingDirectory.getAbsolutePath() + "' is reserved by the system. Please amend your task configuration.";
            log.warn((Object)buildLogger.addErrorLogEntry(errorMessage));
            throw new TaskException(errorMessage);
        }
        log.info((Object)buildLogger.addBuildLogEntry("Cleaning working directory '" + workingDirectory.getAbsolutePath() + "'"));
        if (workingDirectory.exists()) {
            try {
                this.runCleanInContainerIfNeeded(taskContext, workingDirectory);
                BambooPathUtils.cleanDirectory((Path)workingDirectory.toPath());
            }
            catch (TaskException | IOException e) {
                String errorMessage = "Unable to clean working directory '" + workingDirectory.getAbsolutePath() + "' " + e.getMessage();
                log.warn((Object)buildLogger.addErrorLogEntry(errorMessage), e);
                throw new TaskException(errorMessage, e);
            }
        }
    }

    private void runCleanInContainerIfNeeded(CommonTaskContext commonTaskContext, File workingDirectory) throws TaskException, IOException {
        VariableDefinitionContext dockerContainerId = (VariableDefinitionContext)commonTaskContext.getCommonContext().getVariableContext().getEffectiveVariables().get("auto.docker.container.name");
        if (dockerContainerId == null) {
            return;
        }
        try {
            String scriptName = "cleanDirectory.sh";
            try (BambooFiles.QuietlyRemoved temporaryFile = BambooFiles.quietlyRemoved((Path)this.createTemporaryFile("cleanDirectory.sh"));){
                BambooIOUtils.copy((InputStream)DockerContainerServiceImpl.class.getResourceAsStream("cleanDirectory.sh"), (OutputStream)Files.newOutputStream(temporaryFile.getPath(), new OpenOption[0]));
                ExternalProcess externalProcess = this.processService.executeExternalProcess(commonTaskContext, new ExternalProcessBuilder().workingDirectory(workingDirectory).command(Arrays.asList(temporaryFile.getPath().toString(), workingDirectory.getAbsolutePath())));
                int exitCode = externalProcess.getHandler().getExitCode();
                if (exitCode == 42) {
                    throw new TaskException("Unable to access agent's working directory [" + workingDirectory + "] from within the container");
                }
            }
        }
        catch (Exception e) {
            commonTaskContext.getBuildLogger().addErrorLogEntry("Failed to clean working directory from within the container ", (Throwable)e);
            throw e;
        }
    }

    private Path createTemporaryFile(String name) {
        SecureTemporaryFiles.FileSpecBuilder builder = SecureTemporaryFiles.builder().setDir(this.homeDirectoryLayout.getTempDirectory()).setPrefix(name).setExecutable(true);
        try {
            return SecureTemporaryFiles.createPath((SecureTemporaryFiles.TemporaryFileSpec)builder.build());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

