/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.artifact;

import com.atlassian.bamboo.chains.Chain;
import com.atlassian.bamboo.chains.events.ChainMovingEvent;
import com.atlassian.bamboo.deployments.environments.service.EnvironmentService;
import com.atlassian.bamboo.deployments.environments.service.EnvironmentServiceHelper;
import com.atlassian.bamboo.deployments.environments.service.EnvironmentTaskService;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanManager;
import com.atlassian.bamboo.plan.PlanPredicates;
import com.atlassian.bamboo.plan.cache.CachedPlanManager;
import com.atlassian.bamboo.plan.cache.ImmutableJob;
import com.atlassian.bamboo.plugin.ArtifactDownloaderTaskConfigurationHelper;
import com.atlassian.bamboo.plugin.BambooPluginUtils;
import com.atlassian.bamboo.task.TaskConfigurationService;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.event.api.EventListener;
import com.atlassian.plugin.spring.scanner.annotation.imports.BambooImport;
import com.google.common.base.Objects;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class ArtifactDownloaderTaskEventListener {
    @BambooImport
    private final PlanManager planManager;
    @BambooImport
    private final CachedPlanManager cachedPlanManager;
    @BambooImport
    private final EnvironmentService environmentService;
    @BambooImport
    private final EnvironmentTaskService environmentTaskService;
    @BambooImport
    private final TaskConfigurationService taskConfigurationService;

    public ArtifactDownloaderTaskEventListener(PlanManager planManager, CachedPlanManager cachedPlanManager, EnvironmentService environmentService, EnvironmentTaskService environmentTaskService, TaskConfigurationService taskConfigurationService) {
        this.planManager = planManager;
        this.cachedPlanManager = cachedPlanManager;
        this.environmentService = environmentService;
        this.environmentTaskService = environmentTaskService;
        this.taskConfigurationService = taskConfigurationService;
    }

    @EventListener
    public void onChainMoving(@NotNull ChainMovingEvent event) {
        this.upgradeArtifactDownloaderTaskPlanConfiguration(event.getOriginalPlanKey(), event.getNewPlanKey());
        this.upgradeArtifactDownloaderTaskEnvironmentConfiguration(event.getOriginalPlanKey(), event.getNewPlanKey());
    }

    private void upgradeArtifactDownloaderTaskPlanConfiguration(@NotNull PlanKey originalPlanKey, @NotNull PlanKey newPlanKey) {
        for (ImmutableJob job : this.getAllJobs(newPlanKey)) {
            job.getBuildDefinition().getTaskDefinitions().stream().filter(BambooPluginUtils.pluginKeyEquals((String)"com.atlassian.bamboo.plugins.bamboo-artifact-downloader-plugin:artifactdownloadertask")).filter(task -> Objects.equal((Object)ArtifactDownloaderTaskConfigurationHelper.getSourcePlanKey((Map)task.getConfiguration()), (Object)originalPlanKey.getKey())).forEach(taskDefinition -> {
                ArtifactDownloaderTaskConfigurationHelper.setSourcePlanKey((Map)taskDefinition.getConfiguration(), (Object)newPlanKey.getKey());
                this.taskConfigurationService.editTask(job.getPlanKey(), taskDefinition.getId(), taskDefinition.getUserDescription(), taskDefinition.isEnabled(), taskDefinition.getConditions(), taskDefinition.getConfiguration(), taskDefinition.getRootDirectorySelector());
            });
        }
    }

    private Collection<ImmutableJob> getAllJobs(PlanKey newPlanKey) {
        List jobs = this.cachedPlanManager.getPlans(ImmutableJob.class).stream().filter(PlanPredicates::planIsMaster).collect(Collectors.toCollection(ArrayList::new));
        Chain movedChain = (Chain)this.planManager.getPlanByKey(newPlanKey, Chain.class);
        if (movedChain != null) {
            jobs.addAll(movedChain.getAllJobs());
        }
        return jobs;
    }

    private void upgradeArtifactDownloaderTaskEnvironmentConfiguration(@NotNull PlanKey originalPlanKey, @NotNull PlanKey newPlanKey) {
        EnvironmentServiceHelper.applyConsumerToAllInternalEnvironmentsNoUserContext((EnvironmentService)this.environmentService, environment -> {
            for (TaskDefinition taskDefinition : BambooPluginUtils.filterTasks((Iterable)environment.getTaskDefinitions(), (String)"com.atlassian.bamboo.plugins.bamboo-artifact-downloader-plugin:artifactdownloadertask")) {
                String taskPlanKey = (String)ArtifactDownloaderTaskConfigurationHelper.getSourcePlanKey((Map)taskDefinition.getConfiguration());
                if (!Objects.equal((Object)taskPlanKey, (Object)originalPlanKey.getKey())) continue;
                ArtifactDownloaderTaskConfigurationHelper.setSourcePlanKey((Map)taskDefinition.getConfiguration(), (Object)newPlanKey.getKey());
                this.environmentTaskService.editTask(environment.getId(), taskDefinition.getId(), taskDefinition.getUserDescription(), taskDefinition.isEnabled(), taskDefinition.getConditions(), taskDefinition.getConfiguration());
            }
        });
    }
}

