/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.artifact;

import com.atlassian.bamboo.collections.ActionParametersMap;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.artifact.ArtifactDefinition;
import com.atlassian.bamboo.plan.artifact.ArtifactDefinitionManager;
import com.atlassian.bamboo.plan.cache.CachedPlanManager;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.plugin.ArtifactDownloaderTaskConfigurationHelper;
import com.atlassian.bamboo.plugins.artifact.ArtifactOption;
import com.atlassian.bamboo.security.BambooPermissionManager;
import com.atlassian.bamboo.security.acegi.acls.BambooPermission;
import com.atlassian.bamboo.task.AbstractTaskConfigurator;
import com.atlassian.bamboo.task.TaskContextHelper;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.inject.Inject;
import org.acegisecurity.acls.Permission;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArtifactDownloaderTaskConfigurator
extends AbstractTaskConfigurator {
    private static final Logger log = Logger.getLogger(ArtifactDownloaderTaskConfigurator.class);
    private static final String ARTIFACTS = "artifacts";
    private static final String KEYS = "keys";
    private static final long NEW_ITEM_ID = 869576137068L;
    static final long ALL_ARTIFACTS_ID = -1L;
    @Inject
    private ArtifactDefinitionManager artifactDefinitionManager;
    @Inject
    private CachedPlanManager cachedPlanManager;
    @Inject
    private BambooPermissionManager bambooPermissionManager;

    @NotNull
    public Map<String, String> generateTaskConfigMap(@NotNull ActionParametersMap params, @Nullable TaskDefinition previousTaskDefinition) {
        Map config = super.generateTaskConfigMap(params, previousTaskDefinition);
        params.getParameters();
        this.saveArtifacts(params, config);
        String sourcePlanKey = params.getString("sourcePlanKey");
        if (sourcePlanKey != null) {
            ArtifactDownloaderTaskConfigurationHelper.setSourcePlanKey((Map)config, (Object)sourcePlanKey);
        }
        return config;
    }

    private void saveArtifacts(@NotNull ActionParametersMap params, @NotNull Map<String, String> config) {
        for (String artifactKey : ArtifactDownloaderTaskConfigurationHelper.getArtifactKeys((Map)params.getParameters())) {
            ArtifactDefinition artifactDefinition;
            int index = ArtifactDownloaderTaskConfigurationHelper.getIndexFromKey((String)artifactKey);
            String idValue = params.getString(artifactKey);
            config.put(artifactKey, idValue);
            long id = Long.parseLong(idValue);
            if (id == -1L || (artifactDefinition = this.artifactDefinitionManager.findArtifactDefinition(id)) == null) continue;
            ArtifactDownloaderTaskConfigurationHelper.setArtifactName(config, (int)index, (Object)artifactDefinition.getName());
        }
        for (String pathKey : ArtifactDownloaderTaskConfigurationHelper.getPathKeys((Map)params.getParameters())) {
            config.put(pathKey, params.getString(pathKey));
        }
        for (String transferKey : ArtifactDownloaderTaskConfigurationHelper.getTransferKeys((Map)params.getParameters())) {
            config.put(transferKey, params.getString(transferKey));
        }
    }

    private int loadArtifacts(@NotNull ImmutableChain chain, @NotNull Map<String, String> config, @NotNull Map<String, Object> context) {
        int nextTransferId = 0;
        TreeSet<Integer> keys = new TreeSet<Integer>();
        List artifacts = this.artifactDefinitionManager.findSharedArtifactsByChain(chain);
        Iterable artifactKeys = ArtifactDownloaderTaskConfigurationHelper.getArtifactKeys(config);
        for (String artifactKey : artifactKeys) {
            int i = ArtifactDownloaderTaskConfigurationHelper.getIndexFromKey((String)artifactKey);
            String artifactName = ArtifactDownloaderTaskConfigurationHelper.getArtifactName(config, (int)i);
            if (i > nextTransferId) {
                nextTransferId = i + 1;
            }
            ArrayList<ArtifactOption> existingArtifactOptions = new ArrayList<ArtifactOption>();
            long artifactId = Long.parseLong(config.get(artifactKey));
            existingArtifactOptions.add(new ArtifactOption(-1L, this.getI18nBean().getText("artifact.downloader.all.artifacts"), ""));
            boolean foundById = false;
            if (artifactId == -1L) {
                context.put(artifactKey, -1L);
                foundById = true;
            }
            for (ArtifactDefinition artifact : artifacts) {
                existingArtifactOptions.add(new ArtifactOption(artifact.getId(), artifact.getName(), "Individual Artifacts"));
                if (artifactId != artifact.getId()) continue;
                context.put(artifactKey, artifact.getId());
                foundById = true;
            }
            if (!foundById) {
                for (ArtifactDefinition artifact : artifacts) {
                    if (!artifact.getName().equals(artifactName)) continue;
                    context.put(artifactKey, artifact.getId());
                }
            }
            context.put("artifacts_" + i, existingArtifactOptions);
            keys.add(i);
        }
        if (Iterables.isEmpty((Iterable)artifactKeys)) {
            keys.add(0);
            context.put(String.format("%s_%d", ARTIFACTS, 0), this.getArtifactOptions(artifacts));
            context.put(ArtifactDownloaderTaskConfigurationHelper.getArtifactIdKey((int)0), -1L);
        }
        context.put(KEYS, keys);
        for (String pathKey : ArtifactDownloaderTaskConfigurationHelper.getPathKeys(config)) {
            context.put(pathKey, config.get(pathKey));
        }
        return nextTransferId;
    }

    private List<ArtifactOption> getArtifactOptions(List<ArtifactDefinition> artifacts) {
        ArrayList<ArtifactOption> artifactOptions = new ArrayList<ArtifactOption>();
        artifactOptions.add(new ArtifactOption(-1L, this.getI18nBean().getText("artifact.downloader.all.artifacts"), ""));
        for (ArtifactDefinition artifact : artifacts) {
            artifactOptions.add(new ArtifactOption(artifact.getId(), artifact.getName(), "Individual Artifacts"));
        }
        return artifactOptions;
    }

    public void populateContextForCreate(@NotNull Map<String, Object> context) {
        super.populateContextForCreate(context);
        this.populateCommonConfig(context, true);
        context.put("nextTransferId", 0L);
    }

    public void populateContextForEdit(@NotNull Map<String, Object> context, @NotNull TaskDefinition taskDefinition) {
        context.put("nextTransferId", 0L);
        super.populateContextForEdit(context, taskDefinition);
        this.populateCommonConfig(context, false);
        this.populateConfig(context, taskDefinition);
    }

    private void populateCommonConfig(Map<String, Object> context, boolean initialiseArtifactSelectors) {
        if (TaskContextHelper.isDeploymentMode(context) && initialiseArtifactSelectors) {
            ImmutablePlan relatedPlan = TaskContextHelper.getRelatedPlan(context);
            if (relatedPlan != null) {
                ArtifactDownloaderTaskConfigurationHelper.setSourcePlanKey(context, (Object)relatedPlan.getPlanKey());
                ImmutableChain chain = (ImmutableChain)Narrow.to((Object)relatedPlan, ImmutableChain.class);
                if (chain != null) {
                    this.loadArtifacts(chain, new HashMap<String, String>(), context);
                }
            } else {
                log.error((Object)"Unable to find related plan in context");
            }
        }
        context.put("artifacts_869576137068", this.getArtifactOptions(Collections.emptyList()));
    }

    private void populateConfig(Map<String, Object> context, TaskDefinition taskDefinition) {
        String sourcePlanKey = (String)ArtifactDownloaderTaskConfigurationHelper.getSourcePlanKey((Map)taskDefinition.getConfiguration());
        if (sourcePlanKey != null) {
            ArtifactDownloaderTaskConfigurationHelper.setSourcePlanKey(context, (Object)sourcePlanKey);
            PlanKey planKey = PlanKeys.getPlanKey((String)sourcePlanKey);
            ImmutablePlan plan = this.cachedPlanManager.getPlanByKey(planKey);
            ImmutableChain chain = (ImmutableChain)Narrow.to((Object)plan, ImmutableChain.class);
            if (chain != null) {
                int nextTransferId = this.loadArtifacts(chain, taskDefinition.getConfiguration(), context);
                context.put("nextTransferId", nextTransferId);
            } else {
                log.error((Object)("Unable to find plan for key: " + sourcePlanKey));
            }
        } else {
            log.error((Object)"Unable to populate config, sourcePlanKey undefined");
        }
    }

    public void validate(@NotNull ActionParametersMap params, @NotNull ErrorCollection errorCollection) {
        super.validate(params, errorCollection);
        String key = params.getString("sourcePlanKey");
        if (StringUtils.isNotBlank((CharSequence)key)) {
            try {
                PlanKey planKey = PlanKeys.getPlanKey((String)key);
                if (!this.bambooPermissionManager.hasPlanPermission((Permission)BambooPermission.READ, planKey)) {
                    errorCollection.addError("sourcePlanKey", this.getI18nBean().getText("artifact.downloader.plan.unauthorized"));
                }
            }
            catch (IllegalArgumentException ex) {
                errorCollection.addError("sourcePlanKey", this.getI18nBean().getText("artifact.downloader.plan.invalid.key"));
            }
        } else {
            errorCollection.addError("sourcePlanKey", this.getI18nBean().getText("artifact.downloader.plan.empty"));
        }
    }

    @Deprecated
    public void setArtifactDefinitionManager(ArtifactDefinitionManager artifactDefinitionManager) {
        this.artifactDefinitionManager = artifactDefinitionManager;
    }

    @Deprecated
    public void setCachedPlanManager(CachedPlanManager cachedPlanManager) {
        this.cachedPlanManager = cachedPlanManager;
    }

    @Deprecated
    public void setBambooPermissionManager(BambooPermissionManager bambooPermissionManager) {
        this.bambooPermissionManager = bambooPermissionManager;
    }
}

