/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.artifact;

import com.atlassian.bamboo.artifact.Artifact;
import com.atlassian.bamboo.build.artifact.ArtifactManager;
import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.configuration.ConfigurationMap;
import com.atlassian.bamboo.deployments.execution.DeploymentTaskContext;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.PlanResultKey;
import com.atlassian.bamboo.plan.artifact.ArtifactDefinitionContext;
import com.atlassian.bamboo.plugin.ArtifactDownloaderTaskConfigurationHelper;
import com.atlassian.bamboo.plugin.descriptor.ArtifactHandlerModuleDescriptorImpl;
import com.atlassian.bamboo.plugins.artifact.AvailableArtifacts;
import com.atlassian.bamboo.plugins.artifact.RequestedArtifacts;
import com.atlassian.bamboo.task.CommonTaskContext;
import com.atlassian.bamboo.task.CommonTaskType;
import com.atlassian.bamboo.task.DeploymentTaskContextImpl;
import com.atlassian.bamboo.task.TaskException;
import com.atlassian.bamboo.task.TaskResult;
import com.atlassian.bamboo.task.TaskResultBuilder;
import com.atlassian.bamboo.task.TaskState;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.util.UrlUtils;
import com.atlassian.bamboo.v2.build.BuildContextHelper;
import com.atlassian.bamboo.v2.build.CommonContext;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public class ArtifactDownloaderTask
implements CommonTaskType {
    @VisibleForTesting
    public static final String DEPLOYMENT_FAIL_MESSAGE = "This deployment task inherits artifact handler configuration from the source plan.";
    public static final String ENABLED_ARTIFACT_HANDLERS_MESSAGE = "The following handlers are enabled for transferring shared artifacts:";
    @ComponentImport
    private final ArtifactManager artifactManager;

    public ArtifactDownloaderTask(ArtifactManager artifactManager) {
        this.artifactManager = artifactManager;
    }

    private static boolean isEnabledForShared(Map.Entry<String, String> e) {
        return e.getKey().endsWith((String)ArtifactHandlerModuleDescriptorImpl.SHARED_NON_SHARED_ONOFF_OPTION_NAME.get(Boolean.TRUE)) && Boolean.valueOf(e.getValue()).equals(Boolean.TRUE);
    }

    @NotNull
    public TaskResult execute(@NotNull CommonTaskContext taskContext) throws TaskException {
        RequestedArtifacts requestedArtifactContexts;
        TaskResultBuilder taskResultBuilder = TaskResultBuilder.newBuilder((CommonTaskContext)taskContext);
        BuildLogger buildLogger = taskContext.getBuildLogger();
        ConfigurationMap config = taskContext.getConfigurationMap();
        boolean failOnMissing = true;
        Map runtimeTaskContext = taskContext.getRuntimeTaskContext();
        if (runtimeTaskContext == null) {
            String errorMessage = "Unable to download artifacts: missing runtime context";
            buildLogger.addErrorLogEntry("Unable to download artifacts: missing runtime context");
            return taskResultBuilder.failedWithError().build();
        }
        String resultKey = (String)runtimeTaskContext.get("resultKey");
        if (StringUtils.isBlank((CharSequence)resultKey)) {
            String errorMessage = "Unable to download artifacts: result key of the last successful build is [" + resultKey + "]";
            buildLogger.addErrorLogEntry(errorMessage);
            return taskResultBuilder.failedWithError().build();
        }
        PlanResultKey planResultKey = PlanKeys.getPlanResultKey((String)resultKey);
        String securityToken = (String)runtimeTaskContext.get("securityToken");
        LinkedHashSet configArtifactKeys = Sets.newLinkedHashSet((Iterable)ArtifactDownloaderTaskConfigurationHelper.getArtifactKeys((Map)config));
        if (!this.isAllArtifactDataValid(taskContext, buildLogger, config, true, configArtifactKeys, requestedArtifactContexts = (RequestedArtifacts)taskContext.getRuntimeTaskData().get("artifactContexts"))) {
            return taskResultBuilder.failedWithError().build();
        }
        return this.downloadAllArtifacts(taskContext, taskResultBuilder, buildLogger, true, planResultKey, securityToken, requestedArtifactContexts);
    }

    private boolean isAllArtifactDataValid(@NotNull CommonTaskContext taskContext, BuildLogger buildLogger, ConfigurationMap config, boolean failOnMissing, Set<String> configArtifactKeys, RequestedArtifacts requestedArtifactContexts) {
        for (String artifactKey : configArtifactKeys) {
            int keyIndex;
            List<RequestedArtifacts.Request> runtimeDataForKey;
            boolean isAllArtifacts = Long.valueOf((String)config.get((Object)artifactKey)).equals(-1L);
            if (isAllArtifacts || !CollectionUtils.isEmpty(runtimeDataForKey = requestedArtifactContexts.getRequestsForKeyIndex(keyIndex = ArtifactDownloaderTaskConfigurationHelper.getIndexFromKey((String)artifactKey)))) continue;
            String artifactName = (String)config.get((Object)ArtifactDownloaderTaskConfigurationHelper.getArtifactNameKey((int)keyIndex));
            String errorMessage = "Data for artifact " + (Serializable)(artifactName != null ? artifactName : Integer.valueOf(keyIndex)) + " is missing from runtime context";
            buildLogger.addErrorLogEntry(errorMessage);
            if (!failOnMissing) continue;
            this.dumpConfigurationToLog(buildLogger, taskContext);
            return false;
        }
        return true;
    }

    private TaskResult downloadAllArtifacts(@NotNull CommonTaskContext taskContext, TaskResultBuilder taskResultBuilder, BuildLogger buildLogger, boolean failOnMissing, PlanResultKey planResultKey, String securityToken, RequestedArtifacts requestedArtifactContexts) {
        for (RequestedArtifacts.Request downloadRequest : requestedArtifactContexts.getAllRequests()) {
            ArtifactDefinitionContext artifactContext = downloadRequest.getContext();
            String localPath = downloadRequest.getLocalPath();
            Stopwatch stopWatch = Stopwatch.createStarted();
            buildLogger.addBuildLogEntry("Preparing to download plan result " + planResultKey + " artifact: " + artifactContext);
            Map artifactHandlerConfiguration = BuildContextHelper.getArtifactHandlerConfiguration((CommonContext)taskContext.getCommonContext());
            artifactHandlerConfiguration.put("ARTIFACT_SECURITY_TOKEN", securityToken);
            boolean downloadResult = this.artifactManager.retrieve(buildLogger, planResultKey, taskContext.getCommonContext().getResultKey(), artifactContext, localPath, artifactHandlerConfiguration, BuildContextHelper.getBuildWorkingDirectory((CommonContext)taskContext.getCommonContext()), this.getAvailableArtifacts(taskContext));
            if (!downloadResult) {
                this.logArtifactHandlersMessage(artifactHandlerConfiguration, artifactContext, taskContext, buildLogger);
                if (!failOnMissing) continue;
                this.dumpConfigurationToLog(buildLogger, taskContext);
                return taskResultBuilder.failedWithError().build();
            }
            String niceLocalPath = StringUtils.isNotEmpty((CharSequence)localPath) ? UrlUtils.appendSlashIfDoesntExist((String)localPath) : "working directory";
            buildLogger.addBuildLogEntry("Artifact [" + artifactContext.getName() + "] downloaded successfully in " + stopWatch + " to " + niceLocalPath);
        }
        return taskResultBuilder.setState(TaskState.SUCCESS).build();
    }

    private void logArtifactHandlersMessage(Map<String, String> artifactHandlerConfiguration, ArtifactDefinitionContext artifactContext, CommonTaskContext taskContext, BuildLogger buildLogger) {
        List<String> artifactHandlersEnabledForShared = artifactHandlerConfiguration.entrySet().stream().filter(ArtifactDownloaderTask::isEnabledForShared).map(Map.Entry::getKey).map(s -> s.replace(":" + (String)ArtifactHandlerModuleDescriptorImpl.SHARED_NON_SHARED_ONOFF_OPTION_NAME.get(Boolean.TRUE), "")).collect(Collectors.toList());
        boolean isDeploymentTask = taskContext instanceof DeploymentTaskContextImpl;
        String artifactHandlerConfSource = this.getArtifactHandlersConfSource(artifactHandlerConfiguration);
        buildLogger.addErrorLogEntry("Unable to download artifact " + artifactContext);
        if (isDeploymentTask) {
            buildLogger.addErrorLogEntry(DEPLOYMENT_FAIL_MESSAGE);
        }
        buildLogger.addErrorLogEntry("The plan is using " + artifactHandlerConfSource + " artifact handlers configuration. ");
        buildLogger.addErrorLogEntry(ENABLED_ARTIFACT_HANDLERS_MESSAGE);
        artifactHandlersEnabledForShared.forEach(arg_0 -> ((BuildLogger)buildLogger).addErrorLogEntry(arg_0));
    }

    @NotNull
    private String getArtifactHandlersConfSource(Map<String, String> artifactHandlerConfiguration) {
        boolean isCustomArtifactHandlerSettings = Boolean.parseBoolean(artifactHandlerConfiguration.getOrDefault("custom.artifactHandlers.useCustomArtifactHandlers", Boolean.FALSE.toString()));
        return isCustomArtifactHandlerSettings ? "custom" : "global";
    }

    private void dumpConfigurationToLog(BuildLogger buildLogger, CommonTaskContext taskContext) {
        ConfigurationMap configurationMap = taskContext.getConfigurationMap();
        buildLogger.addBuildLogEntry("Task configuration:");
        for (Map.Entry entry : configurationMap.entrySet()) {
            buildLogger.addBuildLogEntry((String)entry.getKey() + " -> [" + (String)entry.getValue() + "]");
        }
        Map runtimeContext = taskContext.getRuntimeTaskContext();
        buildLogger.addBuildLogEntry("Task runtime configuration:");
        for (Map.Entry entry : runtimeContext.entrySet()) {
            buildLogger.addBuildLogEntry((String)entry.getKey() + " -> [" + (String)entry.getValue() + "]");
        }
    }

    @Nullable
    private Multimap<String, Artifact> getAvailableArtifacts(CommonTaskContext taskContext) {
        DeploymentTaskContext deploymentTaskContext = (DeploymentTaskContext)Narrow.downTo((Object)taskContext, DeploymentTaskContext.class);
        if (deploymentTaskContext != null) {
            return deploymentTaskContext.getDeploymentContext().getVersionArtifacts();
        }
        AvailableArtifacts availableArtifacts = (AvailableArtifacts)Narrow.reinterpret(taskContext.getRuntimeTaskData().get("availableArtifacts"), AvailableArtifacts.class);
        return availableArtifacts.getArtifacts();
    }
}

