/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.artifact;

import com.atlassian.bamboo.Key;
import com.atlassian.bamboo.artifact.Artifact;
import com.atlassian.bamboo.artifact.CommonContextHelperService;
import com.atlassian.bamboo.build.artifact.ArtifactLinkManager;
import com.atlassian.bamboo.builder.BuildState;
import com.atlassian.bamboo.deployments.execution.DeploymentContext;
import com.atlassian.bamboo.deployments.versions.service.DeploymentVersionService;
import com.atlassian.bamboo.plan.IncorrectPlanTypeException;
import com.atlassian.bamboo.plan.PlanIdentifier;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.PlanResultKey;
import com.atlassian.bamboo.plan.artifact.ArtifactDefinitionContext;
import com.atlassian.bamboo.plan.artifact.ArtifactDefinitionContextImpl;
import com.atlassian.bamboo.plan.artifact.ArtifactDefinitionManager;
import com.atlassian.bamboo.plan.artifact.ImmutableArtifactDefinition;
import com.atlassian.bamboo.plan.artifact.ImmutableArtifactDefinitionBase;
import com.atlassian.bamboo.plan.branch.ChainBranchUtils;
import com.atlassian.bamboo.plan.cache.CachedPlanManager;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.plan.cache.ImmutableChainBranch;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.plugin.ArtifactDownloaderTaskConfigurationHelper;
import com.atlassian.bamboo.plugins.artifact.AvailableArtifacts;
import com.atlassian.bamboo.plugins.artifact.RequestedArtifacts;
import com.atlassian.bamboo.resultsummary.ImmutableResultsSummary;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.resultsummary.ResultsSummaryCriteria;
import com.atlassian.bamboo.resultsummary.ResultsSummaryCriteriaBuilder;
import com.atlassian.bamboo.resultsummary.ResultsSummaryManager;
import com.atlassian.bamboo.security.SecureTokenService;
import com.atlassian.bamboo.serialization.WhitelistedSerializable;
import com.atlassian.bamboo.task.RuntimeTaskDataProvider;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.task.runtime.RuntimeTaskDefinition;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.utils.SystemProperty;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.atlassian.bamboo.v2.build.CommonContext;
import com.atlassian.bamboo.v2.build.trigger.DependencyTriggerReason;
import com.atlassian.bamboo.variable.CustomVariableContext;
import com.atlassian.plugin.spring.scanner.annotation.imports.BambooImport;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArtifactDownloaderRuntimeDataProvider
implements RuntimeTaskDataProvider {
    private static final Logger log = Logger.getLogger(ArtifactDownloaderRuntimeDataProvider.class);
    static final String RESULT_KEY = "resultKey";
    static final String PLAN_OR_BRANCH_KEY = "sourcePlanOrBranchKey";
    static final String ARTIFACT_LOCATION = "artifactLocation";
    static final String SECURITY_TOKEN = "securityToken";
    @BambooImport
    @Inject
    private CachedPlanManager cachedPlanManager;
    @BambooImport
    @Inject
    private ResultsSummaryManager resultsSummaryManager;
    @BambooImport
    @Inject
    private ArtifactDefinitionManager artifactDefinitionManager;
    @BambooImport
    @Inject
    private SecureTokenService secureTokenService;
    @BambooImport
    @Inject
    private DeploymentVersionService deploymentVersionService;
    @BambooImport
    @Inject
    private ArtifactLinkManager artifactLinkManager;
    @BambooImport
    @Inject
    private CommonContextHelperService commonContextHelperService;
    @BambooImport
    @Inject
    private CustomVariableContext customVariableContext;

    @NotNull
    public Map<String, String> populateRuntimeTaskData(@NotNull TaskDefinition taskDefinition, @NotNull CommonContext commonContext) {
        ImmutableChain sourcePlanOrBranch;
        HashMap<String, String> result = new HashMap<String, String>();
        Map taskConfiguration = taskDefinition.getConfiguration();
        String sourcePlanKeyStr = (String)ArtifactDownloaderTaskConfigurationHelper.getSourcePlanKey((Map)taskConfiguration);
        if (sourcePlanKeyStr == null) {
            return result;
        }
        try {
            ImmutableChain sourcePlan = this.getSourcePlan(commonContext, sourcePlanKeyStr);
            sourcePlanOrBranch = this.getSourceBranch(sourcePlan, commonContext);
        }
        catch (IncorrectPlanTypeException e) {
            log.warn((Object)("Unable to find plan [" + sourcePlanKeyStr + "]"));
            throw e;
        }
        if (sourcePlanOrBranch == null) {
            String message = "Unable to find plan [" + sourcePlanKeyStr + "]";
            log.warn((Object)message);
            throw new IllegalStateException(message);
        }
        PlanResultKey sourcePlanResultKey = this.getSourcePlanResultKey(commonContext, sourcePlanOrBranch, SystemProperty.ARTIFACT_DOWNLOAD_IGNORES_SUCCESS_RESULT_REQUIREMENT.getTypedValue() && !taskDefinition.getConditions().isEmpty());
        if (sourcePlanResultKey == null) {
            String message = "Unable to find at least one successful result for plan: " + sourcePlanOrBranch.getPlanKey();
            log.warn((Object)message);
            throw new IllegalArgumentException(message);
        }
        this.commonContextHelperService.addPlanInformation(commonContext, sourcePlanResultKey.getPlanKey());
        result.put(PLAN_OR_BRANCH_KEY, sourcePlanOrBranch.getPlanKey().getKey());
        result.put(RESULT_KEY, sourcePlanResultKey.toString());
        result.put(SECURITY_TOKEN, this.secureTokenService.generate((Key)commonContext.getBuildKey()).getToken());
        return result;
    }

    @NotNull
    public Map<String, WhitelistedSerializable> createRuntimeTaskData(@NotNull RuntimeTaskDefinition taskDefinition, @NotNull CommonContext commonContext) {
        HashMap<String, WhitelistedSerializable> data = new HashMap<String, WhitelistedSerializable>();
        this.addRequestedArtifactContexts(data, taskDefinition);
        if (commonContext instanceof BuildContext) {
            PlanResultKey resultKey = PlanKeys.getPlanResultKey((String)((String)taskDefinition.getRuntimeContext().get(RESULT_KEY)));
            data.put("availableArtifacts", new AvailableArtifacts((Multimap<String, Artifact>)this.artifactLinkManager.findArtifactsByChainResultKey(resultKey)));
        }
        return data;
    }

    private void addRequestedArtifactContexts(@NotNull Map<String, WhitelistedSerializable> runtimeData, @NotNull RuntimeTaskDefinition taskDefinition) {
        PlanKey planKey = PlanKeys.getPlanKey((String)((String)taskDefinition.getRuntimeContext().get(PLAN_OR_BRANCH_KEY)));
        ImmutableChain sourcePlanOrBranch = (ImmutableChain)this.cachedPlanManager.getPlanByKey(planKey, ImmutableChain.class);
        ImmutableChainBranch sourceBranch = (ImmutableChainBranch)Narrow.downTo((Object)sourcePlanOrBranch, ImmutableChainBranch.class);
        Map taskConfiguration = taskDefinition.getConfiguration();
        HashSet artifactKeys = Sets.newHashSet((Iterable)ArtifactDownloaderTaskConfigurationHelper.getArtifactKeys((Map)taskConfiguration));
        ImmutableChain sourceMaster = sourceBranch != null ? sourceBranch.getMaster() : sourcePlanOrBranch;
        List<ImmutableArtifactDefinition> masterArtifacts = this.findSharedArtifactsByChain(sourceMaster);
        List<ImmutableArtifactDefinition> branchArtifacts = sourceBranch != null && sourceBranch.isDivergent() ? this.findSharedArtifactsByChain((ImmutableChain)sourceBranch) : masterArtifacts;
        RequestedArtifacts artifactContexts = new RequestedArtifacts();
        runtimeData.put("artifactContexts", artifactContexts);
        if (branchArtifacts.isEmpty()) {
            return;
        }
        for (String artifactKey : artifactKeys) {
            String artifact = (String)taskConfiguration.get(artifactKey);
            long artifactId = Long.parseLong(artifact);
            int keyIndex = ArtifactDownloaderTaskConfigurationHelper.getIndexFromKey((String)artifactKey);
            String pathValue = ArtifactDownloaderTaskConfigurationHelper.getLocalPath((Map)taskConfiguration, (int)keyIndex);
            String artifactName = ArtifactDownloaderTaskConfigurationHelper.getArtifactName((Map)taskConfiguration, (int)keyIndex);
            Collection<ImmutableArtifactDefinition> artifactsToAdd = this.getArtifactsToAdd(masterArtifacts, branchArtifacts, artifactId, artifactName);
            if (artifactsToAdd.isEmpty()) {
                String message = "Unable to find an artifact definition for name: " + artifactName;
                log.warn((Object)message);
                throw new IllegalArgumentException(message);
            }
            for (ImmutableArtifactDefinition artifactDefinition : artifactsToAdd) {
                artifactContexts.addRequest(keyIndex, (ArtifactDefinitionContext)new ArtifactDefinitionContextImpl(artifactDefinition, null), pathValue);
            }
        }
    }

    private List<ImmutableArtifactDefinition> findSharedArtifactsByChain(@NotNull ImmutableChain sourceMaster) {
        return sourceMaster.getAllJobs().stream().flatMap(j -> j.getArtifactDefinitions().stream()).filter(ImmutableArtifactDefinitionBase::isSharedArtifact).collect(Collectors.toList());
    }

    @NotNull
    private ImmutableChain getSourcePlan(CommonContext commonContext, String sourcePlanKeyStr) {
        PlanKey sourcePlanKey = PlanKeys.getPlanKey((String)sourcePlanKeyStr);
        ImmutableChain sourcePlan = (ImmutableChain)this.cachedPlanManager.getPlanByKey(sourcePlanKey, ImmutableChain.class);
        Preconditions.checkState((sourcePlan != null ? 1 : 0) != 0, (Object)("Source plan [" + sourcePlanKeyStr + "] not found"));
        return sourcePlan;
    }

    @NotNull
    private ImmutableChain getSourceBranch(ImmutableChain sourcePlan, CommonContext commonContext) {
        ImmutableChain thisPlan;
        BuildContext buildContext = (BuildContext)Narrow.downTo((Object)commonContext, BuildContext.class);
        if (buildContext != null && (thisPlan = (ImmutableChain)this.cachedPlanManager.getPlanByKey(PlanKeys.getChainKeyIfJobKey((PlanKey)buildContext.getPlanResultKey().getPlanKey()), ImmutableChain.class)) != null) {
            Optional<String> vcsBranchDisplayName = Optional.ofNullable(ChainBranchUtils.getSubstitutedVcsBranchDisplayName((CustomVariableContext)this.customVariableContext, (ImmutablePlan)thisPlan));
            Predicate predicate = buildContext.isBranch() ? branch -> thisPlan.getBuildName().equals(branch.getBuildName()) : branch -> vcsBranchDisplayName.map(name -> name.equals(branch.getBuildName())).orElse(false);
            for (ImmutableChain branch2 : this.cachedPlanManager.getBranchesForChain((PlanIdentifier)sourcePlan)) {
                if (!predicate.test((Object)branch2)) continue;
                return branch2;
            }
        }
        return sourcePlan;
    }

    @Nullable
    private PlanResultKey getDeepTriggeringPlanKey(@NotNull PlanResultKey parentPlanResultKey, @NotNull ImmutableChain sourcePlan) {
        DependencyTriggerReason dependencyTriggerReason;
        ResultsSummary triggeringResult = this.resultsSummaryManager.getResultsSummary(parentPlanResultKey);
        if (triggeringResult != null && (dependencyTriggerReason = (DependencyTriggerReason)Narrow.to((Object)triggeringResult.getTriggerReason(), DependencyTriggerReason.class)) != null) {
            String triggeringKey = dependencyTriggerReason.getTriggeringBuildResultKey();
            PlanResultKey triggeringPlanResultKey = PlanKeys.getPlanResultKey((String)triggeringKey);
            if (triggeringPlanResultKey.getPlanKey().equals((Object)sourcePlan.getPlanKey())) {
                return triggeringPlanResultKey;
            }
            return this.getDeepTriggeringPlanKey(triggeringPlanResultKey, sourcePlan);
        }
        return null;
    }

    @Nullable
    private PlanResultKey getSourcePlanResultKey(@NotNull CommonContext commonContext, @NotNull ImmutableChain sourcePlan, boolean forceResultReturn) {
        BuildContext parentBuildContext;
        BuildContext buildContext = (BuildContext)Narrow.to((Object)commonContext, BuildContext.class);
        BuildContext buildContext2 = parentBuildContext = buildContext != null ? buildContext.getParentBuildContext() : null;
        if (buildContext != null) {
            PlanResultKey currentChainResultKey;
            if (parentBuildContext == null) {
                throw new IllegalArgumentException("No parent context for " + commonContext.getResultKey());
            }
            DependencyTriggerReason dependencyTriggerReason = (DependencyTriggerReason)Narrow.to((Object)parentBuildContext.getTriggerReason(), DependencyTriggerReason.class);
            if (dependencyTriggerReason != null) {
                String triggeringKey = dependencyTriggerReason.getTriggeringBuildResultKey();
                PlanResultKey triggeringPlanResultKey = PlanKeys.getPlanResultKey((String)triggeringKey);
                if (triggeringPlanResultKey.getPlanKey().equals((Object)sourcePlan.getPlanKey())) {
                    return triggeringPlanResultKey;
                }
                PlanResultKey deepTriggeringKey = this.getDeepTriggeringPlanKey(triggeringPlanResultKey, sourcePlan);
                if (deepTriggeringKey != null) {
                    return deepTriggeringKey;
                }
            }
            if ((currentChainResultKey = parentBuildContext.getPlanResultKey()).getPlanKey().equals((Object)sourcePlan.getPlanKey())) {
                return currentChainResultKey;
            }
            return this.getLastSuccessfulNotSpecsResult(sourcePlan, forceResultReturn);
        }
        DeploymentContext deploymentContext = (DeploymentContext)Narrow.to((Object)commonContext, DeploymentContext.class);
        if (deploymentContext == null) {
            String message = "Unknown context type" + commonContext.getClass().getCanonicalName();
            log.warn((Object)message);
            throw new IllegalArgumentException(message);
        }
        Set relatedPlanResultKeys = this.deploymentVersionService.getRelatedPlanResultKeys(deploymentContext.getDeploymentVersion().getId());
        if (relatedPlanResultKeys.isEmpty()) {
            return null;
        }
        if (relatedPlanResultKeys.size() > 1) {
            throw new IllegalArgumentException("Artifact Downloader Task cannot handle versions with more than one related plan result");
        }
        return (PlanResultKey)relatedPlanResultKeys.iterator().next();
    }

    private Collection<ImmutableArtifactDefinition> getArtifactsToAdd(List<ImmutableArtifactDefinition> masterArtifacts, List<ImmutableArtifactDefinition> branchArtifacts, long artifactId, String artifactName) {
        Optional<ImmutableArtifactDefinition> masterArtDefinition;
        ArrayList<ImmutableArtifactDefinition> artifactsToAdd = new ArrayList<ImmutableArtifactDefinition>();
        boolean found = false;
        for (ImmutableArtifactDefinition artifactDefinition : branchArtifacts) {
            if (artifactDefinition.getId() != artifactId && artifactId != -1L) continue;
            log.debug((Object)("Adding artifact to runtime context: " + artifactDefinition.getName() + "[" + artifactDefinition.getId() + "] (found by id)"));
            artifactsToAdd.add(artifactDefinition);
            found = true;
        }
        if (!found && StringUtils.isNotBlank((CharSequence)artifactName)) {
            for (ImmutableArtifactDefinition artifactDefinition : branchArtifacts) {
                if (!artifactDefinition.getName().equals(artifactName)) continue;
                log.debug((Object)("Adding artifact to runtime context: " + artifactDefinition.getName() + "[" + artifactDefinition.getId() + "] (found by name)"));
                artifactsToAdd.add(artifactDefinition);
                found = true;
            }
        }
        if (!found && masterArtifacts != branchArtifacts && (masterArtDefinition = masterArtifacts.stream().filter(a -> artifactId == a.getId()).findFirst()).isPresent()) {
            Optional<ImmutableArtifactDefinition> branchArtDefinition = branchArtifacts.stream().filter(a -> ((ImmutableArtifactDefinition)masterArtDefinition.get()).getName().equals(a.getName())).findFirst();
            branchArtDefinition.ifPresent(b -> {
                log.debug((Object)("Adding artifact to runtime context: " + b.getName() + "[" + b.getId() + "] (found by master definition)"));
                artifactsToAdd.add((ImmutableArtifactDefinition)b);
            });
        }
        return artifactsToAdd;
    }

    @Nullable
    private PlanResultKey getLastSuccessfulNotSpecsResult(@NotNull ImmutableChain sourcePlan, boolean forceResult) {
        ResultsSummaryCriteria latestBuildResultCriteria;
        ResultsSummaryCriteria latestSuccessResultCriteria = new ResultsSummaryCriteriaBuilder().setPlanKey(sourcePlan.getPlanKey()).setBuildState(BuildState.SUCCESS).setSpecsResult(false).setMaxRowCount(1).setSortField("buildNumber").buildCriteria();
        PlanResultKey planResultKey = this.resultsSummaryManager.getResultSummaries(latestSuccessResultCriteria).stream().findFirst().map(ImmutableResultsSummary::getPlanResultKey).orElse(null);
        if (planResultKey == null && forceResult && (planResultKey = (PlanResultKey)this.resultsSummaryManager.getResultSummaries(latestBuildResultCriteria = new ResultsSummaryCriteriaBuilder().setPlanKey(sourcePlan.getPlanKey()).setSpecsResult(false).setMaxRowCount(1).buildCriteria()).stream().findFirst().map(ImmutableResultsSummary::getPlanResultKey).orElse(null)) == null) {
            return PlanKeys.getPlanResultKey((PlanKey)sourcePlan.getPlanKey(), (int)1);
        }
        return planResultKey;
    }

    public void processRuntimeTaskData(@NotNull RuntimeTaskDefinition taskDefinition, @NotNull CommonContext commonContext) {
    }
}

