/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.impl;

import com.atlassian.bamboo.build.logger.BuildLogger;
import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.Marker;
import org.slf4j.helpers.FormattingTuple;
import org.slf4j.helpers.MessageFormatter;

public class CheckmarxLoggerAdapter
implements Logger,
Serializable {
    private static final long serialVersionUID = 1L;
    private String name;
    private BuildLogger logger;
    protected boolean infoCapable = true;
    protected boolean errorCapable = true;
    protected boolean warnCapable = true;
    protected boolean debugCapable = false;
    protected boolean traceCapable = false;
    protected final String FQCN = this.getClass().getName();

    CheckmarxLoggerAdapter(String name) {
        this.name = name;
        this.setLogLevel();
    }

    CheckmarxLoggerAdapter(String name, BuildLogger logger) {
        this.name = name;
        this.logger = logger;
        this.setLogLevel();
    }

    protected void setLogLevel() {
        String level = System.getProperty("cx.bamboo.log_level");
        if (!StringUtils.isEmpty((CharSequence)level)) {
            if (level.equalsIgnoreCase("DEBUG")) {
                this.debugCapable = true;
            } else if (level.equalsIgnoreCase("TRACE")) {
                this.debugCapable = true;
                this.traceCapable = true;
            }
        }
    }

    public String getName() {
        return null;
    }

    public boolean isTraceEnabled() {
        if (this.logger == null) {
            return false;
        }
        return this.traceCapable;
    }

    public void trace(String msg) {
        if (!this.isTraceEnabled()) {
            return;
        }
        this.logger.addBuildLogEntry(msg);
    }

    public void trace(String format, Object arg) {
        if (!this.isTraceEnabled()) {
            return;
        }
        FormattingTuple ft = MessageFormatter.format((String)format, (Object)arg);
        this.logger.addBuildLogEntry(ft.getMessage());
    }

    public void trace(String format, Object arg1, Object arg2) {
        if (!this.isTraceEnabled()) {
            return;
        }
        FormattingTuple ft = MessageFormatter.format((String)format, (Object)arg1, (Object)arg2);
        this.logger.addBuildLogEntry(ft.getMessage());
    }

    public void trace(String format, Object[] argArray) {
        if (!this.isTraceEnabled()) {
            return;
        }
        FormattingTuple ft = MessageFormatter.format((String)format, (Object)argArray);
        this.logger.addBuildLogEntry(ft.getMessage());
    }

    public void trace(String msg, Throwable t) {
        if (!this.isTraceEnabled()) {
            return;
        }
        this.logger.addErrorLogEntry(msg, t);
    }

    public boolean isTraceEnabled(Marker marker) {
        return this.isTraceEnabled();
    }

    public void trace(Marker marker, String msg) {
    }

    public void trace(Marker marker, String format, Object arg) {
    }

    public void trace(Marker marker, String format, Object arg1, Object arg2) {
    }

    public void trace(Marker marker, String format, Object[] argArray) {
    }

    public void trace(Marker marker, String msg, Throwable t) {
    }

    public boolean isDebugEnabled() {
        if (this.logger == null) {
            return false;
        }
        return this.debugCapable;
    }

    public void debug(String msg) {
        if (!this.isDebugEnabled()) {
            return;
        }
        this.logger.addBuildLogEntry(msg);
    }

    public void debug(String format, Object arg) {
        if (!this.isDebugEnabled()) {
            return;
        }
        FormattingTuple ft = MessageFormatter.format((String)format, (Object)arg);
        this.logger.addBuildLogEntry(ft.getMessage());
    }

    public void debug(String format, Object arg1, Object arg2) {
        if (!this.isDebugEnabled()) {
            return;
        }
        FormattingTuple ft = MessageFormatter.format((String)format, (Object)arg1, (Object)arg2);
        this.logger.addBuildLogEntry(ft.getMessage());
    }

    public void debug(String format, Object[] argArray) {
        if (!this.isDebugEnabled()) {
            return;
        }
        FormattingTuple ft = MessageFormatter.format((String)format, (Object)argArray);
        this.logger.addBuildLogEntry(ft.getMessage());
    }

    public void debug(String msg, Throwable t) {
        if (!this.isDebugEnabled()) {
            return;
        }
        this.logger.addErrorLogEntry(msg, t);
    }

    public boolean isDebugEnabled(Marker marker) {
        return this.isDebugEnabled();
    }

    public void debug(Marker marker, String msg) {
    }

    public void debug(Marker marker, String format, Object arg) {
    }

    public void debug(Marker marker, String format, Object arg1, Object arg2) {
    }

    public void debug(Marker marker, String format, Object[] argArray) {
    }

    public void debug(Marker marker, String msg, Throwable t) {
    }

    public boolean isInfoEnabled() {
        if (this.logger == null) {
            return false;
        }
        return this.infoCapable;
    }

    public void info(String msg) {
        if (this.logger == null) {
            return;
        }
        this.logger.addBuildLogEntry(msg);
    }

    public void info(String format, Object arg) {
        if (this.logger == null) {
            return;
        }
        FormattingTuple ft = MessageFormatter.format((String)format, (Object)arg);
        this.logger.addBuildLogEntry(ft.getMessage());
    }

    public void info(String format, Object arg1, Object arg2) {
        if (this.logger == null) {
            return;
        }
        FormattingTuple ft = MessageFormatter.format((String)format, (Object)arg1, (Object)arg2);
        this.logger.addBuildLogEntry(ft.getMessage());
    }

    public void info(String format, Object[] argArray) {
        if (this.logger == null) {
            return;
        }
        FormattingTuple ft = MessageFormatter.format((String)format, (Object)argArray);
        this.logger.addBuildLogEntry(ft.getMessage());
    }

    public void info(String msg, Throwable t) {
        if (this.logger == null) {
            return;
        }
        this.logger.addErrorLogEntry(msg, t);
    }

    public boolean isInfoEnabled(Marker marker) {
        return this.isInfoEnabled();
    }

    public void info(Marker marker, String msg) {
    }

    public void info(Marker marker, String format, Object arg) {
    }

    public void info(Marker marker, String format, Object arg1, Object arg2) {
    }

    public void info(Marker marker, String format, Object[] argArray) {
    }

    public void info(Marker marker, String msg, Throwable t) {
    }

    public boolean isWarnEnabled() {
        if (this.logger == null) {
            return false;
        }
        return this.warnCapable;
    }

    public void warn(String msg) {
        if (this.logger == null) {
            return;
        }
        this.logger.addBuildLogEntry(msg);
    }

    public void warn(String format, Object arg) {
        if (this.logger == null) {
            return;
        }
        FormattingTuple ft = MessageFormatter.format((String)format, (Object)arg);
        this.logger.addBuildLogEntry(ft.getMessage());
    }

    public void warn(String format, Object arg1, Object arg2) {
        if (this.logger == null) {
            return;
        }
        FormattingTuple ft = MessageFormatter.format((String)format, (Object)arg1, (Object)arg2);
        this.logger.addBuildLogEntry(ft.getMessage());
    }

    public void warn(String format, Object[] argArray) {
        if (this.logger == null) {
            return;
        }
        FormattingTuple ft = MessageFormatter.format((String)format, (Object)argArray);
        this.logger.addBuildLogEntry(ft.getMessage());
    }

    public void warn(String msg, Throwable t) {
        if (this.logger == null) {
            return;
        }
        this.logger.addErrorLogEntry(msg, t);
    }

    public boolean isWarnEnabled(Marker marker) {
        return this.isWarnEnabled();
    }

    public void warn(Marker marker, String msg) {
    }

    public void warn(Marker marker, String format, Object arg) {
    }

    public void warn(Marker marker, String format, Object arg1, Object arg2) {
    }

    public void warn(Marker marker, String format, Object[] argArray) {
    }

    public void warn(Marker marker, String msg, Throwable t) {
    }

    public boolean isErrorEnabled() {
        if (this.logger == null) {
            return false;
        }
        return this.errorCapable;
    }

    public boolean isErrorEnabled(Marker marker) {
        return this.isErrorEnabled();
    }

    public void error(Marker marker, String msg) {
    }

    public void error(Marker marker, String format, Object arg) {
    }

    public void error(Marker marker, String format, Object arg1, Object arg2) {
    }

    public void error(Marker marker, String format, Object[] argArray) {
    }

    public void error(Marker marker, String msg, Throwable t) {
    }

    public void error(String msg) {
        if (this.logger == null) {
            return;
        }
        this.logger.addBuildLogEntry(msg);
    }

    public void error(String format, Object arg) {
        if (this.logger == null) {
            return;
        }
        FormattingTuple ft = MessageFormatter.format((String)format, (Object)arg);
        this.logger.addBuildLogEntry(ft.getMessage());
    }

    public void error(String format, Object arg1, Object arg2) {
        if (this.logger == null) {
            return;
        }
        FormattingTuple ft = MessageFormatter.format((String)format, (Object)arg1, (Object)arg2);
        this.logger.addBuildLogEntry(ft.getMessage());
    }

    public void error(String format, Object[] argArray) {
        if (this.logger == null) {
            return;
        }
        FormattingTuple ft = MessageFormatter.format((String)format, (Object)argArray);
        this.logger.addBuildLogEntry(ft.getMessage());
    }

    public void error(String msg, Throwable t) {
        if (this.logger == null) {
            return;
        }
        this.logger.addErrorLogEntry(msg, t);
    }
}

