/*
 * Decompiled with CFR 0.152.
 */
package com.cx.plugin.utils;

import com.cx.plugin.configuration.CommonClientFactory;
import com.cx.plugin.testConnection.CxRestResource;
import com.cx.plugin.utils.HttpHelper;
import com.cx.restclient.configuration.CxScanConfig;
import com.cx.restclient.dto.ProxyConfig;
import com.cx.restclient.sast.utils.LegacyClient;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SASTUtils {
    private static Logger logger = LoggerFactory.getLogger(CxRestResource.class);

    public static String loginToServer(URL url, String username, String password, String proxyEnable) {
        String version = null;
        String result = "";
        LegacyClient commonClient = null;
        try {
            ProxyConfig proxyConfig = HttpHelper.getProxyConfig();
            CxScanConfig scanConfig = new CxScanConfig(url.toString().trim(), username, password, "Bamboo", true);
            if (proxyEnable != null && proxyEnable.equalsIgnoreCase("true") && proxyConfig != null) {
                scanConfig.setProxy(Boolean.valueOf(true));
                scanConfig.setProxyConfig(proxyConfig);
                logger.debug("Testing login with proxy details:");
                logger.debug("Proxy host: " + proxyConfig.getHost());
                logger.debug("Proxy port: " + proxyConfig.getPort());
                logger.debug("Proxy user: " + proxyConfig.getUsername());
                logger.debug("Proxy password: *************");
                logger.debug("Proxy Scheme: " + (proxyConfig.isUseHttps() ? "https" : "http"));
                logger.debug("Non Proxy Hosts: " + proxyConfig.getNoproxyHosts());
            } else {
                scanConfig.setProxy(Boolean.valueOf(false));
                logger.debug("Testing login.");
            }
            commonClient = CommonClientFactory.getInstance(scanConfig, logger);
            version = commonClient.login(Boolean.valueOf(true));
            return version;
        }
        catch (Exception cxClientException) {
            logger.error("Fail to login: ", (Throwable)cxClientException);
            result = cxClientException.getMessage();
            return version;
        }
    }

    public static String getMajorMinorSASTVersion(String version) {
        JsonNode node = null;
        try {
            node = new ObjectMapper().readTree(version);
        }
        catch (JsonMappingException e) {
            e.printStackTrace();
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        String cxVersion = node.path("version").asText();
        String[] sastVersionSplit = cxVersion.split("\\.");
        return sastVersionSplit[0] + "." + sastVersionSplit[1];
    }
}

