/*
 * Decompiled with CFR 0.152.
 */
package com.cx.plugin.utils;

import com.cx.restclient.dto.ProxyConfig;
import com.cx.restclient.exception.CxClientException;
import java.net.Authenticator;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.conn.ssl.TrustAllStrategy;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;

public class HttpHelper {
    public static final String HTTP_HOST = System.getProperty("http.proxyHost");
    public static final String HTTP_PORT = System.getProperty("http.proxyPort");
    public static final String HTTP_USERNAME = System.getProperty("http.proxyUser");
    public static final String HTTP_PASSWORD = System.getProperty("http.proxyPassword");
    public static final String HTTPS_HOST = System.getProperty("https.proxyHost");
    public static final String HTTPS_PORT = System.getProperty("https.proxyPort");
    public static final String HTTPS_USERNAME = System.getProperty("https.proxyUser");
    public static final String HTTPS_PASSWORD = System.getProperty("https.proxyPassword");
    public static final String HTTP_NON_PROXY_HOSTS = System.getProperty("http.nonProxyHosts");

    public static Proxy getHttpProxy() {
        Proxy proxy = null;
        if (StringUtils.isNotEmpty((CharSequence)HTTPS_HOST) && StringUtils.isNotEmpty((CharSequence)HTTPS_PORT)) {
            proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(HTTPS_HOST, Integer.parseInt(HTTPS_PORT)));
            if (StringUtils.isNotEmpty((CharSequence)HTTPS_USERNAME) && StringUtils.isNotEmpty((CharSequence)HTTPS_PASSWORD)) {
                Authenticator authenticator = new Authenticator(){

                    @Override
                    public PasswordAuthentication getPasswordAuthentication() {
                        return new PasswordAuthentication(HTTPS_USERNAME, HTTPS_PASSWORD.toCharArray());
                    }
                };
                Authenticator.setDefault(authenticator);
            }
        } else if (StringUtils.isNotEmpty((CharSequence)HTTP_HOST) && StringUtils.isNotEmpty((CharSequence)HTTP_PORT)) {
            proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(HTTP_HOST, Integer.parseInt(HTTP_PORT)));
            if (StringUtils.isNotEmpty((CharSequence)HTTP_USERNAME) && StringUtils.isNotEmpty((CharSequence)HTTP_PASSWORD)) {
                Authenticator authenticator = new Authenticator(){

                    @Override
                    public PasswordAuthentication getPasswordAuthentication() {
                        return new PasswordAuthentication(HTTP_USERNAME, HTTP_PASSWORD.toCharArray());
                    }
                };
                Authenticator.setDefault(authenticator);
            }
        }
        return proxy;
    }

    public static ProxyConfig getProxyConfig() {
        ProxyConfig proxyConfig = null;
        int port = 0;
        if (HTTP_HOST != null && !HTTP_HOST.isEmpty()) {
            proxyConfig = new ProxyConfig();
            if (HTTP_PORT != null && !HTTP_PORT.isEmpty()) {
                port = Integer.parseInt(HTTP_PORT);
                proxyConfig.setPort(port);
            }
            proxyConfig.setHost(HTTP_HOST);
            proxyConfig.setUsername(HTTP_USERNAME);
            proxyConfig.setPassword(HTTP_PASSWORD);
            proxyConfig.setUseHttps(false);
        } else if (HTTPS_HOST != null && !HTTPS_HOST.isEmpty()) {
            proxyConfig = new ProxyConfig();
            proxyConfig.setHost(HTTPS_HOST);
            if (HTTPS_PORT != null && !HTTPS_PORT.isEmpty()) {
                port = Integer.parseInt(HTTPS_PORT);
                proxyConfig.setPort(port);
            }
            proxyConfig.setUsername(HTTPS_USERNAME);
            proxyConfig.setPassword(HTTPS_PASSWORD);
            proxyConfig.setUseHttps(true);
        }
        if (proxyConfig != null && HTTP_NON_PROXY_HOSTS != null && !HTTP_NON_PROXY_HOSTS.isEmpty()) {
            proxyConfig.setNoproxyHosts(HTTP_NON_PROXY_HOSTS);
        }
        return proxyConfig;
    }

    public static SSLSocketFactory getSSLSocketFactory() throws CxClientException {
        SSLContext sslContext;
        TrustAllStrategy acceptingTrustStrategy = new TrustAllStrategy();
        try {
            sslContext = SSLContexts.custom().loadTrustMaterial(null, (TrustStrategy)acceptingTrustStrategy).build();
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
            throw new CxClientException("Fail to set trust all certificate, 'SSLConnectionSocketFactory'", (Throwable)e);
        }
        return sslContext.getSocketFactory();
    }

    public static HostnameVerifier getHostnameVerifier() throws CxClientException {
        return new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession session) {
                return true;
            }
        };
    }
}

