/*
 * Decompiled with CFR 0.152.
 */
package com.cx.plugin.utils;

import com.atlassian.bamboo.configuration.AdministrationConfiguration;
import com.atlassian.bamboo.configuration.ConfigurationMap;
import com.atlassian.bamboo.task.TaskContext;
import com.atlassian.bamboo.task.TaskException;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.atlassian.spring.container.ContainerManager;
import com.cx.plugin.utils.CxLoggerAdapter;
import com.cx.plugin.utils.CxPluginUtils;
import com.cx.plugin.utils.HttpHelper;
import com.cx.restclient.ast.dto.sca.AstScaConfig;
import com.cx.restclient.configuration.CxScanConfig;
import com.cx.restclient.dto.ProxyConfig;
import com.cx.restclient.dto.ScannerType;
import com.cx.restclient.exception.CxClientException;
import com.cx.restclient.sca.utils.CxSCAResolverUtils;
import java.io.File;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.URLDecoder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;

public class CxConfigHelper {
    private CxScanConfig scanConfig;
    private AdministrationConfiguration adminConfig;
    private boolean isIntervals;
    private String intervalBegins;
    private String intervalEnds;
    private CxLoggerAdapter log;
    private boolean usingGlobalSASTServer;
    private boolean usingGlobalSASTSettings;
    private boolean usingGlobalDependencyScan;
    private boolean usingGlobalScanControlSettings;
    private boolean dependencyScanEnabled;
    private ScannerType dependencyScanType;
    private boolean effectiveIncrementalScan;
    private static final String scaResolverResultPath = ".cxscaresolver" + File.separator + "sca";
    private static final String scaResolverSastResultPath = ".cxscaresolver" + File.separator + "sast";
    private static final String SUPPRESS_BENIGN_ERRORS = System.getProperty("suppressBenignErrors");

    public boolean isEffectiveIncrementalScan() {
        return this.effectiveIncrementalScan;
    }

    public void setEffectiveIncrementalScan(boolean effectiveIncrementalScan) {
        this.effectiveIncrementalScan = effectiveIncrementalScan;
    }

    public CxConfigHelper(CxLoggerAdapter log) {
        this.log = log;
    }

    public CxScanConfig resolveConfigurationMap(ConfigurationMap configMap, File workDir, TaskContext taskContext) throws TaskException {
        this.log.info("Reading Scan configuration.");
        Object a = ContainerManager.getComponent((String)"administrationConfigurationAccessor");
        try {
            Method getAdminConfig = a.getClass().getDeclaredMethod("getAdministrationConfiguration", new Class[0]);
            this.adminConfig = (AdministrationConfiguration)getAdminConfig.invoke(a, new Object[0]);
        }
        catch (Exception e) {
            throw new TaskException("Failed to resolve global configuration", (Throwable)e);
        }
        this.scanConfig = new CxScanConfig();
        String originUrl = this.getCxOriginUrl(this.adminConfig, taskContext);
        this.scanConfig.setCxOriginUrl(originUrl);
        String cxOrigin = this.getOrigin(this.adminConfig, taskContext);
        this.scanConfig.setCxOrigin(cxOrigin);
        this.log.info("CxOrigin : " + cxOrigin);
        this.log.info("CxOrigin URL : " + originUrl);
        this.scanConfig.setSourceDir(workDir.getAbsolutePath());
        this.scanConfig.setReportsDir(workDir);
        boolean enableSAST = this.isSASTEnabled(configMap, "enableSASTScan");
        this.scanConfig.setSastEnabled(enableSAST);
        this.scanConfig.setDisableCertificateValidation(true);
        if ("customConfigurationServer".equals(configMap.get((Object)"serverCredentialsSection"))) {
            this.scanConfig.setUrl((String)configMap.get((Object)"serverUrl"));
            this.scanConfig.setUsername((String)configMap.get((Object)"username"));
            this.scanConfig.setPassword(CxPluginUtils.decrypt((String)configMap.get((Object)"password")));
            this.scanConfig.setProxy(Boolean.valueOf(this.resolveBool(configMap, "enableProxy")));
            this.setUsingGlobalSASTServer(false);
        } else {
            this.scanConfig.setUrl(this.getAdminConfig("globalServerUrl"));
            this.scanConfig.setUsername(this.getAdminConfig("globalUsername"));
            this.scanConfig.setPassword(CxPluginUtils.decrypt(this.getAdminConfig("globalPss")));
            this.scanConfig.setProxy(Boolean.valueOf(this.resolveGlobalBool("globalEnableProxy")));
            this.setUsingGlobalSASTServer(true);
        }
        if (this.scanConfig.isProxy().booleanValue()) {
            ProxyConfig proxyConfig = HttpHelper.getProxyConfig();
            if (proxyConfig != null) {
                this.scanConfig.setProxyConfig(proxyConfig);
            } else {
                ProxyConfig proxy = new ProxyConfig();
                this.scanConfig.setProxyConfig(proxy);
            }
            this.scanConfig.setScaProxy(Boolean.valueOf(true));
            this.scanConfig.setScaProxyConfig(proxyConfig);
        }
        this.scanConfig.setProjectName(((String)configMap.get((Object)"projectName")).trim());
        String presetIdStr = (String)configMap.get((Object)"presetId");
        int presetId = this.parseInt(presetIdStr, this.log, "Invalid presetId: [%s]. Using default preset.", 0);
        String teamName = (String)configMap.get((Object)"teamPathName");
        if (StringUtils.isEmpty((String)teamName)) {
            throw new TaskException("Invalid team path");
        }
        this.scanConfig.setPresetId(Integer.valueOf(presetId));
        this.scanConfig.setPresetName(StringUtils.defaultString((String)((String)configMap.get((Object)"presetName"))));
        this.scanConfig.setTeamId(StringUtils.defaultString((String)((String)configMap.get((Object)"teamPathId"))));
        this.scanConfig.setTeamPath(teamName);
        if (enableSAST) {
            if ("customConfigurationCxSAST".equals(configMap.get((Object)"cxSastSection"))) {
                this.scanConfig.setSastFolderExclusions((String)configMap.get((Object)"folderExclusions"));
                this.scanConfig.setSastFilterPattern((String)configMap.get((Object)"filterPatterns"));
                this.scanConfig.setSastScanTimeoutInMinutes(CxPluginUtils.resolveInt((String)configMap.get((Object)"scanTimeoutInMinutes"), (Logger)this.log));
                this.setUsingGlobalSASTSettings(false);
            } else {
                this.scanConfig.setSastFolderExclusions(this.getAdminConfig("globalFolderExclusions"));
                this.scanConfig.setSastFilterPattern(this.getAdminConfig("globalFilterPatterns"));
                this.scanConfig.setSastScanTimeoutInMinutes(CxPluginUtils.resolveInt(this.getAdminConfig("globalScanTimeoutInMinutes"), (Logger)this.log));
                this.setUsingGlobalSASTSettings(true);
            }
            this.scanConfig.setScanComment((String)configMap.get((Object)"comment"));
            this.scanConfig.setIncremental(Boolean.valueOf(this.resolveBool(configMap, "isIncremental")));
            this.log.info("Is incremental scan: " + this.scanConfig.getIncremental());
            if (this.scanConfig.getIncremental().booleanValue()) {
                this.isIntervals = this.resolveBool(configMap, "isIntervals");
                this.setEffectiveIncrementalScan(this.scanConfig.getIncremental());
                if (this.isIntervals) {
                    this.intervalBegins = (String)configMap.get((Object)"intervalBegins");
                    this.intervalEnds = (String)configMap.get((Object)"intervalEnds");
                    this.scanConfig = this.resolveIntervalFullScan(this.scanConfig);
                    if (!this.scanConfig.getIncremental().booleanValue()) {
                        this.setEffectiveIncrementalScan(false);
                    } else {
                        this.setEffectiveIncrementalScan(true);
                    }
                }
            }
            if (this.resolveBool(configMap, "forceScan") && this.resolveBool(configMap, "isIncremental")) {
                throw new TaskException("Force scan and incremental scan can not be configured in pair for SAST. Configure either Incremental or Force scan option.");
            }
            this.scanConfig.setForceScan(Boolean.valueOf(this.resolveBool(configMap, "forceScan")));
            this.scanConfig.setGeneratePDFReport(Boolean.valueOf(this.resolveBool(configMap, "generatePDFReport")));
        }
        ScannerType scannerType = null;
        if (this.resolveBool(configMap, "enableDependencyScan")) {
            this.setDependencyScanEnabled(true);
            String useCustomdependencyScanSettings = (String)configMap.get((Object)"cxDependencySettingsCustom");
            if (!StringUtils.isEmpty((String)useCustomdependencyScanSettings) && useCustomdependencyScanSettings.equalsIgnoreCase("true")) {
                this.setUsingGlobalDependencyScan(false);
                this.scanConfig.setOsaFilterPattern((String)configMap.get((Object)"cxDependencyScanFilterPatterns"));
                this.scanConfig.setOsaFolderExclusions((String)configMap.get((Object)"cxDependencyScanfolderExclusions"));
                if (((String)configMap.get((Object)"dependencyScanType")).equalsIgnoreCase(ScannerType.AST_SCA.toString())) {
                    scannerType = ScannerType.AST_SCA;
                    try {
                        this.scanConfig.setAstScaConfig(this.getScaConfig(configMap, workDir, false));
                    }
                    catch (ParseException e) {
                        throw new TaskException("Could not parse SCA additional arguments.", (Throwable)e);
                    }
                } else {
                    scannerType = ScannerType.OSA;
                    this.scanConfig.setOsaArchiveIncludePatterns((String)configMap.get((Object)"cxOsaArchiveIncludePatterns"));
                    this.scanConfig.setOsaRunInstall(Boolean.valueOf(this.resolveBool(configMap, "cxOsaInstallBeforeScan")));
                }
            } else {
                String useGlobalependencyScanSettings = this.getAdminConfig("globalEnableDependencyScan");
                if (!StringUtils.isEmpty((String)useGlobalependencyScanSettings) && useGlobalependencyScanSettings.equalsIgnoreCase("true")) {
                    this.scanConfig.setOsaFilterPattern(this.getAdminConfig("globalDependencyScanFilterPatterns"));
                    this.scanConfig.setOsaFolderExclusions(this.getAdminConfig("globalDependencyScanfolderExclusions"));
                    if (this.getAdminConfig("globalDependencyScanType").equalsIgnoreCase(ScannerType.AST_SCA.toString())) {
                        scannerType = ScannerType.AST_SCA;
                        try {
                            this.scanConfig.setAstScaConfig(this.getScaConfig(configMap, workDir, true));
                        }
                        catch (ParseException e) {
                            throw new TaskException("Could not parse SCA additional arguments.", (Throwable)e);
                        }
                    } else {
                        scannerType = ScannerType.OSA;
                        this.scanConfig.setOsaArchiveIncludePatterns(this.getAdminConfig("globalOsaArchiveIncludePatterns"));
                        this.scanConfig.setOsaRunInstall(Boolean.valueOf(this.resolveGlobalBool("globalOsaInstallBeforeScan")));
                    }
                }
            }
            if (scannerType != null) {
                this.scanConfig.addScannerType(scannerType);
                this.setDependencyScanType(scannerType);
            }
        }
        this.scanConfig.setDisableCertificateValidation(true);
        boolean isCustomConfSect = "customConfigurationControl".equals(configMap.get((Object)"scanControlSection"));
        if (isCustomConfSect) {
            this.scanConfig.setSynchronous(Boolean.valueOf(this.resolveBool(configMap, "isSynchronous")));
            this.scanConfig.setEnablePolicyViolations(this.resolveBool(configMap, "enablePolicyViolations"));
            this.scanConfig.setEnablePolicyViolationsSCA(this.resolveBool(configMap, "enablePolicyViolationsSCA"));
            if (enableSAST) {
                this.scanConfig.setSastThresholdsEnabled(Boolean.valueOf(this.resolveBool(configMap, "thresholdsEnabled")));
                this.scanConfig.setSastCriticalThreshold(CxPluginUtils.resolveInt((String)configMap.get((Object)"criticalThreshold"), (Logger)this.log));
                this.scanConfig.setSastHighThreshold(CxPluginUtils.resolveInt((String)configMap.get((Object)"highThreshold"), (Logger)this.log));
                this.scanConfig.setSastMediumThreshold(CxPluginUtils.resolveInt((String)configMap.get((Object)"mediumThreshold"), (Logger)this.log));
                this.scanConfig.setSastLowThreshold(CxPluginUtils.resolveInt((String)configMap.get((Object)"lowThreshold"), (Logger)this.log));
            }
            this.scanConfig.setOsaThresholdsEnabled(Boolean.valueOf(this.resolveBool(configMap, "osaThresholdsEnabled")));
            this.scanConfig.setOsaCriticalThreshold(CxPluginUtils.resolveInt((String)configMap.get((Object)"osaCriticalThreshold"), (Logger)this.log));
            this.scanConfig.setOsaHighThreshold(CxPluginUtils.resolveInt((String)configMap.get((Object)"osaHighThreshold"), (Logger)this.log));
            this.scanConfig.setOsaMediumThreshold(CxPluginUtils.resolveInt((String)configMap.get((Object)"osaMediumThreshold"), (Logger)this.log));
            this.scanConfig.setOsaLowThreshold(CxPluginUtils.resolveInt((String)configMap.get((Object)"osaLowThreshold"), (Logger)this.log));
            this.setUsingGlobalScanControlSettings(false);
        } else {
            this.scanConfig.setSynchronous(Boolean.valueOf(this.resolveGlobalBool("globalIsSynchronous")));
            this.scanConfig.setEnablePolicyViolations(this.resolveGlobalBool("globalEnablePolicyViolations"));
            this.scanConfig.setEnablePolicyViolationsSCA(this.resolveGlobalBool("globalEnablePolicyViolationsSCA"));
            if (enableSAST) {
                this.scanConfig.setSastThresholdsEnabled(Boolean.valueOf(this.resolveGlobalBool("globalThresholdsEnabled")));
                this.scanConfig.setSastCriticalThreshold(CxPluginUtils.resolveInt(this.getAdminConfig("globalCriticalThreshold"), (Logger)this.log));
                this.scanConfig.setSastHighThreshold(CxPluginUtils.resolveInt(this.getAdminConfig("globalHighThreshold"), (Logger)this.log));
                this.scanConfig.setSastMediumThreshold(CxPluginUtils.resolveInt(this.getAdminConfig("globalMediumThreshold"), (Logger)this.log));
                this.scanConfig.setSastLowThreshold(CxPluginUtils.resolveInt(this.getAdminConfig("globalLowThreshold"), (Logger)this.log));
            }
            this.scanConfig.setOsaThresholdsEnabled(Boolean.valueOf(this.resolveGlobalBool("globalOsaThresholdsEnabled")));
            this.scanConfig.setOsaCriticalThreshold(CxPluginUtils.resolveInt(this.getAdminConfig("globalOsaCriticalThreshold"), (Logger)this.log));
            this.scanConfig.setOsaHighThreshold(CxPluginUtils.resolveInt(this.getAdminConfig("globalOsaHighThreshold"), (Logger)this.log));
            this.scanConfig.setOsaMediumThreshold(CxPluginUtils.resolveInt(this.getAdminConfig("globalOsaMediumThreshold"), (Logger)this.log));
            this.scanConfig.setOsaLowThreshold(CxPluginUtils.resolveInt(this.getAdminConfig("globalOsaLowThreshold"), (Logger)this.log));
            this.setUsingGlobalScanControlSettings(true);
        }
        this.scanConfig.setDenyProject(Boolean.valueOf(this.resolveGlobalBool("globalDenyProject")));
        this.scanConfig.setHideResults(Boolean.valueOf(this.resolveGlobalBool("globalHideResults")));
        this.scanConfig.setDisableCertificateValidation(true);
        String suppressBenignErrors = System.getProperty("suppressBenignErrors");
        if (suppressBenignErrors != null && Boolean.parseBoolean(suppressBenignErrors)) {
            this.scanConfig.setIgnoreBenignErrors(true);
        } else {
            this.scanConfig.setIgnoreBenignErrors(false);
        }
        return this.scanConfig;
    }

    private int parseInt(String number, CxLoggerAdapter log, String templateMessage, int defaultVal) {
        int ret = defaultVal;
        try {
            ret = Integer.parseInt(number);
        }
        catch (Exception e) {
            log.warn(String.format(templateMessage, number));
        }
        return ret;
    }

    private String getOrigin(AdministrationConfiguration adminConfig, TaskContext taskContext) {
        Object origin = "";
        try {
            BuildContext buildContext = taskContext.getBuildContext();
            String planName = buildContext.getPlanName();
            planName = URLDecoder.decode(planName, "UTF-8");
            planName = planName.replaceAll("[^.a-zA-Z0-9\\s]", "");
            String bambooURL = adminConfig.getBaseUrl();
            bambooURL = bambooURL.substring(bambooURL.lastIndexOf("://") + 3);
            String hostName = "";
            hostName = bambooURL.indexOf(":") != -1 ? bambooURL.substring(0, bambooURL.lastIndexOf(":")) : bambooURL;
            origin = "Bamboo " + hostName + " " + planName;
            if (origin != null && !((String)origin).isEmpty() && ((String)origin).length() > 50) {
                origin = ((String)origin).substring(0, 50);
            }
        }
        catch (UnsupportedEncodingException e) {
            this.log.error("Failed to get Bamboo Server URL: " + e.getMessage());
        }
        return origin;
    }

    private String getCxOriginUrl(AdministrationConfiguration adminConfig, TaskContext taskContext) {
        String baseURL = adminConfig.getBaseUrl();
        BuildContext buildContext = taskContext.getBuildContext();
        String planKey = buildContext.getPlanResultKey().getPlanKey().getKey();
        String originUrl = baseURL + "/browse/" + planKey;
        return originUrl;
    }

    private boolean resolveBool(ConfigurationMap configMap, String value) {
        return "true".equals(configMap.get((Object)value));
    }

    private boolean resolveGlobalBool(String value) {
        return "true".equals(this.getAdminConfig(value));
    }

    private CxScanConfig resolveIntervalFullScan(CxScanConfig scanConfig) {
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm");
            Calendar calendarBeginsHourMinute = Calendar.getInstance();
            calendarBeginsHourMinute.setTime(dateFormat.parse(this.intervalBegins));
            Calendar calendarBegins = Calendar.getInstance();
            calendarBegins.set(11, calendarBeginsHourMinute.get(11));
            calendarBegins.set(12, calendarBeginsHourMinute.get(12));
            calendarBegins.set(13, 0);
            Date dateBegins = calendarBegins.getTime();
            Calendar calendarEndsHourMinute = Calendar.getInstance();
            calendarEndsHourMinute.setTime(dateFormat.parse(this.intervalEnds));
            Calendar calendarEnds = Calendar.getInstance();
            calendarEnds.set(11, calendarEndsHourMinute.get(11));
            calendarEnds.set(12, calendarEndsHourMinute.get(12));
            calendarEnds.set(13, 0);
            Date dateEnds = calendarEnds.getTime();
            Date dateNow = Calendar.getInstance().getTime();
            if (dateBegins.after(dateEnds)) {
                if (dateBegins.after(dateNow)) {
                    calendarBegins.add(5, -1);
                    dateBegins = calendarBegins.getTime();
                } else {
                    calendarEnds.add(5, 1);
                    dateEnds = calendarEnds.getTime();
                }
            }
            if (dateNow.after(dateBegins) && dateNow.before(dateEnds)) {
                scanConfig.setIncremental(Boolean.valueOf(false));
            }
        }
        catch (ParseException e) {
            this.log.error("Full scan interval parse exception.");
        }
        return scanConfig;
    }

    private String getAdminConfig(String key) {
        return StringUtils.defaultString((String)this.adminConfig.getSystemProperty(key));
    }

    private AstScaConfig getScaConfig(ConfigurationMap configMap, File workDir, boolean fromGlobal) throws ParseException {
        AstScaConfig result = new AstScaConfig();
        if (fromGlobal) {
            result.setApiUrl(this.getAdminConfig("globalcxScaAPIUrl"));
            result.setAccessControlUrl(this.getAdminConfig("globalcxScaAccessControlServerUrl"));
            result.setWebAppUrl(this.getAdminConfig("globalcxScaWebAppUrl"));
            result.setTenant(this.getAdminConfig("globalcxScaAccountName"));
            result.setUsername(this.getAdminConfig("globalcxScaUsername"));
            result.setPassword(CxPluginUtils.decrypt(this.getAdminConfig("globalcxScaPss")));
            if ("true".equalsIgnoreCase(this.getAdminConfig("globalCxScaResolverEnabled"))) {
                result.setPathToScaResolver(this.getAdminConfig("globalCxScaResolverPath"));
                result.setScaResolverAddParameters(this.generateScaResolverParams(configMap, workDir, true));
                result.setEnableScaResolver(true);
            }
        } else {
            result.setApiUrl((String)configMap.get((Object)"cxScaAPIUrl"));
            result.setAccessControlUrl((String)configMap.get((Object)"cxAccessControlServerUrl"));
            result.setWebAppUrl((String)configMap.get((Object)"cxScaWebAppUrl"));
            result.setTenant((String)configMap.get((Object)"cxScaAccountName"));
            result.setUsername((String)configMap.get((Object)"cxScaUsername"));
            result.setPassword(CxPluginUtils.decrypt((String)configMap.get((Object)"cxScaPassword")));
            if ("true".equalsIgnoreCase((String)configMap.get((Object)"cxScaResolverEnabled"))) {
                result.setPathToScaResolver((String)configMap.get((Object)"cxScaResolverPath"));
                result.setScaResolverAddParameters(this.generateScaResolverParams(configMap, workDir, false));
                result.setEnableScaResolver(true);
            }
        }
        return result;
    }

    private String generateScaResolverParams(ConfigurationMap configMap, File workDir, boolean fromGlobal) throws ParseException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("--resolver-result-path", workDir.getAbsolutePath() + File.separator + scaResolverResultPath);
        params.put("--scan-path", workDir.getAbsolutePath());
        params.put("--project-name", ((String)configMap.get((Object)"projectName")).trim());
        params.put("--sast-result-path", workDir.getAbsolutePath() + File.separator + scaResolverSastResultPath);
        params.put("--cxserver", fromGlobal ? this.getAdminConfig("globalServerUrl") : (String)configMap.get((Object)"serverUrl"));
        params.put("--cxuser", fromGlobal ? this.getAdminConfig("globalUsername") : (String)configMap.get((Object)"username"));
        params.put("--cxpassword", CxPluginUtils.decrypt(fromGlobal ? this.getAdminConfig("globalPss") : (String)configMap.get((Object)"password")));
        params.put("--cxprojectname", ((String)configMap.get((Object)"projectName")).trim());
        params.putAll(CxSCAResolverUtils.parseArguments((String)(fromGlobal ? this.getAdminConfig("globalCxScaResolverAddParam") : (String)configMap.get((Object)"cxScaResolverAddParam"))));
        Object resolved = "";
        for (Map.Entry entry : params.entrySet()) {
            if (entry.getValue() != null) {
                resolved = (String)resolved + " " + (String)entry.getKey();
                resolved = (String)resolved + " " + (String)entry.getValue();
                continue;
            }
            resolved = (String)resolved + " " + (String)entry.getKey();
        }
        return resolved;
    }

    private static void fileExists(String file) {
        File resultPath = new File(file);
        if (!resultPath.exists()) {
            throw new CxClientException("Path does not exist. Path= " + resultPath.getAbsolutePath());
        }
    }

    public String getPluginVersion() {
        String version = "";
        try {
            Properties properties = new Properties();
            InputStream is = this.getClass().getClassLoader().getResourceAsStream("english.properties");
            if (is != null) {
                properties.load(is);
                version = properties.getProperty("version");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return version;
    }

    public boolean isIntervals() {
        return this.isIntervals;
    }

    public void setIntervals(boolean intervals) {
        this.isIntervals = intervals;
    }

    public String getIntervalBegins() {
        return this.intervalBegins;
    }

    public void setIntervalBegins(String intervalBegins) {
        this.intervalBegins = intervalBegins;
    }

    public String getIntervalEnds() {
        return this.intervalEnds;
    }

    public void setIntervalEnds(String intervalEnds) {
        this.intervalEnds = intervalEnds;
    }

    public boolean isUsingGlobalSASTServer() {
        return this.usingGlobalSASTServer;
    }

    public void setUsingGlobalSASTServer(boolean usingGlobalSASTServer) {
        this.usingGlobalSASTServer = usingGlobalSASTServer;
    }

    public boolean isUsingGlobalSASTSettings() {
        return this.usingGlobalSASTSettings;
    }

    public void setUsingGlobalSASTSettings(boolean usingGlobalSASTSettings) {
        this.usingGlobalSASTSettings = usingGlobalSASTSettings;
    }

    public boolean isUsingGlobalDependencyScan() {
        return this.usingGlobalDependencyScan;
    }

    public void setUsingGlobalDependencyScan(boolean usingGlobalDependencyScan) {
        this.usingGlobalDependencyScan = usingGlobalDependencyScan;
    }

    public boolean isUsingGlobalScanControlSettings() {
        return this.usingGlobalScanControlSettings;
    }

    public void setUsingGlobalScanControlSettings(boolean usingGlobalScanControlSettings) {
        this.usingGlobalScanControlSettings = usingGlobalScanControlSettings;
    }

    public boolean isDependencyScanEnabled() {
        return this.dependencyScanEnabled;
    }

    public void setDependencyScanEnabled(boolean dependencyScanEnabled) {
        this.dependencyScanEnabled = dependencyScanEnabled;
    }

    public ScannerType getDependencyScanType() {
        return this.dependencyScanType;
    }

    public void setDependencyScanType(ScannerType dependencyScanType) {
        this.dependencyScanType = dependencyScanType;
    }

    private boolean isSASTEnabled(ConfigurationMap configMap, String value) {
        Object enableSAST = configMap.get((Object)value);
        return enableSAST == null || "true".equals(enableSAST);
    }
}

