/*
 * Decompiled with CFR 0.152.
 */
package com.cx.plugin.testConnection;

import com.cx.plugin.configuration.CommonClientFactory;
import com.cx.plugin.testConnection.dto.TestConnectionResponse;
import com.cx.plugin.testConnection.dto.TestScaConnectionResponse;
import com.cx.plugin.utils.CxPluginUtils;
import com.cx.plugin.utils.HttpHelper;
import com.cx.restclient.CxClientDelegator;
import com.cx.restclient.ast.dto.sca.AstScaConfig;
import com.cx.restclient.configuration.CxScanConfig;
import com.cx.restclient.dto.ProxyConfig;
import com.cx.restclient.dto.ScannerType;
import com.cx.restclient.dto.SourceLocationType;
import com.cx.restclient.dto.Team;
import com.cx.restclient.sast.dto.Preset;
import com.cx.restclient.sast.utils.LegacyClient;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.codehaus.plexus.util.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/")
public class CxRestResource {
    private List<Preset> presets;
    private List<Team> teams;
    private LegacyClient commonClient;
    private String result = "";
    private Logger logger = LoggerFactory.getLogger(CxRestResource.class);

    @POST
    @Path(value="test/connection")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response testConnection(Map<Object, Object> data) {
        TestConnectionResponse tcResponse;
        int statusCode;
        block6: {
            this.result = "";
            statusCode = 400;
            String username = StringUtils.defaultString((Object)data.get("username"));
            String pas = StringUtils.defaultString((Object)data.get("pas"));
            String proxyEnable = StringUtils.defaultString((Object)data.get("proxyEnable"));
            try {
                String urlToCheck = StringUtils.defaultString((Object)data.get("url"));
                URL url = new URL(urlToCheck);
                String version = this.loginToServer(url, username, CxPluginUtils.decrypt(pas), proxyEnable);
                if (version != null) {
                    try {
                        this.teams = this.commonClient.getTeamList();
                    }
                    catch (Exception e) {
                        throw new Exception("Connection Failed.\nValidate the provided login credentials and server URL are correct.\nIn addition, make sure the installed plugin version is compatible with the CxSAST version according to CxSAST release notes.\nError: " + e.getMessage());
                    }
                    this.presets = this.commonClient.getPresetList();
                    if (this.presets == null || this.teams == null) {
                        throw new Exception("invalid preset teamPath");
                    }
                    this.result = "Connection successful";
                    tcResponse = new TestConnectionResponse(this.result, this.presets, this.teams);
                    tcResponse.setCxVersion(version);
                    statusCode = 200;
                    break block6;
                }
                this.result = this.result.contains("Failed to authenticate") ? "Failed to authenticate" : this.result;
                this.result = this.result.startsWith("Login failed.") ? this.result : "Login failed. " + this.result;
                tcResponse = this.getTCFailedResponse();
            }
            catch (Exception e) {
                this.result = "Fail to login: " + e.getMessage();
                tcResponse = this.getTCFailedResponse();
            }
        }
        return Response.status((int)statusCode).entity((Object)tcResponse).build();
    }

    @POST
    @Path(value="test/scaconnection")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response testScaConnection(Map<Object, Object> data) {
        TestScaConnectionResponse tcResponse;
        int statusCode = 400;
        try {
            String scaAccessControlUrl = StringUtils.defaultString((Object)data.get("scaAccessControlUrl"));
            String scaServerUrl = StringUtils.defaultString((Object)data.get("scaServerUrl"));
            String scaWebAppUrl = StringUtils.defaultString((Object)data.get("scaWebAppUrl"));
            String scaTenant = StringUtils.defaultString((Object)data.get("scaAccountName"));
            String username = StringUtils.defaultString((Object)data.get("scaUserName"));
            String pss = CxPluginUtils.decrypt(StringUtils.defaultString((Object)data.get("pss")));
            String proxyEnable = StringUtils.defaultString((Object)data.get("proxyEnable"));
            CxScanConfig config = new CxScanConfig();
            config.setDisableCertificateValidation(true);
            config.setOsaGenerateJsonReport(Boolean.valueOf(false));
            ProxyConfig proxyConfig = HttpHelper.getProxyConfig();
            if (proxyEnable != null && proxyEnable.equalsIgnoreCase("true") && proxyConfig != null) {
                config.setProxy(Boolean.valueOf(true));
                config.setProxyConfig(proxyConfig);
                this.logger.debug("Testing login with proxy details:");
                this.logger.debug("Proxy host: " + proxyConfig.getHost());
                this.logger.debug("Proxy port: " + proxyConfig.getPort());
                this.logger.debug("Proxy user: " + proxyConfig.getUsername());
                this.logger.debug("Proxy password: *************");
                this.logger.debug("Proxy Scheme: " + (proxyConfig.isUseHttps() ? "https" : "http"));
                this.logger.debug("Non Proxy Hosts: " + proxyConfig.getNoproxyHosts());
            } else {
                config.setProxy(Boolean.valueOf(false));
                this.logger.debug("Testing login.");
            }
            AstScaConfig scaConfig = new AstScaConfig();
            scaConfig.setAccessControlUrl(scaAccessControlUrl);
            scaConfig.setWebAppUrl(scaWebAppUrl);
            scaConfig.setApiUrl(scaServerUrl);
            scaConfig.setTenant(scaTenant);
            scaConfig.setUsername(username);
            scaConfig.setPassword(pss);
            scaConfig.setSourceLocationType(SourceLocationType.LOCAL_DIRECTORY);
            scaConfig.setRemoteRepositoryInfo(null);
            config.setAstScaConfig(scaConfig);
            config.addScannerType(ScannerType.AST_SCA);
            CxClientDelegator commonClient = CommonClientFactory.getClientDelegatorInstance(config, this.logger);
            commonClient.getScaClient().testScaConnection();
            tcResponse = new TestScaConnectionResponse("Connection successful.");
            statusCode = 200;
        }
        catch (Exception e) {
            tcResponse = new TestScaConnectionResponse("Failed to login: " + e.getMessage());
        }
        return Response.status((int)statusCode).entity((Object)tcResponse).build();
    }

    private Response getInvalidUrlResponse(int statusCode) {
        this.result = "Invalid URL";
        TestConnectionResponse tcResponse = new TestConnectionResponse(this.result, null, null);
        return Response.status((int)statusCode).entity((Object)tcResponse).build();
    }

    @NotNull
    private TestConnectionResponse getTCFailedResponse() {
        this.presets = new ArrayList<Preset>(){
            {
                new Preset(-1, "Unable to connect to server. Make sure URL and Credentials are valid to see presets list");
            }
        };
        this.teams = new ArrayList<Team>(){
            {
                new Team("noTeamPath", "Unable to connect to server. Make sure URL and Credentials are valid to see teams list");
            }
        };
        return new TestConnectionResponse(this.result, this.presets, this.teams);
    }

    private String loginToServer(URL url, String username, String password, String proxyEnable) {
        String version = null;
        try {
            ProxyConfig proxyConfig = HttpHelper.getProxyConfig();
            CxScanConfig scanConfig = new CxScanConfig(url.toString().trim(), username, password, "Bamboo", true);
            if (proxyEnable != null && proxyEnable.equalsIgnoreCase("true") && proxyConfig != null) {
                scanConfig.setProxy(Boolean.valueOf(true));
                scanConfig.setProxyConfig(proxyConfig);
                this.logger.debug("Testing login with proxy details:");
                this.logger.debug("Proxy host: " + proxyConfig.getHost());
                this.logger.debug("Proxy port: " + proxyConfig.getPort());
                this.logger.debug("Proxy user: " + proxyConfig.getUsername());
                this.logger.debug("Proxy password: *************");
                this.logger.debug("Proxy Scheme: " + (proxyConfig.isUseHttps() ? "https" : "http"));
                this.logger.debug("Non Proxy Hosts: " + proxyConfig.getNoproxyHosts());
            } else {
                scanConfig.setProxy(Boolean.valueOf(false));
                this.logger.debug("Testing login.");
            }
            this.commonClient = CommonClientFactory.getInstance(scanConfig, this.logger);
            String pluginVersion = "";
            try {
                Properties properties = new Properties();
                InputStream is = this.getClass().getClassLoader().getResourceAsStream("english.properties");
                if (is != null) {
                    properties.load(is);
                    pluginVersion = properties.getProperty("version");
                }
            }
            catch (Exception e) {
                this.logger.error("Error occured while loading propertied for plugin ", (Throwable)e);
            }
            System.setProperty("CxPluginVersion", pluginVersion);
            version = this.commonClient.login(Boolean.valueOf(true));
            return version;
        }
        catch (Exception cxClientException) {
            this.logger.error("Fail to login: ", (Throwable)cxClientException);
            this.result = cxClientException.getMessage();
            return version;
        }
    }
}

