/*
 * Decompiled with CFR 0.152.
 */
package com.cx.plugin.task;

import com.atlassian.bamboo.Key;
import com.atlassian.bamboo.build.artifact.ArtifactManager;
import com.atlassian.bamboo.plan.artifact.ArtifactDefinitionContext;
import com.atlassian.bamboo.plan.artifact.ArtifactDefinitionContextImpl;
import com.atlassian.bamboo.plan.artifact.ArtifactPublishingResult;
import com.atlassian.bamboo.task.CommonTaskContext;
import com.atlassian.bamboo.task.TaskContext;
import com.atlassian.bamboo.task.TaskException;
import com.atlassian.bamboo.task.TaskResult;
import com.atlassian.bamboo.task.TaskResultBuilder;
import com.atlassian.bamboo.task.TaskType;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.atlassian.bamboo.variable.VariableDefinitionContext;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.cx.plugin.configuration.CommonClientFactory;
import com.cx.plugin.dto.BambooScanResults;
import com.cx.plugin.utils.CxConfigHelper;
import com.cx.plugin.utils.CxLoggerAdapter;
import com.cx.plugin.utils.CxParam;
import com.cx.plugin.utils.CxPluginUtils;
import com.cx.restclient.CxClientDelegator;
import com.cx.restclient.configuration.CxScanConfig;
import com.cx.restclient.dto.ProxyConfig;
import com.cx.restclient.dto.Results;
import com.cx.restclient.dto.ScanResults;
import com.cx.restclient.dto.ScannerType;
import com.cx.restclient.dto.scansummary.ScanSummary;
import com.cx.restclient.exception.CxClientException;
import com.cx.restclient.sast.dto.CxXMLResults;
import com.cx.restclient.sast.dto.SASTResults;
import com.cx.restclient.sast.utils.LegacyClient;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.impl.StaticLoggerBinder;

public class CheckmarxTask
implements TaskType {
    private final ArtifactManager artifactManager;
    private static final String CX_ARM_WEBCLIENT_PATH = "cxarm/webclient/";

    public CheckmarxTask(@ComponentImport ArtifactManager artifactManager) {
        this.artifactManager = artifactManager;
    }

    @NotNull
    public TaskResult execute(@NotNull TaskContext taskContext) throws TaskException {
        StaticLoggerBinder binder = StaticLoggerBinder.getSingleton(taskContext.getBuildLogger());
        LegacyClient commonClient = null;
        BuildContext buildContext = taskContext.getBuildContext();
        TaskResultBuilder taskResultBuilder = TaskResultBuilder.newBuilder((CommonTaskContext)taskContext);
        CxLoggerAdapter log = new CxLoggerAdapter(taskContext.getBuildLogger());
        try {
            TaskResult taskResult;
            ScanResults finalScanResults;
            ScanSummary scanSummary;
            ProxyConfig proxy;
            String proxyHost;
            Map effectiveVariables = taskContext.getBuildContext().getVariableContext().getEffectiveVariables();
            for (Map.Entry entry : effectiveVariables.entrySet()) {
                if (!((String)entry.getKey()).contains("CX_") || !StringUtils.isNotEmpty((CharSequence)((VariableDefinitionContext)entry.getValue()).getValue())) continue;
                System.setProperty((String)entry.getKey(), ((VariableDefinitionContext)entry.getValue()).getValue());
            }
            CxConfigHelper configHelper = new CxConfigHelper(log);
            CxScanConfig config = configHelper.resolveConfigurationMap(taskContext.getConfigurationMap(), taskContext.getWorkingDirectory(), taskContext);
            String version = configHelper.getPluginVersion();
            System.setProperty("CxPluginVersion", version);
            config.setPluginVersion(version);
            CxClientDelegator delegator = CommonClientFactory.getClientDelegatorInstance(config, (Logger)log);
            CxPluginUtils.printConfiguration(config, configHelper, log);
            if (config.isProxy().booleanValue() && ((proxyHost = (proxy = config.getProxyConfig()).getHost()) == null || proxyHost.isEmpty())) {
                config.setProxy(Boolean.valueOf(false));
            }
            if (!(config.isSastEnabled() || config.isOsaEnabled() || config.isAstScaEnabled())) {
                log.error("Both SAST and Dependency Scan are disabled. Exiting.");
                taskResultBuilder.failed().build();
            }
            BambooScanResults ret = new BambooScanResults();
            ArrayList<ScanResults> results = new ArrayList<ScanResults>();
            try {
                commonClient = CommonClientFactory.getInstance(config, (Logger)log);
                ScanResults initResults = delegator.init();
                results.add(initResults);
            }
            catch (Exception ex) {
                if (ex.getMessage().contains("Server is unavailable")) {
                    try {
                        delegator.getSastClient().login();
                    }
                    catch (CxClientException e) {
                        throw new TaskException(e.getMessage());
                    }
                    throw new TaskException("Connection Failed.\nValidate the provided login credentials and server URL are correct.\nIn addition, make sure the installed plugin version is compatible with the CxSAST version according to CxSAST release notes.");
                }
                ret.setGeneralException(ex);
                throw new TaskException(ex.getMessage());
            }
            if (config.isOsaEnabled()) {
                String ex = "cxAppender_" + buildContext.getBuildKey().getKey();
            }
            ScanResults createScanResults = delegator.initiateScan();
            results.add(createScanResults);
            ScanResults scanResults = config.getSynchronous() != false ? delegator.waitForScanResults() : delegator.getLatestScanResults();
            ret.put(ScannerType.SAST, (Results)scanResults.getSastResults());
            SASTResults sastresult = scanResults.getSastResults();
            if (sastresult != null && sastresult.getQueryList() != null && !sastresult.getQueryList().isEmpty()) {
                ArrayList<CxXMLResults.Query> queryResult = new ArrayList<CxXMLResults.Query>();
                List sastQueryResult = sastresult.getQueryList();
                for (CxXMLResults.Query query : sastQueryResult) {
                    query.getResult().removeIf(result -> "1".equals(result.getState()));
                    if (query.getResult().isEmpty()) {
                        log.info("skipping query as the result is 0 for :" + query.getName());
                        continue;
                    }
                    queryResult.add(query);
                }
                sastresult.setQueryList(queryResult);
                ret.getResults().remove(ScannerType.SAST);
                ret.put(ScannerType.SAST, (Results)sastresult);
            }
            if (config.isOsaEnabled()) {
                ret.put(ScannerType.OSA, (Results)scanResults.getOsaResults());
            } else if (config.isAstScaEnabled()) {
                ret.put(ScannerType.AST_SCA, (Results)scanResults.getScaResults());
            }
            results.add(scanResults);
            if ((config.isSastEnabled() || config.isOsaEnabled()) && config.getEnablePolicyViolations() || config.isAstScaEnabled() && config.getEnablePolicyViolationsSCA()) {
                String newCxARMPolicyURL;
                Object cxARMPolicyURL = config.getCxARMUrl();
                if (cxARMPolicyURL != null && ((String)cxARMPolicyURL).contains("CxPolicyManagement")) {
                    newCxARMPolicyURL = ((String)cxARMPolicyURL).split("CxPolicyManagement")[0] + "CxPolicyManagement";
                } else {
                    if (cxARMPolicyURL == null || !((String)cxARMPolicyURL).endsWith("/")) {
                        cxARMPolicyURL = (String)cxARMPolicyURL + "/";
                    }
                    newCxARMPolicyURL = (String)cxARMPolicyURL + CX_ARM_WEBCLIENT_PATH;
                }
                config.setCxARMUrl(newCxARMPolicyURL);
                delegator.printIsProjectViolated(scanResults);
            }
            if ((scanSummary = new ScanSummary(config, ret.getSastResults(), ret.getOsaResults(), ret.getScaResults())).hasErrors() || ret.getGeneralException() != null || config.isSastEnabled() && (ret.getSastResults() == null || ret.getSastResults().getException() != null) || config.isOsaEnabled() && (ret.getOsaResults() == null || ret.getOsaResults().getException() != null) || config.isAstScaEnabled() && (ret.getScaResults() == null || ret.getScaResults().getException() != null)) {
                StringBuilder scanFailedAtServer = new StringBuilder();
                if (config.isSastEnabled() && (ret.getSastResults() == null || !ret.getSastResults().isSastResultsReady())) {
                    scanFailedAtServer.append("CxSAST scan results are not found. Scan might have failed at the server or aborted by the server.\n");
                }
                if (config.isOsaEnabled() && (ret.getOsaResults() == null || !ret.getOsaResults().isOsaResultsReady())) {
                    scanFailedAtServer.append("CxSAST OSA scan results are not found. Scan might have failed at the server or aborted by the server.\n");
                }
                if (config.isAstScaEnabled() && (ret.getScaResults() == null || !ret.getScaResults().isScaResultReady())) {
                    scanFailedAtServer.append("CxAST SCA scan results are not found. Scan might have failed at the server or aborted by the server.\n");
                }
                if (scanSummary.hasErrors() && scanFailedAtServer.toString().isEmpty()) {
                    scanFailedAtServer.append(scanSummary.toString());
                    CxPluginUtils.printBuildFailure(scanFailedAtServer.toString(), ret, log);
                } else if (scanSummary.hasErrors()) {
                    scanFailedAtServer.append("\n").append(scanSummary.toString());
                    CxPluginUtils.printBuildFailure(scanFailedAtServer.toString(), ret, log);
                }
                if (!scanSummary.hasErrors() && config.getSynchronous().booleanValue()) {
                    TaskResult taskResult2 = taskResultBuilder.failed().build();
                    return taskResult2;
                }
            }
            boolean generateAsyncReport = false;
            if (config.isSastEnabled() && ret.getSastResults() != null && ret.getSastResults().isSastResultsReady()) {
                generateAsyncReport = true;
            }
            if (config.isOsaEnabled() || config.isAstScaEnabled()) {
                generateAsyncReport = (!config.isOsaEnabled() || ret.getOsaResults() != null && ret.getOsaResults().isOsaResultsReady()) && (!config.isAstScaEnabled() || ret.getScaResults() != null && ret.getScaResults().isScaResultReady()) && (!config.isSastEnabled() || ret.getSastResults() != null && ret.getSastResults().isSastResultsReady());
            }
            if (!config.getSynchronous().booleanValue()) {
                log.info("Running in Asynchronous mode. Not waiting for scan to finish.");
                if (config.isSastEnabled() || config.isOsaEnabled() || config.isAstScaEnabled()) {
                    if (generateAsyncReport) {
                        finalScanResults = this.getFinalScanResults(results);
                        String scanHTMLSummary = delegator.generateHTMLSummary(finalScanResults);
                        ret.getSummary().put("htmlReport", scanHTMLSummary);
                        buildContext.getBuildResult().getCustomBuildData().putAll(ret.getSummary());
                        if (ret.getException() != null || ret.getGeneralException() != null) {
                            CxPluginUtils.printBuildFailure(null, ret, log);
                            TaskResult taskResult3 = taskResultBuilder.failed().build();
                            return taskResult3;
                        }
                        TaskResult taskResult4 = taskResultBuilder.success().build();
                        return taskResult4;
                    }
                    message = "<br><br><br><b>Job is configured to run Checkmarx scan asynchronously. Previous report not found.</b>";
                    ret.getSummary().put("htmlReport", message);
                    buildContext.getBuildResult().getCustomBuildData().putAll(ret.getSummary());
                } else {
                    message = "<br><br><br><b>Both SAST and Dependency Scan are disabled.</b>";
                    ret.getSummary().put("htmlReport", message);
                    buildContext.getBuildResult().getCustomBuildData().putAll(ret.getSummary());
                }
            }
            if (config.getSynchronous().booleanValue() && config.isSastEnabled() && (createScanResults.getSastResults() != null && createScanResults.getSastResults().getException() != null && createScanResults.getSastResults().getScanId() > 0L || scanResults.getSastResults() != null && scanResults.getSastResults().getException() != null)) {
                this.cancelScan(delegator);
            }
            finalScanResults = this.getFinalScanResults(results);
            if (!config.getHideResults().booleanValue()) {
                SASTResults sastResults = scanResults.getSastResults();
                if (config.getGeneratePDFReport().booleanValue()) {
                    ArtifactDefinitionContext pdfArt;
                    String sastPDFLink = sastResults.getSastPDFLink();
                    String pdfName = sastPDFLink.substring(sastPDFLink.lastIndexOf(File.separator) + 1);
                    Key buildKey = buildContext.getParentBuildContext().getResultKey().getEntityKey();
                    int buildNumber = buildContext.getParentBuildContext().getResultKey().getResultNumber();
                    String buildPath = buildContext.getPlanResultKey().getPlanKey().getKey().substring(buildContext.getPlanResultKey().getPlanKey().getKey().lastIndexOf("-") + 1);
                    String pdfBaseUrl = "";
                    if (config.getCxOriginUrl() != null) {
                        pdfBaseUrl = this.extractPDFBaseUrlFromCxOriginUrl(config.getCxOriginUrl());
                    }
                    if ((pdfArt = this.getPDFArt(taskContext)) != null) {
                        if (pdfArt.isSharedArtifact()) {
                            sastResults.setSastPDFLink(pdfBaseUrl + "/browse/" + buildKey + "-" + buildNumber + "/artifact/shared/" + pdfArt.getName() + "/" + pdfName);
                        } else {
                            sastResults.setSastPDFLink(pdfBaseUrl + "/browse/" + buildKey + "-" + buildNumber + "/artifact/" + buildPath + "/" + pdfArt.getName() + "/" + pdfName);
                        }
                    } else {
                        sastResults.setSastPDFLink(pdfBaseUrl + "/browse/" + buildKey + "-" + buildNumber + "/artifact/" + buildPath + "/Checkmarx-PDF-Report/" + pdfName);
                        ArtifactDefinitionContextImpl artifact = new ArtifactDefinitionContextImpl("Checkmarx PDF Report", false, taskContext.getBuildContext().getArtifactContext().getSecureToken());
                        artifact.setCopyPattern("**/" + pdfName);
                        ArtifactPublishingResult result2 = this.artifactManager.publish(taskContext.getBuildLogger(), buildContext.getPlanResultKey(), new File(taskContext.getWorkingDirectory(), CxParam.CX_REPORT_LOCATION), (ArtifactDefinitionContext)artifact, new HashMap(), 15);
                        taskContext.getBuildContext().getArtifactContext().addPublishingResult(result2);
                    }
                }
                if (config.getSynchronous().booleanValue()) {
                    String showSummaryStr = delegator.generateHTMLSummary(finalScanResults);
                    ret.getSummary().put("htmlReport", showSummaryStr);
                    buildContext.getBuildResult().getCustomBuildData().putAll(ret.getSummary());
                }
            }
            if (scanSummary.hasErrors()) {
                taskResult = taskResultBuilder.failed().build();
                return taskResult;
            }
            taskResult = taskResultBuilder.success().build();
            return taskResult;
        }
        catch (InterruptedException e) {
            log.error("Interrupted exception: " + e.getMessage(), e);
            throw new TaskException(e.getMessage());
        }
        catch (Exception e) {
            log.error("Unexpected exception: " + e.getMessage(), e);
            throw new TaskException(e.getMessage());
        }
        finally {
            if (commonClient != null) {
                commonClient.close();
            }
        }
    }

    private String extractPDFBaseUrlFromCxOriginUrl(String cxOriginUrl) {
        try {
            String path;
            int slashIndex;
            int nextSlashIndex;
            String baseUrl;
            int browseIndex;
            if (cxOriginUrl.contains("/browse") && (browseIndex = cxOriginUrl.indexOf("/browse")) != -1 && !StringUtils.isEmpty((CharSequence)(baseUrl = cxOriginUrl.substring(0, browseIndex))) && (nextSlashIndex = baseUrl.indexOf("/", (slashIndex = baseUrl.indexOf("://")) + 3)) != -1 && !(path = baseUrl.substring(nextSlashIndex)).isEmpty()) {
                return path;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "";
    }

    private ArtifactDefinitionContext getPDFArt(TaskContext taskContext) {
        if (!taskContext.getBuildContext().getArtifactContext().getDefinitionContexts().isEmpty()) {
            for (ArtifactDefinitionContext artDef : taskContext.getBuildContext().getArtifactContext().getDefinitionContexts()) {
                if (!StringUtils.isNotEmpty((CharSequence)artDef.getCopyPattern()) || !StringUtils.containsIgnoreCase((CharSequence)artDef.getCopyPattern(), (CharSequence)"pdf")) continue;
                return artDef;
            }
        }
        return null;
    }

    private ScanResults getFinalScanResults(List<ScanResults> results) {
        ScanResults scanResults = new ScanResults();
        for (int i = 0; i < results.size(); ++i) {
            Map resultsMap = results.get(i).getResults();
            for (Map.Entry entry : resultsMap.entrySet()) {
                if (entry != null && entry.getValue() != null && ((Results)entry.getValue()).getException() != null && scanResults.get((ScannerType)entry.getKey()) == null) {
                    scanResults.put((ScannerType)entry.getKey(), (Results)entry.getValue());
                }
                if (i != results.size() - 1 || entry == null || entry.getValue() == null || ((Results)entry.getValue()).getException() != null) continue;
                scanResults.put((ScannerType)entry.getKey(), (Results)entry.getValue());
            }
        }
        return scanResults;
    }

    private void cancelScan(CxClientDelegator delegator) {
        try {
            delegator.getSastClient().cancelSASTScan();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

