/*
 * Decompiled with CFR 0.152.
 */
package com.cx.plugin.results;

import com.atlassian.bamboo.chains.ChainResultsSummaryImpl;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.plugin.web.api.model.WebPanel;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CxPlanResultsWebPanel
implements WebPanel {
    private static final Logger log = LoggerFactory.getLogger(CxPlanResultsWebPanel.class);

    public String getHtml(Map<String, Object> map) {
        log.info("CxPlanResultsWebPanel.getHtml() called");
        try {
            ChainResultsSummaryImpl chainResultsSummaryImpl = (ChainResultsSummaryImpl)map.get("resultSummary");
            if (chainResultsSummaryImpl == null) {
                log.warn("resultSummary is null");
                return null;
            }
            if (chainResultsSummaryImpl.getOrderedJobResultSummaries().isEmpty()) {
                log.warn("No job result summaries found");
                return null;
            }
            Map results = ((ResultsSummary)chainResultsSummaryImpl.getOrderedJobResultSummaries().get(0)).getCustomBuildData();
            log.info("CustomBuildData keys: {}", results.keySet());
            String htmlReport = (String)results.get("htmlReport");
            log.info("HTML_REPORT value: {}", htmlReport != null ? "Found (length=" + htmlReport.length() + ")" : "null");
            return htmlReport;
        }
        catch (Exception e) {
            log.error("Error in CxPlanResultsWebPanel.getHtml()", (Throwable)e);
            return null;
        }
    }

    public void writeHtml(Writer writer, Map<String, Object> map) throws IOException {
        String html = this.getHtml(map);
        if (html != null) {
            writer.write(html);
        }
    }
}

