/*
 * Decompiled with CFR 0.152.
 */
package com.cx.plugin.configuration;

import com.atlassian.bamboo.configuration.AdministrationConfiguration;
import com.atlassian.bamboo.configuration.AdministrationConfigurationPersister;
import com.atlassian.bamboo.configuration.GlobalAdminAction;
import com.atlassian.spring.container.ContainerManager;
import com.cx.plugin.utils.CxPluginUtils;
import com.cx.plugin.utils.SASTUtils;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.struts2.interceptor.parameter.StrutsParameter;
import org.codehaus.plexus.util.StringUtils;

public class CxGlobalConfig
extends GlobalAdminAction {
    private String globalServerUrl;
    private String globalUsername;
    private String globalPss;
    private String globalcxScaUsername;
    private String globalcxScaPss;
    private String globalFilterPatterns = "!**/_cvs/**/*, !**/.svn/**/*,   !**/.hg/**/*,   !**/.git/**/*,  !**/.bzr/**/*, !**/bin/**/*,!**/obj/**/*,  !**/backup/**/*, !**/.idea/**/*, !**/*.DS_Store, !**/*.ipr,     !**/*.iws,   !**/*.bak,     !**/*.tmp,       !**/*.aac,      !**/*.aif,      !**/*.iff,     !**/*.m3u,   !**/*.mid,   !**/*.mp3,  !**/*.mpa,     !**/*.ra,        !**/*.wav,      !**/*.wma,      !**/*.3g2,     !**/*.3gp,   !**/*.asf,   !**/*.asx,  !**/*.avi,     !**/*.flv,       !**/*.mov,      !**/*.mp4,      !**/*.mpg,     !**/*.rm,    !**/*.swf,   !**/*.vob,  !**/*.wmv,     !**/*.bmp,       !**/*.gif,      !**/*.jpg,      !**/*.png,     !**/*.psd,   !**/*.tif,   !**/*.swf,  !**/*.jar,     !**/*.zip,       !**/*.rar,      !**/*.exe,      !**/*.dll,     !**/*.pdb,   !**/*.7z,    !**/*.gz,   !**/*.tar.gz,  !**/*.tar,       !**/*.gz,       !**/*.ahtm,     !**/*.ahtml,   !**/*.fhtml, !**/*.hdm,   !**/*.hdml,    !**/*.hsql,      !**/*.ht,       !**/*.hta,      !**/*.htc,     !**/*.htd,   !**/*.war,   !**/*.ear,  !**/*.htmls,   !**/*.ihtml,     !**/*.mht,      !**/*.mhtm,     !**/*.mhtml,   !**/*.ssi,   !**/*.stm,   !**/*.stml,    !**/*.ttml,      !**/*.txn,      !**/*.xhtm,     !**/*.xhtml,   !**/*.class, !**/*.iml,   !**/Checkmarx/Reports/**/* , !**/node_modules/**/*";
    private String globalFolderExclusions;
    private String globalIsSynchronous;
    private String globalEnableProxy;
    private String globalEnablePolicyViolations;
    private String globalEnablePolicyViolationsSCA;
    private String globalScanTimeoutInMinutes;
    private String globalThresholdsEnabled;
    private String globalCriticalThreshold;
    private String globalHighThreshold;
    private String globalMediumThreshold;
    private String globalLowThreshold;
    private String globalOsaThresholdsEnabled;
    private String globalOsaCriticalThreshold;
    private String globalOsaHighThreshold;
    private String globalOsaMediumThreshold;
    private String globalOsaLowThreshold;
    private String globalDenyProject;
    private String globalHideResults;
    private String globalEnableCriticalSeverity = "false";
    private String globalEnableDependencyScan = "false";
    private String globalDependencyScanType;
    private String globalDependencyScanFilterPatterns = "";
    private boolean criticalSupported = false;
    private String globalDependencyScanfolderExclusions;
    private String globalOsaArchiveIncludePatterns = "*.zip, *.tgz, *.war, *.ear";
    private String globalOsaInstallBeforeScan;
    private String globalcxScaAPIUrl = "https://api-sca.checkmarx.net";
    private String globalcxScaAccessControlServerUrl = "https://platform.checkmarx.net";
    private String globalcxScaWebAppUrl = "https://sca.checkmarx.net";
    private String globalcxScaAccountName = "";
    private String globalCxScaResolverEnabled;
    private String globalCxScaResolverPath;
    private String globalCxScaResolverAddParam;
    private Map<String, String> globalDependencyScanTypeValues = Map.of("OSA", "Use CxOSA dependency scanner", "AST_SCA", "Use CxSCA dependency scanner");

    public String execute() {
        AdministrationConfiguration adminConfig = (AdministrationConfiguration)ContainerManager.getComponent((String)"administrationConfiguration");
        this.globalServerUrl = adminConfig.getSystemProperty("globalServerUrl");
        this.globalUsername = adminConfig.getSystemProperty("globalUsername");
        this.globalPss = adminConfig.getSystemProperty("globalPss");
        if (adminConfig.getSystemProperty("globalEnableDependencyScan") != null && !adminConfig.getSystemProperty("globalEnableDependencyScan").isEmpty()) {
            this.globalEnableDependencyScan = adminConfig.getSystemProperty("globalEnableDependencyScan");
        }
        this.globalDependencyScanType = adminConfig.getSystemProperty("globalDependencyScanType");
        this.globalDependencyScanFilterPatterns = adminConfig.getSystemProperty("globalDependencyScanFilterPatterns");
        this.globalDependencyScanfolderExclusions = adminConfig.getSystemProperty("globalDependencyScanfolderExclusions");
        if (adminConfig.getSystemProperty("globalOsaArchiveIncludePatterns") != null && !adminConfig.getSystemProperty("globalOsaArchiveIncludePatterns").isEmpty()) {
            this.globalOsaArchiveIncludePatterns = adminConfig.getSystemProperty("globalOsaArchiveIncludePatterns");
        }
        this.globalOsaInstallBeforeScan = adminConfig.getSystemProperty("globalOsaInstallBeforeScan");
        if (adminConfig.getSystemProperty("globalcxScaAPIUrl") != null && !adminConfig.getSystemProperty("globalcxScaAPIUrl").isEmpty()) {
            this.globalcxScaAPIUrl = adminConfig.getSystemProperty("globalcxScaAPIUrl");
        }
        if (adminConfig.getSystemProperty("globalcxScaAccessControlServerUrl") != null && !adminConfig.getSystemProperty("globalcxScaAccessControlServerUrl").isEmpty()) {
            this.globalcxScaAccessControlServerUrl = adminConfig.getSystemProperty("globalcxScaAccessControlServerUrl");
        }
        if (adminConfig.getSystemProperty("globalcxScaWebAppUrl") != null && !adminConfig.getSystemProperty("globalcxScaWebAppUrl").isEmpty()) {
            this.globalcxScaWebAppUrl = adminConfig.getSystemProperty("globalcxScaWebAppUrl");
        }
        this.globalcxScaAccountName = adminConfig.getSystemProperty("globalcxScaAccountName");
        this.globalcxScaUsername = adminConfig.getSystemProperty("globalcxScaUsername");
        this.globalcxScaPss = adminConfig.getSystemProperty("globalcxScaPss");
        this.globalCxScaResolverEnabled = adminConfig.getSystemProperty("globalCxScaResolverEnabled");
        this.globalCxScaResolverPath = adminConfig.getSystemProperty("globalCxScaResolverPath");
        this.globalCxScaResolverAddParam = adminConfig.getSystemProperty("globalCxScaResolverAddParam");
        this.globalFolderExclusions = adminConfig.getSystemProperty("globalFolderExclusions");
        String filterProperty = adminConfig.getSystemProperty("globalFilterPatterns");
        if (filterProperty != null) {
            this.globalFilterPatterns = filterProperty;
        }
        this.globalEnableCriticalSeverity = adminConfig.getSystemProperty("globalEnableCriticalSeverity");
        this.globalScanTimeoutInMinutes = adminConfig.getSystemProperty("globalScanTimeoutInMinutes");
        this.globalIsSynchronous = adminConfig.getSystemProperty("globalIsSynchronous");
        this.globalEnableProxy = adminConfig.getSystemProperty("globalEnableProxy");
        this.globalHideResults = adminConfig.getSystemProperty("globalHideResults");
        this.globalEnablePolicyViolations = adminConfig.getSystemProperty("globalEnablePolicyViolations");
        this.globalEnablePolicyViolationsSCA = adminConfig.getSystemProperty("globalEnablePolicyViolationsSCA");
        this.globalThresholdsEnabled = adminConfig.getSystemProperty("globalThresholdsEnabled");
        this.globalCriticalThreshold = adminConfig.getSystemProperty("globalCriticalThreshold");
        this.globalHighThreshold = adminConfig.getSystemProperty("globalHighThreshold");
        this.globalMediumThreshold = adminConfig.getSystemProperty("globalMediumThreshold");
        this.globalLowThreshold = adminConfig.getSystemProperty("globalLowThreshold");
        this.globalOsaThresholdsEnabled = adminConfig.getSystemProperty("globalOsaThresholdsEnabled");
        this.globalOsaCriticalThreshold = adminConfig.getSystemProperty("globalOsaCriticalThreshold");
        this.globalOsaHighThreshold = adminConfig.getSystemProperty("globalOsaHighThreshold");
        this.globalOsaMediumThreshold = adminConfig.getSystemProperty("globalOsaMediumThreshold");
        this.globalOsaLowThreshold = adminConfig.getSystemProperty("globalOsaLowThreshold");
        this.globalDenyProject = adminConfig.getSystemProperty("globalDenyProject");
        return "input";
    }

    public String save() {
        boolean error = this.isURLInvalid(this.globalServerUrl, "globalServerUrl");
        AdministrationConfiguration adminConfig = (AdministrationConfiguration)ContainerManager.getComponent((String)"administrationConfiguration");
        error |= this.isScanTimeoutInvalid();
        if ("true".equals(this.globalEnableDependencyScan) && "AST_SCA".equals(this.globalDependencyScanType)) {
            error |= this.isURLInvalid(this.globalcxScaAPIUrl, "globalcxScaAPIUrl");
            error |= this.isURLInvalid(this.globalcxScaAccessControlServerUrl, "globalcxScaAccessControlServerUrl");
            error |= this.isURLInvalid(this.globalcxScaWebAppUrl, "globalcxScaWebAppUrl");
        }
        if ("true".equals(this.globalIsSynchronous)) {
            if ("true".equals(this.globalThresholdsEnabled)) {
                error |= this.isNegative(this.getGlobalCriticalThreshold(), "globalCriticalThreshold");
                error |= this.isNegative(this.getGlobalHighThreshold(), "globalHighThreshold");
                error |= this.isNegative(this.getGlobalMediumThreshold(), "globalMediumThreshold");
                error |= this.isNegative(this.getGlobalLowThreshold(), "globalLowThreshold");
            }
            if ("true".equals(this.globalOsaThresholdsEnabled)) {
                error |= this.isNegative(this.getGlobalOsaCriticalThreshold(), "globalOsaCriticalThreshold");
                error |= this.isNegative(this.getGlobalOsaHighThreshold(), "globalOsaHighThreshold");
                error |= this.isNegative(this.getGlobalOsaMediumThreshold(), "globalOsaMediumThreshold");
                error |= this.isNegative(this.getGlobalOsaLowThreshold(), "globalOsaLowThreshold");
            }
        }
        if (error) {
            return "error";
        }
        adminConfig.setSystemProperty("globalServerUrl", this.globalServerUrl);
        adminConfig.setSystemProperty("globalUsername", this.globalUsername);
        adminConfig.setSystemProperty("globalPss", CxPluginUtils.encrypt(this.globalPss));
        adminConfig.setSystemProperty("globalEnableDependencyScan", this.globalEnableDependencyScan);
        adminConfig.setSystemProperty("globalDependencyScanType", this.globalDependencyScanType);
        adminConfig.setSystemProperty("globalDependencyScanFilterPatterns", this.globalDependencyScanFilterPatterns);
        adminConfig.setSystemProperty("globalDependencyScanfolderExclusions", this.globalDependencyScanfolderExclusions);
        adminConfig.setSystemProperty("globalOsaArchiveIncludePatterns", this.globalOsaArchiveIncludePatterns);
        adminConfig.setSystemProperty("globalOsaInstallBeforeScan", this.globalOsaInstallBeforeScan);
        adminConfig.setSystemProperty("globalcxScaAPIUrl", this.globalcxScaAPIUrl);
        adminConfig.setSystemProperty("globalcxScaAccessControlServerUrl", this.globalcxScaAccessControlServerUrl);
        adminConfig.setSystemProperty("globalcxScaWebAppUrl", this.globalcxScaWebAppUrl);
        adminConfig.setSystemProperty("globalcxScaAccountName", this.globalcxScaAccountName);
        adminConfig.setSystemProperty("globalcxScaUsername", this.globalcxScaUsername);
        adminConfig.setSystemProperty("globalcxScaPss", CxPluginUtils.encrypt(this.globalcxScaPss));
        adminConfig.setSystemProperty("globalCxScaResolverEnabled", this.globalCxScaResolverEnabled);
        adminConfig.setSystemProperty("globalCxScaResolverPath", this.globalCxScaResolverPath);
        adminConfig.setSystemProperty("globalCxScaResolverAddParam", this.globalCxScaResolverAddParam);
        adminConfig.setSystemProperty("globalFolderExclusions", this.globalFolderExclusions);
        adminConfig.setSystemProperty("globalFilterPatterns", this.globalFilterPatterns);
        adminConfig.setSystemProperty("globalScanTimeoutInMinutes", this.globalScanTimeoutInMinutes);
        adminConfig.setSystemProperty("globalIsSynchronous", this.globalIsSynchronous);
        adminConfig.setSystemProperty("globalEnableProxy", this.globalEnableProxy);
        if (this.globalIsSynchronous == null) {
            this.globalThresholdsEnabled = null;
            this.globalOsaThresholdsEnabled = null;
            this.globalEnablePolicyViolations = null;
            this.globalEnablePolicyViolationsSCA = null;
        }
        adminConfig.setSystemProperty("globalEnablePolicyViolations", this.globalEnablePolicyViolations);
        adminConfig.setSystemProperty("globalEnablePolicyViolationsSCA", this.globalEnablePolicyViolationsSCA);
        adminConfig.setSystemProperty("globalThresholdsEnabled", this.globalThresholdsEnabled);
        adminConfig.setSystemProperty("globalHighThreshold", this.globalHighThreshold);
        adminConfig.setSystemProperty("globalMediumThreshold", this.globalMediumThreshold);
        adminConfig.setSystemProperty("globalLowThreshold", this.globalLowThreshold);
        adminConfig.setSystemProperty("globalOsaThresholdsEnabled", this.globalOsaThresholdsEnabled);
        adminConfig.setSystemProperty("globalOsaCriticalThreshold", this.globalOsaCriticalThreshold);
        adminConfig.setSystemProperty("globalOsaHighThreshold", this.globalOsaHighThreshold);
        adminConfig.setSystemProperty("globalOsaMediumThreshold", this.globalOsaMediumThreshold);
        adminConfig.setSystemProperty("globalOsaLowThreshold", this.globalOsaLowThreshold);
        adminConfig.setSystemProperty("globalDenyProject", this.globalDenyProject);
        adminConfig.setSystemProperty("globalHideResults", this.globalHideResults);
        if ("true".equals(this.globalIsSynchronous) && "true".equals(this.globalThresholdsEnabled)) {
            Double version = 9.0;
            try {
                String sastVersion = SASTUtils.loginToServer(new URL(this.globalServerUrl), this.globalUsername, CxPluginUtils.decrypt(this.globalPss), this.globalEnableProxy);
                String[] sastVersionSplit = sastVersion.split("\\.");
                version = Double.parseDouble(sastVersionSplit[0] + "." + sastVersionSplit[1]);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (version >= 9.7) {
                if ("false".equalsIgnoreCase(this.globalEnableCriticalSeverity)) {
                    this.globalEnableCriticalSeverity = "true";
                    this.globalCriticalThreshold = "";
                    this.addActionError("The configured SAST version supports Critical severity. Critical threshold can also be configured.");
                }
            } else if ("true".equalsIgnoreCase(this.globalEnableCriticalSeverity)) {
                this.globalEnableCriticalSeverity = "false";
                this.globalCriticalThreshold = "";
                this.addActionError("The configured SAST version does not support Critical severity. Critical threshold will not be applicable.");
            }
        }
        adminConfig.setSystemProperty("globalCriticalThreshold", this.globalCriticalThreshold);
        adminConfig.setSystemProperty("globalEnableCriticalSeverity", this.globalEnableCriticalSeverity);
        ((AdministrationConfigurationPersister)ContainerManager.getComponent((String)"administrationConfigurationPersister")).saveAdministrationConfiguration(adminConfig);
        this.addActionMessage(this.getText("cxDefaultConfigSuccess.label"));
        return "success";
    }

    private boolean isURLInvalid(String value, String fieldName) {
        boolean ret = false;
        if (!StringUtils.isEmpty((String)value)) {
            try {
                URL url = new URL(value);
                if (url.getPath().length() > 0) {
                    this.addFieldError(fieldName, "URL must not contain path");
                    ret = true;
                }
            }
            catch (MalformedURLException e) {
                this.addFieldError(fieldName, this.getText(fieldName + ".error.malformed"));
                ret = true;
            }
        }
        return ret;
    }

    private boolean isScanTimeoutInvalid() {
        boolean ret = false;
        String scanTimeout = this.getGlobalScanTimeoutInMinutes();
        if (!StringUtils.isEmpty((String)scanTimeout)) {
            try {
                int num = Integer.parseInt(scanTimeout);
                if (num <= 0) {
                    this.addFieldError("globalScanTimeoutInMinutes", this.getText("globalScanTimeoutInMinutes.notPositive"));
                    ret = true;
                }
            }
            catch (Exception e) {
                this.addFieldError("globalScanTimeoutInMinutes", this.getText("globalScanTimeoutInMinutes.notPositive"));
                ret = true;
            }
        }
        return ret;
    }

    private boolean isNegative(@Nonnull String value, @Nonnull String key) {
        boolean ret = false;
        if (!StringUtils.isEmpty((String)value)) {
            try {
                int num = Integer.parseInt(value);
                if (num < 0) {
                    this.addFieldError(key, this.getText(key + ".notPositive"));
                    ret = true;
                }
            }
            catch (Exception e) {
                this.addFieldError(key, this.getText(key + ".notPositive"));
                ret = true;
            }
        }
        return ret;
    }

    @StrutsParameter
    public String getGlobalServerUrl() {
        return this.globalServerUrl;
    }

    @StrutsParameter
    public void setGlobalServerUrl(String globalServerUrl) {
        this.globalServerUrl = globalServerUrl;
    }

    @StrutsParameter
    public String getGlobalUsername() {
        return this.globalUsername;
    }

    @StrutsParameter
    public void setGlobalUsername(String globalUsername) {
        this.globalUsername = globalUsername.trim();
    }

    @StrutsParameter
    public String getGlobalPss() {
        return this.globalPss;
    }

    @StrutsParameter
    public void setGlobalPss(String globalPss) {
        this.globalPss = globalPss;
    }

    @StrutsParameter
    public String getGlobalcxScaUsername() {
        return this.globalcxScaUsername;
    }

    @StrutsParameter
    public void setGlobalcxScaUsername(String globalcxScaUsername) {
        this.globalcxScaUsername = globalcxScaUsername;
    }

    @StrutsParameter
    public String getGlobalcxScaPss() {
        return this.globalcxScaPss;
    }

    @StrutsParameter
    public void setGlobalcxScaPss(String globalcxScaPss) {
        this.globalcxScaPss = globalcxScaPss;
    }

    @StrutsParameter
    public String getGlobalFilterPatterns() {
        return this.globalFilterPatterns;
    }

    @StrutsParameter
    public void setGlobalFilterPatterns(String globalFilterPatterns) {
        this.globalFilterPatterns = globalFilterPatterns;
    }

    @StrutsParameter
    public String getGlobalFolderExclusions() {
        return this.globalFolderExclusions;
    }

    @StrutsParameter
    public void setGlobalFolderExclusions(String globalFolderExclusions) {
        this.globalFolderExclusions = globalFolderExclusions;
    }

    @StrutsParameter
    public String getGlobalIsSynchronous() {
        return this.globalIsSynchronous;
    }

    @StrutsParameter
    public String getGlobalEnableProxy() {
        return this.globalEnableProxy;
    }

    @StrutsParameter
    public void setGlobalEnableProxy(String globalEnableProxy) {
        this.globalEnableProxy = globalEnableProxy;
    }

    @StrutsParameter
    public String getGlobalEnablePolicyViolations() {
        return this.globalEnablePolicyViolations;
    }

    @StrutsParameter
    public void setGlobalEnablePolicyViolations(String globalEnablePolicyViolations) {
        this.globalEnablePolicyViolations = globalEnablePolicyViolations;
    }

    @StrutsParameter
    public String getGlobalEnablePolicyViolationsSCA() {
        return this.globalEnablePolicyViolationsSCA;
    }

    @StrutsParameter
    public void setGlobalEnablePolicyViolationsSCA(String globalEnablePolicyViolationsSCA) {
        this.globalEnablePolicyViolationsSCA = globalEnablePolicyViolationsSCA;
    }

    @StrutsParameter
    public void setGlobalIsSynchronous(String globalIsSynchronous) {
        this.globalIsSynchronous = globalIsSynchronous;
    }

    @StrutsParameter
    public String getGlobalScanTimeoutInMinutes() {
        return this.globalScanTimeoutInMinutes;
    }

    @StrutsParameter
    public void setGlobalScanTimeoutInMinutes(String globalScanTimeoutInMinutes) {
        this.globalScanTimeoutInMinutes = globalScanTimeoutInMinutes.trim();
    }

    @StrutsParameter
    public String getGlobalThresholdsEnabled() {
        return this.globalThresholdsEnabled;
    }

    @StrutsParameter
    public void setGlobalThresholdsEnabled(String globalThresholdsEnabled) {
        this.globalThresholdsEnabled = globalThresholdsEnabled;
    }

    @StrutsParameter
    public String getGlobalCriticalThreshold() {
        return this.globalCriticalThreshold;
    }

    @StrutsParameter
    public void setGlobalCriticalThreshold(String globalCriticalThreshold) {
        this.globalCriticalThreshold = globalCriticalThreshold;
    }

    @StrutsParameter
    public String getGlobalHighThreshold() {
        return this.globalHighThreshold;
    }

    @StrutsParameter
    public void setGlobalHighThreshold(String globalHighThreshold) {
        this.globalHighThreshold = globalHighThreshold;
    }

    @StrutsParameter
    public String getGlobalMediumThreshold() {
        return this.globalMediumThreshold;
    }

    @StrutsParameter
    public void setGlobalMediumThreshold(String globalMediumThreshold) {
        this.globalMediumThreshold = globalMediumThreshold;
    }

    @StrutsParameter
    public String getGlobalLowThreshold() {
        return this.globalLowThreshold;
    }

    @StrutsParameter
    public void setGlobalLowThreshold(String globalLowThreshold) {
        this.globalLowThreshold = globalLowThreshold;
    }

    @StrutsParameter
    public String getGlobalOsaThresholdsEnabled() {
        return this.globalOsaThresholdsEnabled;
    }

    @StrutsParameter
    public void setGlobalOsaThresholdsEnabled(String globalOsaThresholdsEnabled) {
        this.globalOsaThresholdsEnabled = globalOsaThresholdsEnabled;
    }

    @StrutsParameter
    public String getGlobalOsaCriticalThreshold() {
        return this.globalOsaCriticalThreshold;
    }

    @StrutsParameter
    public void setGlobalOsaCriticalThreshold(String globalOsaCriticalThreshold) {
        this.globalOsaCriticalThreshold = globalOsaCriticalThreshold;
    }

    @StrutsParameter
    public String getGlobalOsaHighThreshold() {
        return this.globalOsaHighThreshold;
    }

    @StrutsParameter
    public void setGlobalOsaHighThreshold(String globalOsaHighThreshold) {
        this.globalOsaHighThreshold = globalOsaHighThreshold;
    }

    @StrutsParameter
    public String getGlobalOsaMediumThreshold() {
        return this.globalOsaMediumThreshold;
    }

    @StrutsParameter
    public void setGlobalOsaMediumThreshold(String globalOsaMediumThreshold) {
        this.globalOsaMediumThreshold = globalOsaMediumThreshold;
    }

    @StrutsParameter
    public String getGlobalOsaLowThreshold() {
        return this.globalOsaLowThreshold;
    }

    @StrutsParameter
    public void setGlobalOsaLowThreshold(String globalOsaLowThreshold) {
        this.globalOsaLowThreshold = globalOsaLowThreshold;
    }

    @StrutsParameter
    public String getGlobalDenyProject() {
        return this.globalDenyProject;
    }

    @StrutsParameter
    public void setGlobalDenyProject(String globalDenyProject) {
        this.globalDenyProject = globalDenyProject;
    }

    @StrutsParameter
    public String getGlobalHideResults() {
        return this.globalHideResults;
    }

    @StrutsParameter
    public void setGlobalHideResults(String globalHideResults) {
        this.globalHideResults = globalHideResults;
    }

    @StrutsParameter
    public String getGlobalEnableCriticalSeverity() {
        return this.globalEnableCriticalSeverity;
    }

    @StrutsParameter
    public void setGlobalEnableCriticalSeverity(String globalEnableCriticalSeverity) {
        this.globalEnableCriticalSeverity = globalEnableCriticalSeverity;
    }

    @StrutsParameter
    public String getGlobalEnableDependencyScan() {
        return this.globalEnableDependencyScan;
    }

    @StrutsParameter
    public void setGlobalEnableDependencyScan(String globalEnableDependencyScan) {
        this.globalEnableDependencyScan = globalEnableDependencyScan;
    }

    @StrutsParameter
    public String getGlobalDependencyScanType() {
        return this.globalDependencyScanType;
    }

    @StrutsParameter
    public void setGlobalDependencyScanType(String globalDependencyScanType) {
        this.globalDependencyScanType = globalDependencyScanType;
    }

    @StrutsParameter
    public String getGlobalDependencyScanFilterPatterns() {
        return this.globalDependencyScanFilterPatterns;
    }

    @StrutsParameter
    public void setGlobalDependencyScanFilterPatterns(String globalDependencyScanFilterPatterns) {
        this.globalDependencyScanFilterPatterns = globalDependencyScanFilterPatterns;
    }

    @StrutsParameter
    public String getGlobalDependencyScanfolderExclusions() {
        return this.globalDependencyScanfolderExclusions;
    }

    @StrutsParameter
    public void setGlobalDependencyScanfolderExclusions(String globalDependencyScanfolderExclusions) {
        this.globalDependencyScanfolderExclusions = globalDependencyScanfolderExclusions;
    }

    @StrutsParameter
    public String getGlobalOsaArchiveIncludePatterns() {
        return this.globalOsaArchiveIncludePatterns;
    }

    @StrutsParameter
    public void setGlobalOsaArchiveIncludePatterns(String globalOsaArchiveIncludePatterns) {
        this.globalOsaArchiveIncludePatterns = globalOsaArchiveIncludePatterns;
    }

    @StrutsParameter
    public String getGlobalOsaInstallBeforeScan() {
        return this.globalOsaInstallBeforeScan;
    }

    @StrutsParameter
    public void setGlobalOsaInstallBeforeScan(String globalOsaInstallBeforeScan) {
        this.globalOsaInstallBeforeScan = globalOsaInstallBeforeScan;
    }

    @StrutsParameter
    public String getGlobalcxScaAPIUrl() {
        return this.globalcxScaAPIUrl;
    }

    @StrutsParameter
    public void setGlobalcxScaAPIUrl(String globalcxScaAPIUrl) {
        this.globalcxScaAPIUrl = globalcxScaAPIUrl;
    }

    @StrutsParameter
    public String getGlobalcxScaAccessControlServerUrl() {
        return this.globalcxScaAccessControlServerUrl;
    }

    @StrutsParameter
    public void setGlobalcxScaAccessControlServerUrl(String globalcxScaAccessControlServerUrl) {
        this.globalcxScaAccessControlServerUrl = globalcxScaAccessControlServerUrl;
    }

    @StrutsParameter
    public String getGlobalcxScaWebAppUrl() {
        return this.globalcxScaWebAppUrl;
    }

    @StrutsParameter
    public void setGlobalcxScaWebAppUrl(String globalcxScaWebAppUrl) {
        this.globalcxScaWebAppUrl = globalcxScaWebAppUrl;
    }

    @StrutsParameter
    public String getGlobalcxScaAccountName() {
        return this.globalcxScaAccountName;
    }

    @StrutsParameter
    public void setGlobalcxScaAccountName(String globalcxScaAccountName) {
        this.globalcxScaAccountName = globalcxScaAccountName;
    }

    @StrutsParameter
    public String getGlobalCxScaResolverEnabled() {
        return this.globalCxScaResolverEnabled;
    }

    @StrutsParameter
    public void setGlobalCxScaResolverEnabled(String globalCxScaResolverEnabled) {
        this.globalCxScaResolverEnabled = globalCxScaResolverEnabled;
    }

    @StrutsParameter
    public String getGlobalCxScaResolverPath() {
        return this.globalCxScaResolverPath;
    }

    @StrutsParameter
    public void setGlobalCxScaResolverPath(String globalCxScaResolverPath) {
        this.globalCxScaResolverPath = globalCxScaResolverPath;
    }

    @StrutsParameter
    public String getGlobalCxScaResolverAddParam() {
        return this.globalCxScaResolverAddParam;
    }

    @StrutsParameter
    public void setGlobalCxScaResolverAddParam(String globalCxScaResolverAddParam) {
        this.globalCxScaResolverAddParam = globalCxScaResolverAddParam;
    }

    @StrutsParameter
    public Map<String, String> getGlobalDependencyScanTypeValues() {
        return this.globalDependencyScanTypeValues;
    }

    @StrutsParameter
    public void setGlobalDependencyScanTypeValues(Map<String, String> globalDependencyScanTypeValues) {
        this.globalDependencyScanTypeValues = globalDependencyScanTypeValues;
    }
}

