/*
 * Decompiled with CFR 0.152.
 */
package com.cx.plugin.configuration;

import com.atlassian.bamboo.credentials.UsernamePasswordCredentials;
import com.cx.plugin.configuration.CxCredException;
import com.cx.restclient.common.ErrorMessage;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;

public class CxCredentials {
    private String serverUrl;
    private String username;
    private String encryptedPassword;

    public String getServerUrl() {
        return this.serverUrl;
    }

    public void setServerUrl(String serverUrl) {
        this.serverUrl = serverUrl;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.encryptedPassword;
    }

    public void setPassword(String encryptedPassword) {
        this.encryptedPassword = encryptedPassword;
    }

    @NotNull
    private static CxCredentials getCxCredentials(String username, String pssd, String credId, CxCredentials ret, UsernamePasswordCredentials credentialsById) {
        if (StringUtils.isNotEmpty((String)credId)) {
            UsernamePasswordCredentials c = credentialsById;
            ret.setUsername(c != null ? c.getUsername() : "");
            ret.setPassword(c != null ? c.getPassword() : "");
            return ret;
        }
        ret.setUsername(StringUtils.defaultString((String)username));
        ret.setPassword(pssd);
        return ret;
    }

    public static void validateCxCredentials(CxCredentials credentials) throws CxCredException {
        if (StringUtils.isEmpty((String)credentials.getServerUrl()) || StringUtils.isEmpty((String)credentials.getUsername()) || StringUtils.isEmpty((String)credentials.getPassword())) {
            throw new CxCredException(ErrorMessage.CHECKMARX_SERVER_CONNECTION_FAILED.getErrorMessage());
        }
    }
}

