/*
 * Decompiled with CFR 0.152.
 */
package com.cx.plugin.configuration;

import com.atlassian.bamboo.collections.ActionParametersMap;
import com.atlassian.bamboo.configuration.AdministrationConfiguration;
import com.atlassian.bamboo.task.AbstractTaskConfigurator;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.ww2.actions.build.admin.config.task.ConfigureBuildTasks;
import com.atlassian.spring.container.ContainerManager;
import com.cx.plugin.configuration.CommonClientFactory;
import com.cx.plugin.utils.CxPluginUtils;
import com.cx.plugin.utils.HttpHelper;
import com.cx.plugin.utils.SASTUtils;
import com.cx.restclient.configuration.CxScanConfig;
import com.cx.restclient.dto.ProxyConfig;
import com.cx.restclient.dto.ScannerType;
import com.cx.restclient.dto.Team;
import com.cx.restclient.sast.dto.Preset;
import com.cx.restclient.sast.utils.LegacyClient;
import com.google.common.collect.ImmutableMap;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AgentTaskConfigurator
extends AbstractTaskConfigurator {
    private LinkedHashMap<String, String> presetList = new LinkedHashMap();
    private LinkedHashMap<String, String> teamPathList = new LinkedHashMap();
    private LinkedHashMap<String, String> intervalList = new LinkedHashMap();
    private LegacyClient commonClient = null;
    private AdministrationConfiguration adminConfig;
    private static final String DEFAULT_SETTING_LABEL = "Use Global Setting";
    private static final String SPECIFIC_SETTING_LABEL = "Use Specific Setting";
    private static final String DEFAULT_SERVER_URL = "http://";
    private static final int MAX_PROJECT_NAME_LENGTH = 200;
    private static final String DEFAULT_INTERVAL_BEGINS = "01:00";
    private static final String DEFAULT_INTERVAL_ENDS = "04:00";
    private boolean criticalSupported = false;
    private Map<String, String> CONFIGURATION_MODE_TYPES_MAP_SERVER = ImmutableMap.of((Object)"globalConfigurationServer", (Object)"Use Global Setting", (Object)"customConfigurationServer", (Object)"Use Specific Setting");
    private Map<String, String> CONFIGURATION_MODE_TYPES_MAP_CXSAST = ImmutableMap.of((Object)"globalConfigurationCxSAST", (Object)"Use Global Setting", (Object)"customConfigurationCxSAST", (Object)"Use Specific Setting");
    private Map<String, String> CONFIGURATION_MODE_TYPES_MAP_CONTROL = ImmutableMap.of((Object)"globalConfigurationControl", (Object)"Use Global Setting", (Object)"customConfigurationControl", (Object)"Use Specific Setting");
    private Map<String, String> DEPENDENCY_SCAN_TYPES_MAP_DEPENDENCY_SCAN = ImmutableMap.of((Object)"OSA", (Object)"Use CxOSA dependency scanner", (Object)"AST_SCA", (Object)"Use CxSCA dependency scanner");
    private final Logger log = LoggerFactory.getLogger(AgentTaskConfigurator.class);

    public void populateContextForCreate(@NotNull Map<String, Object> context) {
        this.adminConfig = (AdministrationConfiguration)ContainerManager.getComponent((String)"administrationConfiguration");
        super.populateContextForCreate(context);
        context.put("configurationModeTypesServer", this.CONFIGURATION_MODE_TYPES_MAP_SERVER);
        context.put("configurationModeTypesCxSAST", this.CONFIGURATION_MODE_TYPES_MAP_CXSAST);
        context.put("configurationModeTypesControl", this.CONFIGURATION_MODE_TYPES_MAP_CONTROL);
        context.put("dependencyScanTypeValues", this.DEPENDENCY_SCAN_TYPES_MAP_DEPENDENCY_SCAN);
        String projectName = this.resolveProjectName(context);
        context.put("projectName", projectName);
        context.put("serverUrl", DEFAULT_SERVER_URL);
        context.put("enableSASTScan", "true");
        context.put("enableProxy", this.getAdminConfig("globalEnableProxy"));
        context.put("globalEnableProxy", this.getAdminConfig("globalEnableProxy"));
        this.populateCredentialsFieldsForCreate(context);
        this.populateCxSASTFields(context, null, true);
        context.put("isIncremental", "false");
        context.put("isIntervals", "false");
        context.put("forceScan", "false");
        this.populateIntervals(context);
        context.put("intervalBegins", DEFAULT_INTERVAL_BEGINS);
        context.put("intervalEnds", DEFAULT_INTERVAL_ENDS);
        this.populateScanControlFields(context, null, true);
        context.put("generatePDFReport", "false");
        this.populateOSA_SCA_FieldsForCreate(context);
    }

    private String resolveProjectName(@NotNull Map<String, Object> context) {
        String projectName;
        try {
            Object plan = context.get("plan");
            Method getName = plan.getClass().getDeclaredMethod("getName", new Class[0]);
            projectName = (String)getName.invoke(plan, new Object[0]);
        }
        catch (Exception e) {
            projectName = "";
        }
        return projectName;
    }

    private void populateCredentialsFieldsForCreate(Map<String, Object> context) {
        String cxServerUrl = this.getAdminConfig("globalServerUrl");
        String cxUser = this.getAdminConfig("globalUsername");
        String cxPass = this.getAdminConfig("globalPss");
        String proxyEnable = this.getAdminConfig("globalEnableProxy");
        context.put("serverUrl", "");
        context.put("username", "");
        context.put("password", "");
        context.put("globalServerUrl", cxServerUrl);
        context.put("globalUsername", cxUser);
        context.put("globalPss", cxPass);
        context.put("serverCredentialsSection", "globalConfigurationServer");
        this.populateTeamAndPresetFields(cxServerUrl, cxUser, cxPass, proxyEnable, null, null, context);
    }

    private void populateTeamAndPresetFields(String serverUrl, String username, String password, String proxyEnable, String preset, String teamPath, @NotNull Map<String, Object> context) {
        try {
            if (this.tryLogin(username, CxPluginUtils.decrypt(password), serverUrl, proxyEnable)) {
                this.presetList = this.convertPresetToMap(this.commonClient.getPresetList());
                context.put("presetList", this.presetList);
                if (!StringUtils.isEmpty((String)preset)) {
                    context.put("presetId", preset);
                } else if (!this.presetList.isEmpty()) {
                    context.put("presetId", this.presetList.entrySet().iterator().next());
                }
                this.teamPathList = this.convertTeamPathToMap(this.commonClient.getTeamList());
                context.put("teamPathList", this.teamPathList);
                if (!StringUtils.isEmpty((String)teamPath)) {
                    context.put("teamPathId", teamPath);
                } else if (!this.teamPathList.isEmpty()) {
                    context.put("teamPathId", this.teamPathList.entrySet().iterator().next());
                }
            } else {
                HashMap<String, String> noPresets = new HashMap<String, String>();
                noPresets.put("noPreset", "Unable to connect to server. Make sure URL and Credentials are valid to see presets list");
                context.put("presetList", noPresets);
                HashMap<String, String> noTeams = new HashMap<String, String>();
                noTeams.put("noTeamPath", "Unable to connect to server. Make sure URL and Credentials are valid to see teams list");
                context.put("teamPathList", noTeams);
            }
        }
        catch (Exception e) {
            this.log.error("Exception caught during populateTeamAndPresetFields: '" + e.getMessage() + "'", (Throwable)e);
        }
    }

    public void populateContextForEdit(@NotNull Map<String, Object> context, @NotNull TaskDefinition taskDefinition) {
        this.adminConfig = (AdministrationConfiguration)ContainerManager.getComponent((String)"administrationConfiguration");
        super.populateContextForEdit(context, taskDefinition);
        Map configMap = taskDefinition.getConfiguration();
        context.put("configurationModeTypesServer", this.CONFIGURATION_MODE_TYPES_MAP_SERVER);
        context.put("configurationModeTypesCxSAST", this.CONFIGURATION_MODE_TYPES_MAP_CXSAST);
        context.put("configurationModeTypesControl", this.CONFIGURATION_MODE_TYPES_MAP_CONTROL);
        context.put("dependencyScanTypeValues", this.DEPENDENCY_SCAN_TYPES_MAP_DEPENDENCY_SCAN);
        context.put("projectName", configMap.get("projectName"));
        this.populateCredentialsFieldsForEdit(context, configMap);
        if (configMap.get("enableSASTScan") == null) {
            context.put("enableSASTScan", "true");
        } else {
            context.put("enableSASTScan", configMap.get("enableSASTScan"));
        }
        this.populateCxSASTFields(context, configMap, false);
        context.put("isIncremental", configMap.get("isIncremental"));
        context.put("forceScan", configMap.get("forceScan"));
        context.put("enableProxy", configMap.get("enableProxy"));
        String isIntervals = (String)configMap.get("isIntervals");
        context.put("isIntervals", isIntervals);
        this.populateIntervals(context);
        String intervalBegins = StringUtils.isEmpty((String)((String)configMap.get("intervalBegins"))) ? DEFAULT_INTERVAL_BEGINS : (String)configMap.get("intervalBegins");
        String intervalEnds = StringUtils.isEmpty((String)((String)configMap.get("intervalEnds"))) ? DEFAULT_INTERVAL_ENDS : (String)configMap.get("intervalEnds");
        context.put("intervalBegins", intervalBegins);
        context.put("intervalEnds", intervalEnds);
        context.put("generatePDFReport", configMap.get("generatePDFReport"));
        this.populateOSA_SCA_FieldsForEdit(context, configMap);
        this.populateScanControlFields(context, configMap, false);
    }

    private boolean checkVisiblityOfSCACriticalThreshold(String enableDependencyScan, String useCustomDependencySettings, String dependencyScanType, String globalDependencyScanType) {
        boolean visiblity = false;
        if ("true".equalsIgnoreCase(enableDependencyScan) && (!StringUtils.isEmpty((String)useCustomDependencySettings) && "true".equalsIgnoreCase(useCustomDependencySettings) ? "AST_SCA".equalsIgnoreCase(dependencyScanType) : "AST_SCA".equalsIgnoreCase(globalDependencyScanType))) {
            return true;
        }
        return visiblity;
    }

    private void populateOSA_SCA_FieldsForEdit(Map<String, Object> context, Map<String, String> configMap) {
        context.put("cxDependencySettingsCustom", configMap.get("cxDependencySettingsCustom"));
        String useCustomdependencyScanSettings = configMap.get("cxDependencySettingsCustom");
        boolean enableDependencyScan = Boolean.parseBoolean(configMap.get("enableDependencyScan"));
        context.put("enableDependencyScan", configMap.get("enableDependencyScan"));
        if (!StringUtils.isEmpty((String)useCustomdependencyScanSettings) && useCustomdependencyScanSettings.equalsIgnoreCase("true")) {
            dependencyScanType = configMap.get("dependencyScanType");
            String osaEnabled = "false";
            context.put("dependencyScanType", configMap.get("dependencyScanType"));
            if (enableDependencyScan && dependencyScanType.equalsIgnoreCase(ScannerType.OSA.toString())) {
                osaEnabled = "true";
            }
            context.put("osaEnabled", osaEnabled);
            context.put("cxOsaInstallBeforeScan", configMap.get("cxOsaInstallBeforeScan"));
            context.put("cxDependencyScanFilterPatterns", configMap.get("cxDependencyScanFilterPatterns"));
            context.put("cxDependencyScanfolderExclusions", configMap.get("cxDependencyScanfolderExclusions"));
            context.put("cxOsaArchiveIncludePatterns", configMap.get("cxOsaArchiveIncludePatterns"));
            context.put("cxScaAPIUrl", configMap.get("cxScaAPIUrl"));
            context.put("cxAccessControlServerUrl", configMap.get("cxAccessControlServerUrl"));
            context.put("cxScaWebAppUrl", configMap.get("cxScaWebAppUrl"));
            context.put("cxScaAccountName", configMap.get("cxScaAccountName"));
            context.put("cxScaUsername", configMap.get("cxScaUsername"));
            context.put("cxScaPassword", configMap.get("cxScaPassword"));
            context.put("cxScaResolverPath", configMap.get("cxScaResolverPath"));
            context.put("cxScaResolverAddParam", configMap.get("cxScaResolverAddParam"));
            context.put("cxScaResolverEnabled", configMap.get("cxScaResolverEnabled"));
        } else {
            dependencyScanType = this.getAdminConfig("globalDependencyScanType");
            String osaEnabled = "false";
            context.put("dependencyScanType", this.getAdminConfig("globalDependencyScanType"));
            if (enableDependencyScan && dependencyScanType.equalsIgnoreCase(ScannerType.OSA.toString())) {
                osaEnabled = "true";
            }
            context.put("osaEnabled", osaEnabled);
            context.put("cxOsaInstallBeforeScan", this.getAdminConfig("globalOsaInstallBeforeScan"));
            context.put("cxDependencyScanFilterPatterns", this.getAdminConfig("globalDependencyScanFilterPatterns"));
            context.put("cxDependencyScanfolderExclusions", this.getAdminConfig("globalDependencyScanfolderExclusions"));
            context.put("cxOsaArchiveIncludePatterns", this.getAdminConfig("globalOsaArchiveIncludePatterns"));
            context.put("cxScaAPIUrl", this.getAdminConfig("globalcxScaAPIUrl"));
            context.put("cxAccessControlServerUrl", this.getAdminConfig("globalcxScaAccessControlServerUrl"));
            context.put("cxScaWebAppUrl", this.getAdminConfig("globalcxScaWebAppUrl"));
            context.put("cxScaAccountName", this.getAdminConfig("globalcxScaAccountName"));
            context.put("cxScaUsername", this.getAdminConfig("globalcxScaUsername"));
            context.put("cxScaPassword", this.getAdminConfig("globalcxScaPss"));
            context.put("globalCxScaResolverPath", configMap.get("globalCxScaResolverPath"));
            context.put("globalCxScaResolverAddParam", configMap.get("globalCxScaResolverAddParam"));
            context.put("globalCxScaResolverEnabled", configMap.get("globalCxScaResolverEnabled"));
        }
        context.put("globalEnableDependencyScan", this.getAdminConfig("globalEnableDependencyScan"));
        context.put("globalDependencyScanType", this.getAdminConfig("globalDependencyScanType"));
        context.put("globalDependencyScanFilterPatterns", this.getAdminConfig("globalDependencyScanFilterPatterns"));
        context.put("globalDependencyScanfolderExclusions", this.getAdminConfig("globalDependencyScanfolderExclusions"));
        context.put("globalOsaArchiveIncludePatterns", this.getAdminConfig("globalOsaArchiveIncludePatterns"));
        context.put("globalcxScaAPIUrl", this.getAdminConfig("globalcxScaAPIUrl"));
        context.put("globalcxScaAccessControlServerUrl", this.getAdminConfig("globalcxScaAccessControlServerUrl"));
        context.put("globalcxScaWebAppUrl", this.getAdminConfig("globalcxScaWebAppUrl"));
        context.put("globalcxScaAccountName", this.getAdminConfig("globalcxScaAccountName"));
        context.put("globalcxScaUsername", this.getAdminConfig("globalcxScaUsername"));
        context.put("globalcxScaPss", this.getAdminConfig("globalcxScaPss"));
        context.put("globalCxScaResolverPath", configMap.get("globalCxScaResolverPath"));
        context.put("globalCxScaResolverAddParam", configMap.get("globalCxScaResolverAddParam"));
        context.put("globalCxScaResolverEnabled", configMap.get("globalCxScaResolverEnabled"));
        context.put("globalOsaArchiveIncludePatterns", this.getAdminConfig("globalOsaArchiveIncludePatterns"));
        context.put("globalOsaInstallBeforeScan", this.getAdminConfig("globalOsaInstallBeforeScan"));
        boolean visiblity = this.checkVisiblityOfSCACriticalThreshold(configMap.get("enableDependencyScan"), configMap.get("cxDependencySettingsCustom"), configMap.get("dependencyScanType"), this.getAdminConfig("globalDependencyScanType"));
        context.put("checkVisiblityOfSca", "" + visiblity);
    }

    private void populateOSA_SCA_FieldsForCreate(Map<String, Object> context) {
        context.put("enableDependencyScan", this.getAdminConfig("globalEnableDependencyScan"));
        context.put("dependencyScanType", this.getAdminConfig("globalDependencyScanType"));
        context.put("cxDependencyScanFilterPatterns", this.getAdminConfig("globalDependencyScanFilterPatterns"));
        context.put("cxDependencyScanfolderExclusions", this.getAdminConfig("globalDependencyScanfolderExclusions"));
        context.put("cxOsaArchiveIncludePatterns", this.getAdminConfig("globalOsaArchiveIncludePatterns"));
        context.put("cxOsaInstallBeforeScan", this.getAdminConfig("globalOsaInstallBeforeScan"));
        context.put("cxScaAPIUrl", this.getAdminConfig("globalcxScaAPIUrl"));
        context.put("cxAccessControlServerUrl", this.getAdminConfig("globalcxScaAccessControlServerUrl"));
        context.put("cxScaWebAppUrl", this.getAdminConfig("globalcxScaWebAppUrl"));
        context.put("cxScaAccountName", this.getAdminConfig("globalcxScaAccountName"));
        context.put("cxDependencySettingsCustom", "false");
        context.put("cxScaUsername", "");
        context.put("cxScaPassword", "");
        context.put("globalEnableDependencyScan", this.getAdminConfig("globalEnableDependencyScan"));
        context.put("globalDependencyScanType", this.getAdminConfig("globalDependencyScanType"));
        context.put("globalDependencyScanFilterPatterns", this.getAdminConfig("globalDependencyScanFilterPatterns"));
        context.put("globalDependencyScanfolderExclusions", this.getAdminConfig("globalDependencyScanfolderExclusions"));
        context.put("globalOsaArchiveIncludePatterns", this.getAdminConfig("globalOsaArchiveIncludePatterns"));
        context.put("globalcxScaAPIUrl", this.getAdminConfig("globalcxScaAPIUrl"));
        context.put("globalcxScaAccessControlServerUrl", this.getAdminConfig("globalcxScaAccessControlServerUrl"));
        context.put("globalcxScaWebAppUrl", this.getAdminConfig("globalcxScaWebAppUrl"));
        context.put("globalcxScaAccountName", this.getAdminConfig("globalcxScaAccountName"));
        context.put("globalcxScaUsername", this.getAdminConfig("globalcxScaUsername"));
        context.put("globalcxScaPss", this.getAdminConfig("globalcxScaPss"));
        context.put("globalCxScaResolverEnabled", this.getAdminConfig("globalCxScaResolverEnabled"));
        context.put("globalCxScaResolverPath", this.getAdminConfig("globalCxScaResolverPath"));
        context.put("globalCxScaResolverAddParam", this.getAdminConfig("globalCxScaResolverAddParam"));
        context.put("globalOsaArchiveIncludePatterns", this.getAdminConfig("globalOsaArchiveIncludePatterns"));
        context.put("globalOsaInstallBeforeScan", this.getAdminConfig("globalOsaInstallBeforeScan"));
        boolean visiblity = this.checkVisiblityOfSCACriticalThreshold(this.getAdminConfig("globalEnableDependencyScan"), "false", this.getAdminConfig("globalDependencyScanType"), this.getAdminConfig("globalDependencyScanType"));
        context.put("checkVisiblityOfSca", "" + visiblity);
    }

    private void populateCredentialsFieldsForEdit(@NotNull Map<String, Object> context, Map<String, String> configMap) {
        String cxProxyEnabled;
        String cxPass;
        String cxUser;
        String cxServerUrl;
        String configType = configMap.get("serverCredentialsSection");
        if ("globalConfigurationServer".equals(configType)) {
            cxServerUrl = this.getAdminConfig("globalServerUrl");
            cxUser = this.getAdminConfig("globalUsername");
            cxPass = this.getAdminConfig("globalPss");
            cxProxyEnabled = this.getAdminConfig("globalEnableProxy");
            context.put("serverUrl", configMap.get("globalServerUrl"));
            context.put("username", configMap.get("globalUsername"));
            context.put("password", configMap.get("globalPss"));
            context.put("enableProxy", configMap.get("globalEnableProxy"));
        } else {
            context.put("enableSASTScan", configMap.get("enableSASTScan"));
            cxServerUrl = configMap.get("serverUrl");
            cxUser = configMap.get("username");
            cxPass = configMap.get("password");
            cxProxyEnabled = configMap.get("enableProxy");
            context.put("serverUrl", configMap.get("serverUrl"));
            context.put("username", configMap.get("username"));
            context.put("password", configMap.get("password"));
            context.put("enableProxy", configMap.get("enableProxy"));
        }
        context.put("globalServerUrl", this.getAdminConfig("globalServerUrl"));
        context.put("globalUsername", this.getAdminConfig("globalUsername"));
        context.put("globalPss", this.getAdminConfig("globalPss"));
        context.put("globalEnableProxy", this.getAdminConfig("globalEnableProxy"));
        context.put("serverCredentialsSection", configType);
        String cxPreset = configMap.get("presetId");
        String cxTeam = configMap.get("teamPathId");
        this.populateTeamAndPresetFields(cxServerUrl, cxUser, cxPass, cxProxyEnabled, cxPreset, cxTeam, context);
    }

    private void populateCxSASTFields(@NotNull Map<String, Object> context, Map<String, String> configMap, boolean forCreate) {
        if (forCreate) {
            context.put("cxSastSection", "globalConfigurationCxSAST");
            context.put("folderExclusions", "");
            context.put("filterPatterns", "!**/_cvs/**/*, !**/.svn/**/*,   !**/.hg/**/*,   !**/.git/**/*,  !**/.bzr/**/*, !**/bin/**/*,!**/obj/**/*,  !**/backup/**/*, !**/.idea/**/*, !**/*.DS_Store, !**/*.ipr,     !**/*.iws,   !**/*.bak,     !**/*.tmp,       !**/*.aac,      !**/*.aif,      !**/*.iff,     !**/*.m3u,   !**/*.mid,   !**/*.mp3,  !**/*.mpa,     !**/*.ra,        !**/*.wav,      !**/*.wma,      !**/*.3g2,     !**/*.3gp,   !**/*.asf,   !**/*.asx,  !**/*.avi,     !**/*.flv,       !**/*.mov,      !**/*.mp4,      !**/*.mpg,     !**/*.rm,    !**/*.swf,   !**/*.vob,  !**/*.wmv,     !**/*.bmp,       !**/*.gif,      !**/*.jpg,      !**/*.png,     !**/*.psd,   !**/*.tif,   !**/*.swf,  !**/*.jar,     !**/*.zip,       !**/*.rar,      !**/*.exe,      !**/*.dll,     !**/*.pdb,   !**/*.7z,    !**/*.gz,   !**/*.tar.gz,  !**/*.tar,       !**/*.gz,       !**/*.ahtm,     !**/*.ahtml,   !**/*.fhtml, !**/*.hdm,   !**/*.hdml,    !**/*.hsql,      !**/*.ht,       !**/*.hta,      !**/*.htc,     !**/*.htd,   !**/*.war,   !**/*.ear,  !**/*.htmls,   !**/*.ihtml,     !**/*.mht,      !**/*.mhtm,     !**/*.mhtml,   !**/*.ssi,   !**/*.stm,   !**/*.stml,    !**/*.ttml,      !**/*.txn,      !**/*.xhtm,     !**/*.xhtml,   !**/*.class, !**/*.iml,   !**/Checkmarx/Reports/**/* , !**/node_modules/**/*");
            context.put("scanTimeoutInMinutes", "");
            context.put("comment", "");
        } else {
            context.put("cxSastSection", configMap.get("cxSastSection"));
            context.put("folderExclusions", configMap.get("folderExclusions"));
            context.put("filterPatterns", configMap.get("filterPatterns"));
            context.put("scanTimeoutInMinutes", configMap.get("scanTimeoutInMinutes"));
            context.put("comment", configMap.get("comment"));
        }
        context.put("globalFilterPatterns", this.getAdminConfig("globalFilterPatterns"));
        context.put("globalFolderExclusions", this.getAdminConfig("globalFolderExclusions"));
        context.put("globalFilterPatterns", this.getAdminConfig("globalFilterPatterns"));
        context.put("globalScanTimeoutInMinutes", this.getAdminConfig("globalScanTimeoutInMinutes"));
    }

    private void populateScanControlFields(@NotNull Map<String, Object> context, Map<String, String> configMap, boolean forCreate) {
        if (forCreate) {
            context.put("scanControlSection", "globalConfigurationControl");
            context.put("isSynchronous", "true");
            context.put("enablePolicyViolations", "false");
            context.put("enablePolicyViolationsSCA", "false");
            context.put("thresholdsEnabled", "false");
            context.put("enableCriticalSeverity", "false");
            context.put("criticalThreshold", "");
            context.put("highThreshold", "");
            context.put("mediumThreshold", "");
            context.put("lowThreshold", "");
            context.put("osaThresholdsEnabled", "false");
            context.put("osaCriticalThreshold", "");
            context.put("osaHighThreshold", "");
            context.put("osaMediumThreshold", "");
            context.put("osaLowThreshold", "");
        } else {
            context.put("scanControlSection", configMap.get("scanControlSection"));
            context.put("isSynchronous", configMap.get("isSynchronous"));
            context.put("enablePolicyViolations", configMap.get("enablePolicyViolations"));
            context.put("enablePolicyViolationsSCA", configMap.get("enablePolicyViolationsSCA"));
            context.put("thresholdsEnabled", configMap.get("thresholdsEnabled"));
            context.put("enableCriticalSeverity", configMap.get("enableCriticalSeverity"));
            context.put("criticalThreshold", configMap.get("criticalThreshold"));
            context.put("highThreshold", configMap.get("highThreshold"));
            context.put("mediumThreshold", configMap.get("mediumThreshold"));
            context.put("lowThreshold", configMap.get("lowThreshold"));
            context.put("osaThresholdsEnabled", configMap.get("osaThresholdsEnabled"));
            context.put("osaCriticalThreshold", configMap.get("osaCriticalThreshold"));
            context.put("osaHighThreshold", configMap.get("osaHighThreshold"));
            context.put("osaMediumThreshold", configMap.get("osaMediumThreshold"));
            context.put("osaLowThreshold", configMap.get("osaLowThreshold"));
        }
        context.put("globalIsSynchronous", this.getAdminConfig("globalIsSynchronous"));
        context.put("globalEnablePolicyViolations", this.getAdminConfig("globalEnablePolicyViolations"));
        context.put("globalEnablePolicyViolationsSCA", this.getAdminConfig("globalEnablePolicyViolationsSCA"));
        context.put("globalThresholdsEnabled", this.getAdminConfig("globalThresholdsEnabled"));
        context.put("globalCriticalThreshold", this.getAdminConfig("globalCriticalThreshold"));
        context.put("globalHighThreshold", this.getAdminConfig("globalHighThreshold"));
        context.put("globalMediumThreshold", this.getAdminConfig("globalMediumThreshold"));
        context.put("globalLowThreshold", this.getAdminConfig("globalLowThreshold"));
        context.put("globalOsaThresholdsEnabled", this.getAdminConfig("globalOsaThresholdsEnabled"));
        context.put("globalOsaCriticalThreshold", this.getAdminConfig("globalOsaCriticalThreshold"));
        context.put("globalOsaHighThreshold", this.getAdminConfig("globalOsaHighThreshold"));
        context.put("globalOsaMediumThreshold", this.getAdminConfig("globalOsaMediumThreshold"));
        context.put("globalOsaLowThreshold", this.getAdminConfig("globalOsaLowThreshold"));
        context.put("globalHideResults", this.getAdminConfig("globalHideResults"));
        context.put("globalDenyProject", this.getAdminConfig("globalDenyProject"));
    }

    @NotNull
    public Map<String, String> generateTaskConfigMap(@NotNull ActionParametersMap params, @Nullable TaskDefinition previousTaskDefinition) {
        Map<String, String> config = super.generateTaskConfigMap(params, previousTaskDefinition);
        config = this.generateCredentialsFields(params, config);
        config.put("enableSASTScan", params.getString("enableSASTScan"));
        config.put("projectName", this.getDefaultString(params, "projectName").trim());
        config.put("generatePDFReport", params.getString("generatePDFReport"));
        config.put("enableProxy", params.getString("enableProxy"));
        String presetId = params.getString("presetId");
        String presetName = "";
        if (!"noPreset".equals(presetId)) {
            config.put("presetId", presetId);
            if (this.presetList.isEmpty()) {
                if (this.commonClient != null || this.tryLogin(params.getString("username"), CxPluginUtils.decrypt(params.getString("password")), params.getString("serverUrl"), params.getString("enableProxy"))) {
                    try {
                        Preset preset = this.commonClient.getPresetById(Integer.parseInt(presetId));
                        presetName = preset.getName();
                    }
                    catch (Exception e) {
                        presetName = "";
                    }
                }
            } else {
                presetName = this.presetList.get(presetId);
            }
            config.put("presetName", presetName);
        }
        String teamId = params.getString("teamPathId");
        String teaName = "";
        if (!"noTeamPath".equals(teamId)) {
            config.put("teamPathId", teamId);
            if (this.teamPathList.isEmpty()) {
                if (this.commonClient != null || this.tryLogin(params.getString("username"), CxPluginUtils.decrypt(params.getString("password")), params.getString("serverUrl"), params.getString("enableProxy"))) {
                    try {
                        teaName = this.commonClient.getTeamNameById(teamId);
                    }
                    catch (Exception e) {
                        teaName = "";
                    }
                }
            } else {
                teaName = this.teamPathList.get(teamId);
            }
            config.put("teamPathName", teaName);
        }
        config.put("isSynchronous", params.getString("isSynchronous"));
        config.put("enablePolicyViolations", params.getString("enablePolicyViolations"));
        config.put("enablePolicyViolationsSCA", params.getString("enablePolicyViolationsSCA"));
        config.put("isIncremental", params.getString("isIncremental"));
        config.put("forceScan", params.getString("forceScan"));
        config.put("isIntervals", params.getString("isIntervals"));
        config.put("intervalBegins", this.getDefaultString(params, "intervalBegins"));
        config.put("intervalEnds", this.getDefaultString(params, "intervalEnds"));
        config = this.generateCxSASTFields(params, config);
        config = this.generateScanControlFields(params, config);
        config = this.generateCxOSAAndSCAFields(params, config);
        return config;
    }

    private Map<String, String> generateCredentialsFields(@NotNull ActionParametersMap params, Map<String, String> config) {
        String configType = this.getDefaultString(params, "serverCredentialsSection");
        config.put("serverCredentialsSection", configType);
        config.put("serverUrl", this.getDefaultString(params, "serverUrl").trim());
        config.put("username", this.getDefaultString(params, "username").trim());
        config.put("password", CxPluginUtils.encrypt(this.getDefaultString(params, "password")));
        return config;
    }

    private Map<String, String> generateCxOSAAndSCAFields(@NotNull ActionParametersMap params, Map<String, String> config) {
        config.put("cxDependencySettingsCustom", this.getDefaultString(params, "cxDependencySettingsCustom").trim());
        config.put("enableDependencyScan", this.getDefaultString(params, "enableDependencyScan").trim());
        String useCustomdependencyScanSettings = this.getDefaultString(params, "cxDependencySettingsCustom").trim();
        if (!StringUtils.isEmpty((String)useCustomdependencyScanSettings) && useCustomdependencyScanSettings.equalsIgnoreCase("true")) {
            configType = this.getDefaultString(params, "dependencyScanType");
            config.put("dependencyScanType", configType);
            config.put("cxOsaInstallBeforeScan", this.getDefaultString(params, "cxOsaInstallBeforeScan").trim());
            config.put("cxDependencyScanFilterPatterns", this.getDefaultString(params, "cxDependencyScanFilterPatterns").trim());
            config.put("cxDependencyScanfolderExclusions", this.getDefaultString(params, "cxDependencyScanfolderExclusions").trim());
            config.put("cxOsaArchiveIncludePatterns", this.getDefaultString(params, "cxOsaArchiveIncludePatterns").trim());
            config.put("cxScaAPIUrl", this.getDefaultString(params, "cxScaAPIUrl").trim());
            config.put("cxAccessControlServerUrl", this.getDefaultString(params, "cxAccessControlServerUrl").trim());
            config.put("cxScaWebAppUrl", this.getDefaultString(params, "cxScaWebAppUrl").trim());
            config.put("cxScaAccountName", this.getDefaultString(params, "cxScaAccountName").trim());
            config.put("cxScaUsername", this.getDefaultString(params, "cxScaUsername").trim());
            config.put("cxScaPassword", CxPluginUtils.encrypt(this.getDefaultString(params, "cxScaPassword").trim()));
            config.put("cxScaResolverEnabled", this.getDefaultString(params, "cxScaResolverEnabled").trim());
            config.put("cxScaResolverPath", this.getDefaultString(params, "cxScaResolverPath").trim());
            config.put("cxScaResolverAddParam", this.getDefaultString(params, "cxScaResolverAddParam").trim());
        } else {
            configType = this.getAdminConfig("globalDependencyScanType");
            config.put("dependencyScanType", configType);
            config.put("cxOsaInstallBeforeScan", this.getAdminConfig("globalOsaInstallBeforeScan").trim());
            config.put("cxDependencyScanFilterPatterns", this.getAdminConfig("globalDependencyScanFilterPatterns").trim());
            config.put("cxDependencyScanfolderExclusions", this.getAdminConfig("globalDependencyScanfolderExclusions").trim());
            config.put("cxOsaArchiveIncludePatterns", this.getAdminConfig("globalOsaArchiveIncludePatterns").trim());
            config.put("cxScaAPIUrl", this.getAdminConfig("globalcxScaAPIUrl").trim());
            config.put("cxAccessControlServerUrl", this.getAdminConfig("globalcxScaAccessControlServerUrl").trim());
            config.put("cxScaWebAppUrl", this.getAdminConfig("globalcxScaWebAppUrl").trim());
            config.put("cxScaAccountName", this.getAdminConfig("globalcxScaAccountName").trim());
            config.put("cxScaUsername", this.getAdminConfig("globalcxScaUsername").trim());
            config.put("cxScaPassword", this.getAdminConfig("globalcxScaPss").trim());
            config.put("globalCxScaResolverEnabled", this.getAdminConfig("globalCxScaResolverEnabled").trim());
            config.put("globalCxScaResolverPath", this.getAdminConfig("globalCxScaResolverPath").trim());
            config.put("globalCxScaResolverAddParam", this.getAdminConfig("globalCxScaResolverAddParam").trim());
        }
        boolean visiblity = this.checkVisiblityOfSCACriticalThreshold(this.getDefaultString(params, "enableDependencyScan").trim(), this.getDefaultString(params, "cxDependencySettingsCustom").trim(), this.getDefaultString(params, "dependencyScanType"), this.getAdminConfig("globalDependencyScanType"));
        config.put("checkVisiblityOfSca", "" + visiblity);
        return config;
    }

    private Map<String, String> generateCxSASTFields(@NotNull ActionParametersMap params, Map<String, String> config) {
        config.put("enableSASTScan", this.getDefaultString(params, "enableSASTScan").trim());
        String configType = this.getDefaultString(params, "cxSastSection");
        config.put("cxSastSection", configType);
        config.put("folderExclusions", this.getDefaultString(params, "folderExclusions").trim());
        config.put("filterPatterns", this.getDefaultString(params, "filterPatterns").trim());
        config.put("scanTimeoutInMinutes", this.getDefaultString(params, "scanTimeoutInMinutes").trim());
        config.put("comment", this.getDefaultString(params, "comment").trim());
        return config;
    }

    private Map<String, String> generateScanControlFields(@NotNull ActionParametersMap params, Map<String, String> config) {
        String configType = this.getDefaultString(params, "scanControlSection");
        config.put("scanControlSection", configType);
        config.put("thresholdsEnabled", params.getString("thresholdsEnabled"));
        config.put("enableCriticalSeverity", params.getString("enableCriticalSeverity"));
        config.put("criticalThreshold", this.getDefaultString(params, "criticalThreshold"));
        config.put("highThreshold", this.getDefaultString(params, "highThreshold"));
        config.put("mediumThreshold", this.getDefaultString(params, "mediumThreshold"));
        config.put("lowThreshold", this.getDefaultString(params, "lowThreshold"));
        config.put("osaThresholdsEnabled", params.getString("osaThresholdsEnabled"));
        config.put("osaCriticalThreshold", this.getDefaultString(params, "osaCriticalThreshold"));
        config.put("osaHighThreshold", this.getDefaultString(params, "osaHighThreshold"));
        config.put("osaMediumThreshold", this.getDefaultString(params, "osaMediumThreshold"));
        config.put("osaLowThreshold", this.getDefaultString(params, "osaLowThreshold"));
        return config;
    }

    private String getDefaultString(@NotNull ActionParametersMap params, String key) {
        return StringUtils.defaultString((String)params.getString(key));
    }

    private boolean tryLogin(String username, String cxPass, String serverUrl, String proxyEnable) {
        this.log.debug("Testing login with: server URL: " + serverUrl + " username" + username);
        if (!(StringUtils.isEmpty((String)serverUrl) || StringUtils.isEmpty((String)username) || StringUtils.isEmpty((String)cxPass))) {
            try {
                try {
                    CxScanConfig scanConfig = new CxScanConfig(serverUrl, username, CxPluginUtils.decrypt(cxPass), "Bamboo", true);
                    ProxyConfig proxyConfig = HttpHelper.getProxyConfig();
                    if (proxyEnable != null && proxyEnable.equalsIgnoreCase("true") && proxyConfig != null) {
                        scanConfig.setProxy(Boolean.valueOf(true));
                        scanConfig.setProxyConfig(proxyConfig);
                        this.log.debug("Testing login with proxy details:");
                        this.log.debug("Proxy host: " + proxyConfig.getHost());
                        this.log.debug("Proxy port: " + proxyConfig.getPort());
                        this.log.debug("Proxy user: " + proxyConfig.getUsername());
                        this.log.debug("Proxy password: *************");
                        this.log.debug("Proxy Scheme: " + (proxyConfig.isUseHttps() ? "https" : "http"));
                        this.log.debug("Non Proxy Hosts: " + proxyConfig.getNoproxyHosts());
                    } else {
                        scanConfig.setProxy(Boolean.valueOf(false));
                        this.log.debug("Testing login.");
                    }
                    this.commonClient = CommonClientFactory.getInstance(scanConfig, this.log);
                }
                catch (Exception e) {
                    this.log.debug("Failed to initialize cx client " + e.getMessage(), (Throwable)e);
                    this.commonClient = null;
                }
                this.commonClient.login();
                return true;
            }
            catch (Exception e) {
                this.log.debug("Failed to login to retrieve data from server. " + e.getMessage(), (Throwable)e);
                this.commonClient = null;
            }
        }
        return false;
    }

    private LinkedHashMap<String, String> convertPresetToMap(List<Preset> oldType) {
        LinkedHashMap<String, String> newType = new LinkedHashMap<String, String>();
        for (Preset preset : oldType) {
            newType.put(Long.toString(preset.getId()), preset.getName());
        }
        return newType;
    }

    private LinkedHashMap<String, String> convertTeamPathToMap(List<Team> oldType) {
        LinkedHashMap<String, String> newType = new LinkedHashMap<String, String>();
        for (Team team : oldType) {
            newType.put(team.getId(), team.getFullName());
        }
        return newType;
    }

    public void validate(@NotNull ActionParametersMap params, @NotNull ErrorCollection errorCollection) {
        super.validate(params, errorCollection);
        if (params.getBoolean("isIncremental") && params.getBoolean("forceScan")) {
            errorCollection.addError("forceScan", ((ConfigureBuildTasks)errorCollection).getText("errorForceIncrementalScan.equals"));
            errorCollection.addError("isIncremental", ((ConfigureBuildTasks)errorCollection).getText("errorForceIncrementalScan.equals"));
        }
        String useSpecific = params.getString("serverCredentialsSection");
        boolean scaResolverEnabled = params.getBoolean("cxScaResolverEnabled");
        boolean scaResolverEnabledGlobal = params.getBoolean("globalCxScaResolverEnabled");
        boolean useGlobalSettings = params.getBoolean("cxDependencySettingsCustom");
        boolean enableDependancyScan = params.getBoolean("enableDependencyScan");
        if ("customConfigurationServer".equals(useSpecific)) {
            this.validateNotEmpty(params, errorCollection, "username");
            this.validateNotEmpty(params, errorCollection, "password");
            this.validateNotEmpty(params, errorCollection, "serverUrl");
            this.validateUrl(params, errorCollection, "serverUrl");
        }
        this.validateNotEmpty(params, errorCollection, "projectName");
        if (scaResolverEnabled && useGlobalSettings && enableDependancyScan) {
            this.validateNotEmpty(params, errorCollection, "cxScaResolverPath");
        }
        if (scaResolverEnabledGlobal && !useGlobalSettings && enableDependancyScan) {
            this.validateNotEmpty(params, errorCollection, "globalCxScaResolverPath");
        }
        this.containsIllegals(params, errorCollection, "projectName");
        this.validateProjectNameLength(params, errorCollection, "projectName");
        if (params.getBoolean("isIncremental") && params.getBoolean("isIntervals") && params.getString("intervalBegins").equals(params.getString("intervalEnds"))) {
            errorCollection.addError("intervalEnds", ((ConfigureBuildTasks)errorCollection).getText("intervals.equals"));
        }
        if ("customConfigurationCxSAST".equals(useSpecific = params.getString("cxSastSection"))) {
            this.validatePositive(params, errorCollection, "scanTimeoutInMinutes");
        }
        if ("customConfigurationControl".equals(useSpecific = params.getString("scanControlSection"))) {
            this.validateNotNegative(params, errorCollection, "criticalThreshold");
            this.validateCriticalSupport(params, errorCollection, "criticalThreshold");
            this.validateNotNegative(params, errorCollection, "highThreshold");
            this.validateNotNegative(params, errorCollection, "mediumThreshold");
            this.validateNotNegative(params, errorCollection, "lowThreshold");
            this.validateNotNegative(params, errorCollection, "osaCriticalThreshold");
            this.validateNotNegative(params, errorCollection, "osaHighThreshold");
            this.validateNotNegative(params, errorCollection, "osaMediumThreshold");
            this.validateNotNegative(params, errorCollection, "osaLowThreshold");
        }
        if (errorCollection.hasAnyErrors()) {
            errorCollection.addError("errorOccurred", "Configuration settings were not saved. Please review your settings and try again");
        }
    }

    private void validateNotEmpty(@NotNull ActionParametersMap params, @NotNull ErrorCollection errorCollection, @NotNull String key) {
        String value = params.getString(key);
        if (StringUtils.isEmpty((String)value)) {
            errorCollection.addError(key, ((ConfigureBuildTasks)errorCollection).getText(key + ".error"));
        }
    }

    private void validateUrl(@NotNull ActionParametersMap params, @NotNull ErrorCollection errorCollection, @NotNull String key) {
        String value = params.getString(key);
        if (!StringUtils.isEmpty((String)value)) {
            try {
                URL url = new URL(value);
                if (url.getPath().length() > 0) {
                    errorCollection.addError(key, ((ConfigureBuildTasks)errorCollection).getText(key + ".error.malformed"));
                }
            }
            catch (MalformedURLException e) {
                errorCollection.addError(key, ((ConfigureBuildTasks)errorCollection).getText(key + ".error.malformed"));
            }
        }
    }

    private void containsIllegals(@NotNull ActionParametersMap params, @NotNull ErrorCollection errorCollection, @NotNull String key) {
        Matcher matcher;
        String toExamine = params.getString(key);
        Pattern pattern = Pattern.compile("[/?<>\\:*|\"]");
        if (toExamine != null && (matcher = pattern.matcher(toExamine)).find()) {
            errorCollection.addError(key, ((ConfigureBuildTasks)errorCollection).getText(key + ".containsIllegals"));
        }
    }

    private void validateProjectNameLength(@NotNull ActionParametersMap params, @NotNull ErrorCollection errorCollection, @NotNull String key) {
        String toExamine = params.getString(key);
        if (toExamine != null && toExamine.length() > 200) {
            errorCollection.addError(key, ((ConfigureBuildTasks)errorCollection).getText(key + ".invalidLength"));
        }
    }

    private void validatePositive(@NotNull ActionParametersMap params, @NotNull ErrorCollection errorCollection, @NotNull String key) {
        String value = params.getString(key);
        if (!StringUtils.isEmpty((String)value)) {
            try {
                int num = Integer.parseInt(value.trim());
                if (num > 0) {
                    return;
                }
                errorCollection.addError(key, ((ConfigureBuildTasks)errorCollection).getText(key + ".notPositive"));
            }
            catch (Exception e) {
                errorCollection.addError(key, ((ConfigureBuildTasks)errorCollection).getText(key + ".notPositive"));
            }
        }
    }

    private void validateNotNegative(@NotNull ActionParametersMap params, @NotNull ErrorCollection errorCollection, @NotNull String key) {
        String value = params.getString(key);
        if (!StringUtils.isEmpty((String)value)) {
            try {
                int num = Integer.parseInt(value);
                if (num >= 0) {
                    return;
                }
                errorCollection.addError(key, ((ConfigureBuildTasks)errorCollection).getText(key + ".notPositive"));
            }
            catch (Exception e) {
                errorCollection.addError(key, ((ConfigureBuildTasks)errorCollection).getText(key + ".notPositive"));
            }
        }
    }

    private void validateCriticalSupport(@NotNull ActionParametersMap params, @NotNull ErrorCollection errorCollection, @NotNull String key) {
        Double version = 9.0;
        if ("true".equalsIgnoreCase(params.getString("isSynchronous")) && "true".equalsIgnoreCase(params.getString("thresholdsEnabled"))) {
            String cxServerUrl = "";
            String cxUser = "";
            String cxPass = "";
            String proxyEnable = "";
            if ("globalConfigurationServer".equalsIgnoreCase(params.getString("serverCredentialsSection"))) {
                cxServerUrl = this.getAdminConfig("globalServerUrl");
                cxUser = this.getAdminConfig("globalUsername");
                cxPass = this.getAdminConfig("globalPss");
                proxyEnable = this.getAdminConfig("globalEnableProxy");
            } else {
                cxUser = params.getString("username");
                cxPass = params.getString("password");
                cxServerUrl = params.getString("serverUrl");
                proxyEnable = params.getString("enableProxy");
            }
            try {
                String sastVersion = SASTUtils.loginToServer(new URL(cxServerUrl), cxUser, CxPluginUtils.decrypt(cxPass), proxyEnable);
                String[] sastVersionSplit = sastVersion.split("\\.");
                version = Double.parseDouble(sastVersionSplit[0] + "." + sastVersionSplit[1]);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (version >= 9.7) {
                if ("false".equalsIgnoreCase(params.getString("enableCriticalSeverity"))) {
                    params.put((Object)"enableCriticalSeverity", (Object)"true");
                    params.put((Object)"criticalThreshold", (Object)"");
                    errorCollection.addError("criticalThreshold", "The configured SAST version supports Critical severity. Critical threshold can also be configured.");
                }
            } else if ("true".equalsIgnoreCase(params.getString("enableCriticalSeverity"))) {
                params.put((Object)"enableCriticalSeverity", (Object)"false");
                params.put((Object)"criticalThreshold", (Object)"");
                errorCollection.addError("highThreshold", "The configured SAST version does not support Critical severity. Critical threshold will not be applicable.");
            }
        }
    }

    private String getAdminConfig(String key) {
        if (this.adminConfig == null) {
            this.adminConfig = (AdministrationConfiguration)ContainerManager.getComponent((String)"administrationConfiguration");
        }
        return StringUtils.defaultString((String)this.adminConfig.getSystemProperty(key));
    }

    private void populateIntervals(@NotNull Map<String, Object> context) {
        this.intervalList.put("00:00", "12.00 am");
        this.intervalList.put(DEFAULT_INTERVAL_BEGINS, "01.00 am");
        this.intervalList.put("02:00", "02.00 am");
        this.intervalList.put("03:00", "03.00 am");
        this.intervalList.put(DEFAULT_INTERVAL_ENDS, "04.00 am");
        this.intervalList.put("05:00", "05.00 am");
        this.intervalList.put("06:00", "06.00 am");
        this.intervalList.put("08:00", "08.00 am");
        this.intervalList.put("09:00", "09.00 am");
        this.intervalList.put("10:00", "10.00 am");
        this.intervalList.put("11:00", "11.00 am");
        this.intervalList.put("12:00", "12.00 pm");
        this.intervalList.put("13:00", "01.00 pm");
        this.intervalList.put("14:00", "02.00 pm");
        this.intervalList.put("15:00", "03.00 pm");
        this.intervalList.put("16:00", "04.00 pm");
        this.intervalList.put("17:00", "05.00 pm");
        this.intervalList.put("18:00", "06.00 pm");
        this.intervalList.put("19:00", "07.00 pm");
        this.intervalList.put("20:00", "08.00 pm");
        this.intervalList.put("21:00", "09.00 pm");
        this.intervalList.put("22:00", "10.00 pm");
        this.intervalList.put("23:00", "11.00 pm");
        context.put("intervalBeginsList", this.intervalList);
        context.put("intervalEndsList", this.intervalList);
    }
}

