define('widget/dependencyGraph/chain-result-dependency-graph-app', [
    'underscore',
    'jquery',
    'widget/dependencyGraph/chain-result-dependency-graph-model',
    'widget/dependencyGraph/chain-result-dependency-graph-view',
    'marionette',
    'aui/flag',
    'aui'
], function(_,
            $,
            ChainResultDependencyGraphModel,
            ChainResultDependencyGraphView,
            Marionette,
            Flag,
            AJS) {
    'use strict';
    /**
     * Chain dependency graph application.
     *
     * Configuration options:
     * - el (mandatory) - anchor for this app
     * - key (mandatory) - plan key
     * - buildNumber (mandatory) - build result number
     */
    return Marionette.Application.extend({
        model: null,
        el: null,
        key: null,
        buildNumber: null,

        initialize: function(options) {
            var settings = options || {};
            this.el = $(settings.el);
            this.key = settings.key;
            this.buildNumber = settings.buildNumber;
        },

        onStart: function() {
            this.addRegions({
                main: this.el
            });
            var key = this.key;
            var buildNumber = this.buildNumber;
            this.model = new ChainResultDependencyGraphModel({key: key, buildNumber: buildNumber});
            this.model.fetch({
                success: _.bind(this.onFetchSuccess, this),
                error: _.bind(this.onFetchErrorHandler, this)
            });
        },
        onFetchSuccess: function(model, response, options) {
            var linksCount = model.get('links').length;
            if (linksCount == 0) {
                AJS.trigger('analytics',
                    {
                        name: 'com.atlassianlabs.bamboo.plugins.dependency.graph.chain.result.response.empty'
                    }
                );
            }
            else {
                AJS.trigger('analytics',
                    {
                        name: 'com.atlassianlabs.bamboo.plugins.dependency.graph.chain.result.response',
                        data: {
                            nodesCount: model.get('elements').length,
                            linksCount: linksCount
                        }
                    }
                );
            }
            this.getRegion('main').show(new ChainResultDependencyGraphView({model: model}));
        },
        onFetchErrorHandler: function(collection, response, options) {
            new Flag({
                type: 'error',
                close: 'manual',
                body: AJS.I18n.getText('chain.dependencyGraph.fetch.error')
            });
        }
    });
});