define('widget/dependencyGraph/chain-dependency-graph-app', [
    'underscore',
    'jquery',
    'widget/dependencyGraph/chain-dependency-graph-model',
    'widget/dependencyGraph/chain-dependency-graph-view',
    'marionette',
    'aui/flag',
    'aui'
], function(_,
            $,
            ChainDependencyGraphModel,
            ChainDependencyGraphView,
            Marionette,
            Flag,
            AJS) {
    'use strict';
    /**
     * Chain dependency graph application.
     *
     * Configuration options:
     * - el (mandatory) - anchor for this app
     * - key (mandatory) - plan key
     * - showChild (mandatory) - show child plans
     * - showArtifacts (mandatory) - show plans which consume artifacts
     */
    return Marionette.Application.extend({
        model: null,
        el: null,
        key: null,
        $showChild: null,
        $showArtifacts: null,

        initialize: function(options) {
            var settings = options || {};
            this.el = settings.el;
            this.key = settings.key;
            this.$showChild = $(settings.showChild);
            this.$showArtifacts = $(settings.showArtifacts);

            this.$showArtifacts.on('change', _.bind(this.refreshGraph, this));
            this.$showChild.on('change', _.bind(this.refreshGraph, this));
        },

        onStart: function() {
            this.addRegions({
                main: this.el
            });
            var key = this.key;
            this.model = new ChainDependencyGraphModel({key: key});
            this.refreshGraph();
        },
        refreshGraph: function() {
            var showChild = this.$showChild.prop('checked');
            var showArtifacts = this.$showArtifacts.prop('checked');
            AJS.trigger('analytics',
                {
                    name: 'com.atlassianlabs.bamboo.plugins.dependency.graph.chain.request',
                    data: {
                        children: showChild,
                        artifacts: showArtifacts
                    }
                }
            );
            this.model.fetch({
                success: _.bind(this.onFetchSuccess, this),
                error: _.bind(this.onFetchErrorHandler, this),
                dataType: "json",
                data: {
                    children: showChild,
                    artifacts: showArtifacts
                }
            });
        },
        onFetchSuccess: function(model, response, options) {
            var linksCount = model.get('links').length;
            if (linksCount == 0) {
                AJS.trigger('analytics',
                    {
                        name: 'com.atlassianlabs.bamboo.plugins.dependency.graph.chain.response.empty'
                    }
                );
            } else {
                AJS.trigger('analytics',
                    {
                        name: 'com.atlassianlabs.bamboo.plugins.dependency.graph.chain.response',
                        data: {
                            nodesCount: model.get('elements').length,
                            linksCount: linksCount
                        }
                    }
                );
            }
            this.getRegion('main').show(new ChainDependencyGraphView({model: model}));
        },
        onFetchErrorHandler: function(model, response, options) {
            new Flag({
                type: 'error',
                close: 'manual',
                body: AJS.I18n.getText('chain.dependencyGraph.fetch.error')
            });
        }
    });
});