define('widget/dependencyGraph/dependency-graph', [
    'widget/dependencyGraph/d3'
], function(d3) {
    return {
        /**
         * Draw directional graph of dependency.
         * @param model
         * @param width svg width
         * @param height svg height
         * @param dblClickHandler function called on doubleClick on node
         */
        draw: function(model, width, height, dblClickHandler) {
            var nodes = {};
            var links = {};
            model.get('links').forEach(function(link) {
                link.source = nodes[link.sourceId] || (nodes[link.sourceId] = {name: link.sourceId});
                link.target = nodes[link.destinationId] || (nodes[link.destinationId] = {name: link.destinationId});
            });
            var root = model.get('rootId');
            var force = d3.layout.force()
                .nodes(d3.values(nodes))
                .links(model.get('links'))
                .size([width, height])
                .linkDistance(100)
                .charge(-500)
                .on('tick', tick)
                .start();
            var svg = d3.select('#svg').append('g');

// build the arrow.
            svg.append('svg:defs').selectAll('marker')
                .data(model.get('links'))
                .enter().append('svg:marker')
                .attr('id', function(d,i){
                    return 'end-arrow' + i;
                })
                .attr('viewBox', '0 -5 10 10')
                .attr('refX', 15)
                .attr('refY', -1.5)
                .attr('markerWidth', 6)
                .attr('markerHeight', 6)
                .attr('orient', 'auto')
                .append('svg:path')
                .attr('d', 'M0,-5L9,0L0,5')
                    .attr("class", function(d) { return d.type; });
            // add the links and the arrows
            var path = svg.append('svg:g').selectAll('path')
                .data(force.links())
                .enter()
                .append('svg:path')
                .attr('class', function(d) {
                    return 'link ' + d.type;
                })
                .attr('marker-end', function(d,i){
                    return "url(#end-arrow"+i+")";
                });

// define the nodes
            var node = svg.selectAll('.node')
                .data(force.nodes())
                .enter().append('g')
                .attr('class', 'node')
                .call(force.drag);

// add the nodes
            node.append('circle')
                .attr('r', 5)
                .attr('class', function(d) {
                    if (d.name == root) {
                        return 'root';
                    }
                })
                .on('mouseover', function(d) {
                    // enlarge target node
                    d3.select(this).attr('transform', 'scale(2.0)');
                })
                .on('mouseout', function(d) {
                    // unenlarge target node
                    d3.select(this).attr('transform', '');
                })
                .on('dblclick', dblClickHandler);

// add the text
            node.append('text')
                .attr('x', 14)
                .attr('dy', '.55em')
                .attr('class', function(d) {
                    if (d.name == root) {
                        return 'root';
                    }
                })
                .text(function(d) {
                    return d.name;
                });
            // add the curvy lines
            function tick() {
                path.attr('d', function(d) {
                    var dx = d.target.x - d.source.x,
                        dy = d.target.y - d.source.y,
                        dr = Math.sqrt(dx * dx + dy * dy);
                    return 'M' +
                        d.source.x + ',' +
                        d.source.y + 'A' +
                        dr + ',' + dr + ' 0 0,1 ' +
                        d.target.x + ',' +
                        d.target.y;
                });

                node
                    .attr('transform', function(d) {
                        return 'translate(' + d.x + ',' + d.y + ')';
                    });
            }
        }
    }
});