define('widget/dependencyGraph/chain-dependency-graph-view', [
    'marionette',
    'widget/dependencyGraph/d3',
    'widget/dependencyGraph/dependency-graph',
    'aui'
], function(Marionette,
            d3,
            graph,
            AJS) {
    'use strict';
    var EDIT_URL = '/chain/admin/config/viewChainDependencyGraphPanel.action?buildKey=';
    return Marionette.ItemView.extend({
        width: 800,
        height: 500,
        template: function() {
            return '<svg id="svg" width="800px" height="500px"></svg>'
        },
        onShow: function() {
            var model = this.model;

            if (model.get('links').length == 0) {
                d3.select('#svg').append('text')
                    .attr('x', 14)
                    .attr('dy', '4em')
                    .attr('class', 'empty-chain')
                    .text(AJS.I18n.getText('dependencyGraph.chain.empty'));
            } else {
                graph.draw(model, this.width, this.height, function(d) {
                    AJS.trigger('analyticsEvent',
                        {
                            name: 'com.atlassianlabs.bamboo.plugins.dependency.graph.chain.node.clicked'
                        }
                    );
                    setTimeout(function() {
                        location.replace(AJS.contextPath() + EDIT_URL + d.name);
                    }, 500);
                });
            }
        }
    });
});