define('widget/dependencyGraph/chain-result-dependency-graph-view', [
    'marionette',
    'widget/dependencyGraph/dependency-graph',
    'aui'
], function(Marionette,
            graph,
            AJS) {
    'use strict';
    var VIEW_RESULT_URL = '/build/result/viewChainResultDependencyGraphPanel.action?buildKey=%BUILD_KEY%&buildNumber=';
    return Marionette.ItemView.extend({
        width: 800,
        height: 500,
        template: function() {
            return '<svg id="svg" width="800px" height="500px"></svg>'
        },
        onShow: function() {
            var model = this.model;
            if (model.get('links').length == 0) {
                d3.select('#svg').append('text')
                    .attr('x', 14)
                    .attr('dy', '4em')
                    .attr('class', 'empty-chain')
                    .text(AJS.I18n.getText('dependencyGraph.chain.result.empty'));
            } else {
                graph.draw(model, this.width, this.height, function(d) {
                    var planResultKey = d.name;
                    var firstIndex = planResultKey.indexOf('-');
                    var secondIndexOf = planResultKey.indexOf('-', firstIndex + 1);
                    if (firstIndex != -1 && secondIndexOf != -1) {
                        var url = VIEW_RESULT_URL.replace('%BUILD_KEY%', planResultKey.substring(0, secondIndexOf));
                        AJS.trigger('analyticsEvent',
                            {
                                name: 'com.atlassianlabs.bamboo.plugins.dependency.graph.chain.result.node.clicked'
                            }
                        );
                        setTimeout(function() {
                            location.replace(AJS.contextPath() + url + planResultKey.substr(secondIndexOf + 1));
                        }, 500);
                    }
                });
            }
        }
    });
});