/*
 * Decompiled with CFR 0.152.
 */
package com.atlassianlabs.bamboo.plugins.dependency.graph.service;

import com.atlassian.bamboo.build.PlanDependencyManager;
import com.atlassian.bamboo.plan.PlanIdentifier;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.PlanResultKey;
import com.atlassian.bamboo.plan.cache.CachedPlanManager;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.plan.cache.ImmutableJob;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.plan.cache.ImmutableTopLevelPlan;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.resultsummary.ResultsSummaryManager;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.utils.Range;
import com.atlassian.bamboo.v2.build.trigger.DependencyTriggerReason;
import com.atlassian.bamboo.v2.build.trigger.TriggerReason;
import com.atlassianlabs.bamboo.plugins.dependency.graph.model.DependencyGraphSettings;
import com.atlassianlabs.bamboo.plugins.dependency.graph.model.Entity;
import com.atlassianlabs.bamboo.plugins.dependency.graph.model.Link;
import com.atlassianlabs.bamboo.plugins.dependency.graph.model.Structure;
import com.atlassianlabs.bamboo.plugins.dependency.graph.service.StructureService;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;

@Component
public class StructureServiceImpl
implements StructureService {
    private final CachedPlanManager planManager;
    private final PlanDependencyManager planDependencyManager;
    private final ResultsSummaryManager resultsSummaryManager;

    @Inject
    public StructureServiceImpl(CachedPlanManager planManager, PlanDependencyManager planDependencyManager, ResultsSummaryManager resultsSummaryManager) {
        this.planManager = planManager;
        this.planDependencyManager = planDependencyManager;
        this.resultsSummaryManager = resultsSummaryManager;
    }

    @Override
    @NotNull
    public Structure buildChainPipeline(@NotNull String planKey, @NotNull DependencyGraphSettings settings) {
        HashSet<Entity> plans = new HashSet<Entity>();
        HashSet<Link> links = new HashSet<Link>();
        this.buildChainPipeline(planKey, plans, links, settings);
        return new Structure(planKey, plans, links);
    }

    @Override
    @NotNull
    public Structure buildChainResultPipeline(@NotNull PlanResultKey planResultKey, DependencyGraphSettings dependencyGraphSettings) {
        Structure chainStructure = this.buildChainPipeline(planResultKey.getPlanKey().getKey(), dependencyGraphSettings);
        return this.buildChainResultPipeline(planResultKey, chainStructure);
    }

    @Override
    public boolean hasDependency(ImmutableChain plan) {
        return !this.processDependencyLink((ImmutablePlan)plan, new HashSet<Link>()).isEmpty();
    }

    private Structure buildChainResultPipeline(PlanResultKey planResultKey, Structure chainStructure) {
        HashMap<String, String> planKeyToPlanResult = new HashMap<String, String>();
        chainStructure.getElements().forEach(plan -> planKeyToPlanResult.put(plan.getId(), plan.getId()));
        this.prepareFilterMap(planResultKey, new HashSet<Link>(chainStructure.getLinks()), planKeyToPlanResult);
        return this.getFilteredStructure(planResultKey, chainStructure, planKeyToPlanResult);
    }

    private void prepareFilterMap(PlanResultKey planResultKey, Set<Link> links, Map<String, String> planKeyToPlanResult) {
        planKeyToPlanResult.put(planResultKey.getPlanKey().getKey(), planResultKey.getKey());
        links.stream().filter(link -> link.getSourceId().equals(planResultKey.getPlanKey().getKey())).forEach(planLink -> {
            Range range = this.resultsSummaryManager.findBuildResultNumbersRange(PlanKeys.getPlanKey((String)planLink.getDestinationId()));
            String destinationBuildResultKey = null;
            for (int i = ((Integer)range.getMaximum()).intValue(); i >= (Integer)range.getMinimum(); --i) {
                TriggerReason reason;
                PlanResultKey destinationPlanResultKey = PlanKeys.getPlanResultKey((String)planLink.getDestinationId(), (int)i);
                ResultsSummary targetSummary = this.resultsSummaryManager.getResultsSummary(destinationPlanResultKey);
                if (targetSummary == null || !"com.atlassian.bamboo.plugin.system.triggerReason:DependencyTriggerReason".equals((reason = targetSummary.getTriggerReason()).getKey())) continue;
                DependencyTriggerReason childDependencyTriggerReason = (DependencyTriggerReason)reason;
                if (!planResultKey.getKey().equals(childDependencyTriggerReason.getTriggeringBuildResultKey())) continue;
                destinationBuildResultKey = destinationPlanResultKey.getKey();
                break;
            }
            if (destinationBuildResultKey != null) {
                planKeyToPlanResult.put(planLink.getDestinationId(), destinationBuildResultKey);
                this.prepareFilterMap(PlanKeys.getPlanResultKey(destinationBuildResultKey), links, planKeyToPlanResult);
            }
        });
    }

    @NotNull
    private Structure getFilteredStructure(PlanResultKey planResultKey, Structure chainStructure, Map<String, String> planKeyToPlanResult) {
        Set<Entity> filteredEntities = chainStructure.getElements().stream().map(element -> (String)planKeyToPlanResult.get(element.getId())).map(resultKey -> {
            try {
                return Entity.forBuild(PlanKeys.getPlanResultKey((String)resultKey));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return Entity.forPlan(resultKey);
            }
        }).collect(Collectors.toSet());
        Set<Link> filteredLinks = chainStructure.getLinks().stream().map(planLink -> new Link((String)planKeyToPlanResult.get(planLink.getSourceId()), (String)planKeyToPlanResult.get(planLink.getDestinationId()), planLink.getType())).collect(Collectors.toSet());
        return new Structure(planResultKey.toString(), filteredEntities, filteredLinks);
    }

    private void buildChainPipeline(@NotNull String planKey, @NotNull Set<Entity> plans, @NotNull Set<Link> links, @NotNull DependencyGraphSettings settings) {
        if (!plans.add(Entity.forPlan(planKey))) {
            return;
        }
        ImmutablePlan plan = this.planManager.getPlanByKey(PlanKeys.getPlanKey((String)planKey));
        if (plan == null) {
            return;
        }
        HashSet<String> nextLevelPlans = new HashSet<String>();
        if (settings.isShowChildren()) {
            nextLevelPlans.addAll(this.processDependencyLink(plan, links));
        }
        if (settings.isShowArtifactDownloads()) {
            nextLevelPlans.addAll(this.processArtifactDependency(plan, links));
        }
        for (String nextLevelPlan : nextLevelPlans) {
            this.buildChainPipeline(nextLevelPlan, plans, links, settings);
        }
    }

    private Set<String> processArtifactDependency(ImmutablePlan plan, Set<Link> links) {
        for (ImmutableTopLevelPlan topLevelPlan : this.planManager.getPlans()) {
            if (plan.getKey().equals(topLevelPlan.getKey())) continue;
            for (ImmutableJob job : topLevelPlan.getAllJobs()) {
                for (TaskDefinition taskDefinition : job.getTaskDefinitions()) {
                    if (!"com.atlassian.bamboo.plugins.bamboo-artifact-downloader-plugin:artifactdownloadertask".equals(taskDefinition.getPluginKey()) || !plan.getKey().equals(taskDefinition.getConfiguration().get("sourcePlanKey"))) continue;
                    links.add(new Link(plan.getKey(), topLevelPlan.getKey(), "artifact"));
                }
            }
        }
        return new HashSet<String>();
    }

    @NotNull
    private Set<String> processDependencyLink(ImmutablePlan plan, Set<Link> links) {
        Set childChainKeys = this.planDependencyManager.getChildChainKeys((PlanIdentifier)plan);
        links.addAll(childChainKeys.stream().map(childChainKey -> new Link(plan.getKey(), (String)childChainKey, "parent")).collect(Collectors.toList()));
        return childChainKeys;
    }
}

