/*
 * Decompiled with CFR 0.152.
 */
package com.atlassianlabs.bamboo.plugins.dependency.graph.rest;

import com.atlassian.bamboo.exception.WebValidationException;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.PlanResultKey;
import com.atlassian.bamboo.plan.cache.CachedPlanManager;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.rest.common.RestAuthenticationContext;
import com.atlassian.bamboo.rest.common.exception.NotAuthorizedException;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.resultsummary.ResultsSummaryManager;
import com.atlassian.bamboo.security.BambooPermissionManager;
import com.atlassian.bamboo.security.acegi.acls.BambooPermission;
import com.atlassian.bamboo.utils.BambooValidationUtils;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassianlabs.bamboo.plugins.dependency.graph.model.DependencyGraphSettings;
import com.atlassianlabs.bamboo.plugins.dependency.graph.model.PlanWithReferencedChildren;
import com.atlassianlabs.bamboo.plugins.dependency.graph.model.Structure;
import com.atlassianlabs.bamboo.plugins.dependency.graph.service.StructureService;
import com.sun.jersey.spi.resource.Singleton;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.acegisecurity.acls.Permission;
import org.jetbrains.annotations.Nullable;

@Path(value="structure")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Singleton
public class StructureResource {
    private final I18nResolver i18nResolver;
    private final CachedPlanManager planManager;
    private final ResultsSummaryManager resultsSummaryManager;
    private final StructureService structureService;
    private final BambooPermissionManager permissionManager;
    private final RestAuthenticationContext restAuthenticationContext;

    @Inject
    public StructureResource(I18nResolver i18nResolver, CachedPlanManager planManager, ResultsSummaryManager resultsSummaryManager, StructureService structureService, BambooPermissionManager permissionManager, RestAuthenticationContext restAuthenticationContext) {
        this.planManager = planManager;
        this.i18nResolver = i18nResolver;
        this.resultsSummaryManager = resultsSummaryManager;
        this.structureService = structureService;
        this.permissionManager = permissionManager;
        this.restAuthenticationContext = restAuthenticationContext;
    }

    @GET
    @Path(value="{planKey}")
    public Structure getPlanPipeline(@PathParam(value="planKey") String planKey, @QueryParam(value="children") Boolean showChildren, @QueryParam(value="artifacts") Boolean showArtifactDownloads) throws WebValidationException {
        PlanKey key = PlanKeys.getPlanKey((String)planKey);
        ImmutablePlan plan = this.planManager.getPlanByKey(key);
        BambooValidationUtils.validate((plan != null ? 1 : 0) != 0, () -> this.i18nResolver.getText("plan.not.found"));
        if (!this.permissionManager.hasPermission(this.restAuthenticationContext.getPrincipal().getName(), (Permission)BambooPermission.READ, (Object)plan)) {
            throw new NotAuthorizedException(this.i18nResolver.getText("plan.no.read.permission"));
        }
        return this.structureService.buildChainPipeline(plan.getKey(), new DependencyGraphSettings(showChildren, showArtifactDownloads));
    }

    @GET
    @Path(value="{planKey}/result/{buildNumber}")
    public Structure getBuildResultPipeline(@PathParam(value="planKey") String planKey, @PathParam(value="buildNumber") String buildNumber, @QueryParam(value="children") Boolean showChildren, @QueryParam(value="artifacts") Boolean showArtifactDownloads) throws WebValidationException {
        PlanResultKey planResultKey = PlanKeys.getPlanResultKey((String)planKey, (int)Integer.parseInt(buildNumber));
        ResultsSummary resultsSummary = this.resultsSummaryManager.getResultsSummary(planResultKey);
        BambooValidationUtils.validate((resultsSummary != null ? 1 : 0) != 0, () -> this.i18nResolver.getText("result.summary.not.found"));
        return this.structureService.buildChainResultPipeline(planResultKey, new DependencyGraphSettings(showChildren, showArtifactDownloads));
    }

    @GET
    @Path(value="largestPlans")
    public List<PlanWithReferencedChildren> getPlansWithReferencedChildren(@QueryParam(value="minimumChildren") @Nullable Integer minimumChildren) {
        List plans = this.planManager.getPlans();
        int minumumLimit = minimumChildren == null || minimumChildren < 1 ? 1 : minimumChildren;
        List<PlanWithReferencedChildren> result = plans.stream().map(plan -> {
            try {
                Structure structure = this.getPlanPipeline(plan.getKey(), null, null);
                return new PlanWithReferencedChildren(plan.getKey(), structure.getElements().size() - 1);
            }
            catch (WebValidationException e) {
                throw new RuntimeException(e);
            }
        }).filter(planWithReferencedChildren -> planWithReferencedChildren.getSize() >= minumumLimit).collect(Collectors.toList());
        result.sort((o1, o2) -> o2.getSize() - o1.getSize());
        return result;
    }
}

