/*
 * Decompiled with CFR 0.152.
 */
package com.atlassianlab.bamboo.plugins.failtrigger;

import com.atlassian.bamboo.collections.ActionParametersMap;
import com.atlassian.bamboo.plan.cache.CachedPlanManager;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.trigger.TriggerConfigurator;
import com.atlassian.bamboo.trigger.TriggerDefinition;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.sal.api.message.I18nResolver;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FailedPlanTriggerConfigurator
implements TriggerConfigurator {
    private static final String PLANS_ATTRIBUTE = "availablePlans";
    private I18nResolver i18nResolver;
    private CachedPlanManager planManager;

    public void populateContextForCreate(@NotNull Map<String, Object> context) {
        this.addPlansToContext(context);
    }

    private void populateContextForAllOperations(@NotNull Map<String, Object> context, @NotNull TriggerDefinition triggerDefinition) {
        this.addPlansToContext(context);
        context.put("failtrigger.plan", triggerDefinition.getConfiguration().get("failtrigger.plan"));
    }

    public void populateContextForEdit(@NotNull Map<String, Object> context, @NotNull TriggerDefinition triggerDefinition) {
        this.populateContextForAllOperations(context, triggerDefinition);
    }

    public void populateContextForView(@NotNull Map<String, Object> context, @NotNull TriggerDefinition triggerDefinition) {
        this.populateContextForAllOperations(context, triggerDefinition);
    }

    public void validate(@NotNull ActionParametersMap actionParametersMap, @NotNull ErrorCollection errorCollection) {
        String selectedPlan = actionParametersMap.getString("failtrigger.plan");
        if (StringUtils.isEmpty((String)selectedPlan)) {
            errorCollection.addError("failtrigger.plan", this.i18nResolver.getText("failtrigger.plan.error.required"));
        }
    }

    @NotNull
    public Map<String, String> generateTriggerConfigMap(@NotNull ActionParametersMap actionParametersMap, @Nullable TriggerDefinition previousTriggerDefinition) {
        HashMap config = Maps.newHashMap();
        String selectedPlan = actionParametersMap.getString("failtrigger.plan");
        config.put("failtrigger.plan", selectedPlan);
        return config;
    }

    @NotNull
    public TriggerConfigurator.RepositorySelectionMode getRepositorySelectionMode() {
        return TriggerConfigurator.RepositorySelectionMode.NONE;
    }

    private void addPlansToContext(@NotNull Map<String, Object> context) {
        List plans = this.planManager.getPlans();
        if (context.containsKey("chain")) {
            ImmutableChain currentPlan = (ImmutableChain)context.get("chain");
            Iterables.removeIf((Iterable)plans, input -> currentPlan.getPlanKey().equals((Object)input.getPlanKey()));
        }
        context.put(PLANS_ATTRIBUTE, plans);
    }

    public void setI18nResolver(I18nResolver i18nResolver) {
        this.i18nResolver = i18nResolver;
    }

    public void setPlanManager(CachedPlanManager planManager) {
        this.planManager = planManager;
    }
}

