/*
 * Decompiled with CFR 0.152.
 */
package com.atlassianlab.bamboo.plugins.failtrigger;

import com.atlassian.bamboo.build.BuildDetectionAction;
import com.atlassian.bamboo.build.BuildDetectionActionFactory;
import com.atlassian.bamboo.chains.ChainExecution;
import com.atlassian.bamboo.event.ChainCompletedEvent;
import com.atlassian.bamboo.plan.NonBlockingPlanExecutionService;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.cache.CachedPlanManager;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.plan.cache.ImmutableTopLevelPlan;
import com.atlassian.bamboo.trigger.TriggerDefinition;
import com.atlassian.bamboo.trigger.Triggerable;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.atlassian.event.api.EventListener;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class FailedPlanEventListener {
    private static final String PLUGIN_KEY = "com.atlassianlab.bamboo.plugins.bamboo-fail-trigger:afterFailedPlan";
    private final NonBlockingPlanExecutionService nonBlockingPlanExecutionService;
    private final CachedPlanManager planManager;
    private final BuildDetectionActionFactory buildDetectionActionFactory;
    private static final Logger log = Logger.getLogger(FailedPlanEventListener.class);

    public FailedPlanEventListener(NonBlockingPlanExecutionService nonBlockingPlanExecutionService, CachedPlanManager planManager, BuildDetectionActionFactory buildDetectionActionFactory) {
        this.nonBlockingPlanExecutionService = nonBlockingPlanExecutionService;
        this.planManager = planManager;
        this.buildDetectionActionFactory = buildDetectionActionFactory;
    }

    @EventListener
    public void onChainCompleted(ChainCompletedEvent event) {
        ChainExecution chainExecution = event.getChainExecution();
        ImmutableChain trigger = (ImmutableChain)this.planManager.getPlanByKey(chainExecution.getPlanResultKey().getPlanKey(), ImmutableChain.class);
        if (chainExecution.isFailed() && trigger != null) {
            log.debug((Object)("Found that " + trigger.getPlanKey() + " failed, looking if any plan depends on it"));
            BuildContext completedBuildContext = event.getBuildContext();
            Iterable<ImmutableTopLevelPlan> internalKey = this.findTriggerables(trigger.getPlanKey());
            log.debug((Object)("Found " + Iterables.size(internalKey) + " plans to be triggered"));
            for (ImmutableTopLevelPlan plan : internalKey) {
                BuildDetectionAction triggeringAction = this.buildDetectionActionFactory.createDependentBuildDetectionAction((ImmutableChain)plan, trigger, completedBuildContext);
                log.debug((Object)("Try to start " + plan.getPlanKey()));
                this.nonBlockingPlanExecutionService.tryToStart((Triggerable)plan, triggeringAction);
            }
        }
    }

    @NotNull
    private Iterable<ImmutableTopLevelPlan> findTriggerables(@NotNull PlanKey failedPlanKey) {
        return this.planManager.getPlans().stream().filter(this.shouldBeTriggered(failedPlanKey)).collect(Collectors.toList());
    }

    @NotNull
    private Predicate<ImmutableTopLevelPlan> shouldBeTriggered(@NotNull PlanKey failedPlanKey) {
        return input -> {
            List triggerDefinitions = input.getTriggerDefinitions();
            for (TriggerDefinition triggerDefinition : triggerDefinitions) {
                if (!triggerDefinition.isEnabled() || !triggerDefinition.getPluginKey().equals(PLUGIN_KEY) || !triggerDefinition.getConfiguration().containsKey("failtrigger.plan")) continue;
                String planKey = (String)triggerDefinition.getConfiguration().get("failtrigger.plan");
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Found " + input.getPlanKey() + " expects failure of " + planKey));
                }
                if (!failedPlanKey.toString().equals(planKey)) continue;
                return true;
            }
            return false;
        };
    }
}

