/*
 * Decompiled with CFR 0.152.
 */
package com.atlassianlabs.bamboo.plugins.agentsusage.rest;

import com.atlassian.bamboo.agent.AgentType;
import com.atlassian.bamboo.agent.elastic.server.ElasticImageConfiguration;
import com.atlassian.bamboo.buildqueue.ElasticAgentDefinition;
import com.atlassian.bamboo.buildqueue.manager.AgentManager;
import com.atlassian.bamboo.rest.common.exception.NotAuthorizedException;
import com.atlassian.bamboo.resultsummary.BuildResultsSummary;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.resultsummary.ResultsSummaryCriteria;
import com.atlassian.bamboo.resultsummary.ResultsSummaryCriteriaBuilder;
import com.atlassian.bamboo.resultsummary.ResultsSummaryManager;
import com.atlassian.bamboo.security.BambooPermissionManager;
import com.atlassian.bamboo.security.acegi.acls.BambooPermission;
import com.atlassian.bamboo.v2.build.agent.BuildAgent;
import com.atlassianlabs.bamboo.plugins.agentsusage.AgentStatistics;
import com.atlassianlabs.bamboo.plugins.agentsusage.BuildTime;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.acegisecurity.acls.Permission;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Path(value="agentsusage")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Singleton
public class AgentsUsageResource {
    private static final Logger log = Logger.getLogger(AgentsUsageResource.class);
    private static final String DATE_TIME_FORMAT = "yyyy_MM_dd_HH_mm";
    private final BambooPermissionManager bambooPermissionManager;
    private final ResultsSummaryManager resultsSummaryManager;
    private final AgentManager agentManager;
    private final LoadingCache<Long, String> agentCache = CacheBuilder.newBuilder().expireAfterWrite(5L, TimeUnit.MINUTES).softValues().build((CacheLoader)new CacheLoader<Long, String>(){

        @NotNull
        public String load(@NotNull Long buildAgentId) {
            BuildAgent agent = AgentsUsageResource.this.agentManager.getAgent(buildAgentId.longValue());
            if (agent == null) {
                return "Unknown " + buildAgentId;
            }
            if (agent.getType() == AgentType.ELASTIC) {
                ElasticImageConfiguration elasticImageConfiguration = ((ElasticAgentDefinition)agent.getDefinition()).getElasticImageConfiguration();
                return elasticImageConfiguration.getConfigurationName() + " (" + elasticImageConfiguration.getAmiId() + ")";
            }
            return agent.getName();
        }
    });

    @Inject
    public AgentsUsageResource(BambooPermissionManager bambooPermissionManager, ResultsSummaryManager resultsSummaryManager, AgentManager agentManager) {
        this.bambooPermissionManager = bambooPermissionManager;
        this.resultsSummaryManager = resultsSummaryManager;
        this.agentManager = agentManager;
    }

    @GET
    @NotNull
    public List<AgentStatistics> getData(@QueryParam(value="inputFilter") @Nullable String inputFilter, @QueryParam(value="from") @Nullable String fromDate, @QueryParam(value="to") @Nullable String toDate) {
        if (!this.hasAdministrationPermission()) {
            throw new NotAuthorizedException("Requires ADMIN permissions");
        }
        SimpleDateFormat format = new SimpleDateFormat(DATE_TIME_FORMAT);
        ResultsSummaryCriteriaBuilder resultsSummaryCriteriaBuilder = new ResultsSummaryCriteriaBuilder().setResultSummaryClass(BuildResultsSummary.class);
        this.setStartDate(fromDate, format, resultsSummaryCriteriaBuilder);
        this.setEndDate(toDate, format, resultsSummaryCriteriaBuilder);
        ResultsSummaryCriteria criteria = resultsSummaryCriteriaBuilder.buildCriteria();
        List resultSummaries = this.resultsSummaryManager.getResultSummaries(criteria);
        TreeMap<String, List> buildsByAgent = new TreeMap<String, List>();
        for (ResultsSummary resultSummary : resultSummaries) {
            String buildAgentName = Optional.ofNullable(resultSummary.getBuildAgentId()).map(key -> {
                try {
                    return (String)this.agentCache.get(key);
                }
                catch (ExecutionException e) {
                    return null;
                }
            }).orElse("Unknown");
            List buildTimes = buildsByAgent.computeIfAbsent(buildAgentName, k -> new ArrayList());
            buildTimes.add(new BuildTime(resultSummary.getPlanResultKey().toString(), resultSummary.getStatDate(), resultSummary.getBuildCompletedDate()));
        }
        ArrayList<AgentStatistics> result = new ArrayList<AgentStatistics>();
        for (Map.Entry agentEntry : buildsByAgent.entrySet()) {
            String agentName = (String)agentEntry.getKey();
            boolean includeAgent = true;
            if (StringUtils.isNotBlank((CharSequence)inputFilter) && !agentName.toLowerCase().contains(inputFilter.toLowerCase())) {
                includeAgent = false;
            }
            if (!includeAgent) continue;
            result.add(new AgentStatistics(agentName, (List)agentEntry.getValue()));
        }
        return result;
    }

    private void setEndDate(@QueryParam(value="to") @Nullable String toDate, SimpleDateFormat format, ResultsSummaryCriteriaBuilder resultsSummaryCriteriaBuilder) {
        if (StringUtils.isNotBlank((CharSequence)toDate)) {
            try {
                resultsSummaryCriteriaBuilder.setToDate(format.parse(toDate));
            }
            catch (ParseException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        } else {
            resultsSummaryCriteriaBuilder.setToDate(new Date());
        }
    }

    private void setStartDate(@QueryParam(value="from") @Nullable String fromDate, SimpleDateFormat format, ResultsSummaryCriteriaBuilder resultsSummaryCriteriaBuilder) {
        if (StringUtils.isNotBlank((CharSequence)fromDate)) {
            try {
                resultsSummaryCriteriaBuilder.setFromDate(format.parse(fromDate));
            }
            catch (ParseException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        } else {
            resultsSummaryCriteriaBuilder.setFromDate(DateUtils.addHours((Date)new Date(), (int)-48));
        }
    }

    private boolean hasAdministrationPermission() {
        return this.bambooPermissionManager.hasGlobalPermission((Permission)BambooPermission.ADMINISTRATION);
    }
}

