/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.troubleshooting.stp.salext.bundle;

import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.troubleshooting.api.healthcheck.HealthCheckStatus;
import com.atlassian.troubleshooting.api.healthcheck.SupportHealthCheckManager;
import com.atlassian.troubleshooting.api.supportzip.BundleCategory;
import com.atlassian.troubleshooting.api.supportzip.SupportZipBundle;
import com.atlassian.troubleshooting.api.supportzip.TempFileSupportZipArtifact;
import com.atlassian.troubleshooting.stp.salext.bundle.AbstractSupportZipBundle;
import com.atlassian.troubleshooting.stp.salext.bundle.BundleManifest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;

public class HealthcheckResultsBundle
extends AbstractSupportZipBundle {
    private final SupportHealthCheckManager supportHealthCheckManager;

    @Autowired
    public HealthcheckResultsBundle(SupportHealthCheckManager supportHealthCheckManager, I18nResolver i18nResolver) {
        super(i18nResolver, BundleManifest.HEALTHCHECKS, "stp.zip.include.healthchecks", "stp.zip.include.healthchecks.description");
        this.supportHealthCheckManager = supportHealthCheckManager;
    }

    @Override
    public BundleCategory getCategory() {
        return BundleCategory.OTHER;
    }

    @Override
    public Collection<SupportZipBundle.Artifact> getArtifacts() {
        ArrayList<SupportZipBundle.Artifact> tmpResults = new ArrayList<SupportZipBundle.Artifact>();
        String healthCheckResults = this.supportHealthCheckManager.runAllHealthChecks().stream().map(HealthCheckStatus::toString).collect(Collectors.joining("\n"));
        tmpResults.add(new TempFileSupportZipArtifact(healthCheckResults.isEmpty() ? "No healthcheck results." : healthCheckResults, "healthcheckResults.txt", ""));
        return tmpResults;
    }
}

