/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.troubleshooting.stp.properties.appenders;

import com.atlassian.crowd.embedded.api.CrowdDirectoryService;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.sal.spi.HostContextAccessor;
import com.atlassian.troubleshooting.spi.RootLevelSupportDataAppender;
import com.atlassian.troubleshooting.spi.SupportDataBuilder;
import com.atlassian.troubleshooting.stp.properties.appenders.CrowdDirectorySupportData;
import io.atlassian.util.concurrent.Lazy;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BambooCrowdDirectorySupportData
extends RootLevelSupportDataAppender {
    private static final Logger LOG = LoggerFactory.getLogger(BambooCrowdDirectorySupportData.class);
    private final HostContextAccessor hostContextAccessor;
    private final TransactionTemplate transactionTemplate;
    private final Supplier<Optional<CrowdDirectorySupportData>> crowdDirectorySupportSupplier;

    public BambooCrowdDirectorySupportData(HostContextAccessor hostContextAccessor, TransactionTemplate transactionTemplate) {
        this.hostContextAccessor = Objects.requireNonNull(hostContextAccessor);
        this.transactionTemplate = Objects.requireNonNull(transactionTemplate);
        this.crowdDirectorySupportSupplier = Lazy.resettable(this::loadCrowdDirectoryServiceIfExists);
    }

    @Override
    protected void addSupportData(SupportDataBuilder builder) {
        this.crowdDirectorySupportSupplier.get().ifPresent(supportData -> this.transactionTemplate.execute(() -> {
            supportData.addSupportData(builder);
            return null;
        }));
    }

    private Optional<CrowdDirectorySupportData> loadCrowdDirectoryServiceIfExists() {
        Optional<CrowdDirectorySupportData> maybeCrowdDirectorySupportData = this.hostContextAccessor.getComponentsOfType(CrowdDirectoryService.class).values().stream().findFirst().map(CrowdDirectorySupportData::new);
        if (!maybeCrowdDirectorySupportData.isPresent()) {
            LOG.debug("No beans of type {} found in context. Support zip will not contain info about user directories.", CrowdDirectoryService.class);
        }
        return maybeCrowdDirectorySupportData;
    }
}

