/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.troubleshooting.bamboo.spring;

import com.atlassian.plugin.servlet.ServletContextFactory;
import com.atlassian.plugins.osgi.javaconfig.ExportOptions;
import com.atlassian.plugins.osgi.javaconfig.OsgiServices;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.troubleshooting.api.supportzip.BundleCategory;
import com.atlassian.troubleshooting.api.supportzip.SupportZipBundle;
import com.atlassian.troubleshooting.bamboo.BambooApplicationInfo;
import com.atlassian.troubleshooting.spring.CommonSupportZipBundleBeans;
import com.atlassian.troubleshooting.spring.TomcatLogsSupportZipBundleBeans;
import com.atlassian.troubleshooting.stp.salext.SupportApplicationInfo;
import com.atlassian.troubleshooting.stp.salext.bundle.BundleManifest;
import com.atlassian.troubleshooting.stp.salext.bundle.FileSetsBundle;
import com.atlassian.troubleshooting.stp.salext.bundle.fileset.ExactFileSet;
import com.atlassian.troubleshooting.stp.salext.bundle.fileset.RegexFileSet;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.osgi.framework.ServiceRegistration;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@Import(value={TomcatLogsSupportZipBundleBeans.class})
public class BambooSupportZipBundleBeans {
    private static final String ZIP_INCLUDE_BAMBOO_LOG_DESCRIPTION = "stp.zip.include.bamboo.log.description";
    private static final String ZIP_INCLUDE_BAMBOO_LOG = "stp.zip.include.bamboo.log";
    private static final String ZIP_INCLUDE_BAMBOO_CFG_DESCRIPTION = "stp.zip.include.bamboo.cfg.description";
    private static final String ZIP_INCLUDE_BAMBOO_CFG = "stp.zip.include.bamboo.cfg";
    private static final String ZIP_INCLUDE_AUTH_CFG_BAMBOO_DESCRIPTION = "stp.zip.include.auth.cfg.bamboo.description";
    private static final Pattern BAMBOO_LOG_FILE_PATTERN = Pattern.compile("^.*\\.log.*");
    @Autowired
    protected SupportApplicationInfo info;
    @Autowired
    protected I18nResolver i18nResolver;

    @Bean
    public FactoryBean<ServiceRegistration> exportBambooConfigBundle() {
        String binDir = CommonSupportZipBundleBeans.findTomcatFileOrDirectory("bin");
        ArrayList<String> bundledFilePaths = new ArrayList<String>();
        bundledFilePaths.add(BambooApplicationInfo.SystemDirectoryWrapper.getApplicationHomePath() + "/bamboo.cfg.xml");
        bundledFilePaths.add(this.getBambooMailPath() + "/bamboo-mail.cfg.xml");
        bundledFilePaths.add(BambooApplicationInfo.SystemDirectoryWrapper.getConfigDirectoryPath() + "/administration.xml");
        this.addPathIfFileExists(bundledFilePaths, BambooApplicationInfo.SystemDirectoryWrapper.getApplicationHomePath() + "/cluster-node.properties");
        this.addPathIfFileExists(bundledFilePaths, BambooApplicationInfo.SystemDirectoryWrapper.getConfigDirectoryPath() + "/bamboo-shared.cfg.xml");
        if (binDir != null && new File(binDir).exists()) {
            String[] filenames;
            for (String filename : filenames = new String[]{"setenv", "setclasspath", "start-bamboo", "stop-bamboo", "startup", "shutdown"}) {
                bundledFilePaths.add(binDir + File.pathSeparator + filename + ".sh");
                bundledFilePaths.add(binDir + File.pathSeparator + filename + ".bat");
            }
        }
        return OsgiServices.exportOsgiService(FileSetsBundle.builder(BundleManifest.APPLICATION_CONFIG, ZIP_INCLUDE_BAMBOO_CFG, ZIP_INCLUDE_BAMBOO_CFG_DESCRIPTION, BundleCategory.CONFIG, this.i18nResolver).fileSet(ExactFileSet.ofPaths(bundledFilePaths)).build(), ExportOptions.as(SupportZipBundle.class, new Class[0]));
    }

    @Bean
    public FactoryBean<ServiceRegistration> exportTomcatConfigBundle() {
        String confDir = CommonSupportZipBundleBeans.findTomcatFileOrDirectory("conf");
        if (confDir != null && new File(confDir).exists()) {
            return OsgiServices.exportOsgiService(FileSetsBundle.builder(BundleManifest.TOMCAT_CONFIG, "stp.zip.include.tomcat.conf", "stp.zip.include.tomcat.conf.description", BundleCategory.CONFIG, this.i18nResolver).fileSet(RegexFileSet.fromDirectoryPath(confDir, Pattern.compile("^.*\\.(xml|properties|policy)$"))).build(), ExportOptions.as(SupportZipBundle.class, new Class[0]));
        }
        return null;
    }

    @Bean
    public FactoryBean<ServiceRegistration> exportAuthConfigBundle(ServletContextFactory servletContextFactory) {
        String webInfDir = servletContextFactory.getServletContext().getRealPath("WEB-INF");
        String webInfClassesDir = webInfDir + "/classes";
        return OsgiServices.exportOsgiService(FileSetsBundle.builder(BundleManifest.AUTH_CONFIG, "stp.zip.include.auth.cfg", ZIP_INCLUDE_AUTH_CFG_BAMBOO_DESCRIPTION, BundleCategory.CONFIG, this.i18nResolver).fileSet(ExactFileSet.ofPaths(BambooApplicationInfo.SystemDirectoryWrapper.getConfigDirectoryPath() + "/atlassian-user.xml", BambooApplicationInfo.SystemDirectoryWrapper.getConfigDirectoryPath() + "/atlassian-user-custom.xml", BambooApplicationInfo.SystemDirectoryWrapper.getConfigDirectoryPath() + "/crowd.properties", webInfClassesDir + "/seraph-config.xml")).build(), ExportOptions.as(SupportZipBundle.class, new Class[0]));
    }

    @Bean
    public FactoryBean<ServiceRegistration> exportApplicationLogsBundle() {
        return OsgiServices.exportOsgiService(FileSetsBundle.builder(BundleManifest.APPLICATION_LOGS, ZIP_INCLUDE_BAMBOO_LOG, ZIP_INCLUDE_BAMBOO_LOG_DESCRIPTION, BundleCategory.LOGS, this.i18nResolver).fileSet(RegexFileSet.fromDirectoryPath(BambooApplicationInfo.SystemDirectoryWrapper.getLogDirectoryPath(), BAMBOO_LOG_FILE_PATTERN)).fileSet(RegexFileSet.fromDirectoryPath(BambooApplicationInfo.SystemDirectoryWrapper.getDCLogDirectoryPath(), BAMBOO_LOG_FILE_PATTERN)).build(), ExportOptions.as(SupportZipBundle.class, new Class[0]));
    }

    private String getBambooMailPath() {
        if (Integer.parseInt(this.info.getApplicationBuildNumber()) < 70302) {
            return BambooApplicationInfo.SystemDirectoryWrapper.getApplicationHomePath();
        }
        return BambooApplicationInfo.SystemDirectoryWrapper.getConfigDirectoryPath();
    }

    private void addPathIfFileExists(List<String> bundledFilePath, String path) {
        File file = new File(path);
        if (file.exists()) {
            bundledFilePath.add(path);
        }
    }
}

