/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.troubleshooting.bamboo.info;

import com.atlassian.troubleshooting.bamboo.info.GitEnvironmentProvider;
import com.atlassian.troubleshooting.spi.RootLevelSupportDataAppender;
import com.atlassian.troubleshooting.spi.SupportDataBuilder;
import java.util.Objects;
import javax.annotation.Nonnull;

public class GitCapabilityAppender
extends RootLevelSupportDataAppender {
    private static final String GIT = "git";
    private static final String GIT_CAPABILITY = "capability";
    private static final String GIT_PATH = "path";
    private static final String GIT_VERSION = "version";
    private static final String GIT_IS_EXECUTABLE = "is-executable";
    private final GitEnvironmentProvider gitEnvironmentProvider;

    public GitCapabilityAppender(GitEnvironmentProvider gitEnvironmentProvider) {
        this.gitEnvironmentProvider = Objects.requireNonNull(gitEnvironmentProvider);
    }

    @Override
    protected void addSupportData(@Nonnull SupportDataBuilder supportDataBuilder) {
        Objects.requireNonNull(supportDataBuilder);
        SupportDataBuilder builder = supportDataBuilder.addCategory(GIT);
        builder.addValue(GIT_CAPABILITY, this.gitEnvironmentProvider.getCapabilityType());
        builder.addValue(GIT_PATH, this.gitEnvironmentProvider.getGitPath().orElse("N/A"));
        builder.addValue(GIT_VERSION, this.gitEnvironmentProvider.getGitVersion().orElse("N/A"));
        builder.addValue(GIT_IS_EXECUTABLE, String.valueOf(this.gitEnvironmentProvider.isGitExecutable()));
    }
}

