/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.troubleshooting.bamboo;

import com.atlassian.troubleshooting.stp.salext.FileSanitizerPatternManager;
import java.util.regex.Pattern;
import java.util.stream.Stream;

public class BambooFileSanitizerPatternManager
extends FileSanitizerPatternManager {
    private static final String BAMBOO_CFG_XML = "bamboo.cfg.xml";
    private static final String BAMBOOMAIL_CFG_XML = "bamboo-mail.cfg.xml";

    @Override
    protected void initializeProductSpecificSanitizations() {
        this.addSanitizerPattern(BAMBOO_CFG_XML, Pattern.compile("(?:.*<property name=\"hibernate\\.connection\\.username\">)(.*)(?:</property>.*)"), Pattern.compile("(?:.*<property name=\"hibernate\\.connection\\.password\">)(.*)(?:</property>.*)"), Pattern.compile("(?:.*<property name=\"license\\.string\">)(.*)(?:</property>.*)"));
        this.addSanitizerPattern(BAMBOOMAIL_CFG_XML, Pattern.compile("(?:.*<password>)(.*)(?:</password>.*)"), Pattern.compile("(?:.*<username>)(.*)(?:</username>.*)"));
    }

    @Override
    protected Stream<String> productSpecificShAndBatFiles() {
        return Stream.of("start-bamboo", "stop-bamboo");
    }
}

