/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.troubleshooting.bamboo;

import com.atlassian.bamboo.configuration.SystemInfo;
import com.atlassian.bamboo.configuration.SystemStatisticsBean;
import com.atlassian.bamboo.fileserver.SystemDirectory;
import com.atlassian.bamboo.index.IndexerManager;
import com.atlassian.bamboo.license.BambooLicenseManager;
import com.atlassian.bamboo.setup.BootstrapManager;
import com.atlassian.bamboo.storage.StorageLocationService;
import com.atlassian.config.util.BootstrapUtils;
import com.atlassian.extras.api.ProductLicense;
import com.atlassian.extras.api.bamboo.BambooLicense;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.servlet.ServletContextFactory;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sisyphus.SisyphusPatternSource;
import com.atlassian.spring.container.LazyComponentReference;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.atlassian.troubleshooting.spi.SupportDataDetail;
import com.atlassian.troubleshooting.stp.hercules.HerculesRegexResource;
import com.atlassian.troubleshooting.stp.hercules.ScanItem;
import com.atlassian.troubleshooting.stp.hercules.regex.cacheables.SavedExternalResourceService;
import com.atlassian.troubleshooting.stp.properties.PropertyStore;
import com.atlassian.troubleshooting.stp.properties.SupportDataAppenderManager;
import com.atlassian.troubleshooting.stp.properties.SupportDataXmlKeyResolver;
import com.atlassian.troubleshooting.stp.request.FileSanitizer;
import com.atlassian.troubleshooting.stp.salext.AbstractSupportApplicationInfo;
import com.atlassian.troubleshooting.stp.salext.ApplicationType;
import com.atlassian.troubleshooting.stp.salext.FileSanitizerPatternManager;
import com.atlassian.troubleshooting.stp.salext.bundle.SupportZipBundleAccessor;
import com.atlassian.troubleshooting.stp.salext.license.ApplicationLicenseInfo;
import com.atlassian.troubleshooting.stp.salext.license.ProductLicenseInfo;
import com.atlassian.troubleshooting.stp.salext.mail.MailUtility;
import com.atlassian.troubleshooting.stp.salext.output.XmlSupportDataFormatter;
import jakarta.servlet.http.HttpServletRequest;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;

public class BambooApplicationInfo
extends AbstractSupportApplicationInfo {
    private static final String LICENSE_BAMBOO_MAX_PLANS = "stp.properties.license.bamboo.max.plans";
    private static final String LICENSE_BAMBOO_MAX_USERS = "stp.properties.license.bamboo.max.users";
    private static final String LICENSE_BAMBOO_MAX_REMOTE = "stp.properties.license.bamboo.max.remote";
    private static final String LICENSE_BAMBOO_MAX_LOCAL = "stp.properties.license.bamboo.max.local";
    private static final String BAMBOO_USAGE_RESULTS = "stp.properties.bamboo.results.count";
    private static final String BAMBOO_USAGE_PLANS = "stp.properties.bamboo.plans.count";
    private static final String BAMBOO_INDEX_TIME = "stp.properties.bamboo.index.time";
    private static final String BAMBOO_BUILD_DATA_DIRECTORY = "stp.properties.bamboo.build.data.directory";
    private static final String BAMBOO_BASE_BUILD_WORK_DIRECTORY = "stp.properties.bamboo.base.build.work.directory";
    private static final String BAMBOO_ARTIFACT_ROOT = "stp.properties.bamboo.artifact.root";
    private static final String BAMBOO_CONFIG_PATH = "stp.properties.bamboo.config.path";
    private static final String BAMBOO_BUILD_WORK_DIRECTORY = "stp.properties.bamboo.build.work.directory";
    private static final String BAMBOO_BUILD_PATH = "stp.properties.bamboo.build.path";
    private static final String BAMBOO_ARTIFACTS_DIRECTORY = "stp.properties.bamboo.artifacts.directory";
    private static final String BAMBOO_APP_SERVER_CONTAINER = "stp.properties.bamboo.app.server.container";
    private static final String BAMBOO_HOME = "stp.properties.bamboo.home";
    private final LazyComponentReference<SystemInfo> systemInfoReference = new LazyComponentReference("systemInfo");
    private final LazyComponentReference<SystemStatisticsBean> systemStatisticsBean = new LazyComponentReference("systemStatisticsBean");
    private final LazyComponentReference<BambooLicenseManager> licenseManager = new LazyComponentReference("bambooLicenseManager");
    private final StorageLocationService storageLocationService;
    private final IndexerManager indexerManager;
    private final ServletContextFactory servletContextFactory;

    @Autowired
    public BambooApplicationInfo(ApplicationProperties applicationProperties, I18nResolver i18nResolver, TemplateRenderer renderer, ServletContextFactory servletContextFactory, SupportDataAppenderManager supportDataAppenderManager, SupportDataXmlKeyResolver supportDataXmlKeyResolver, XmlSupportDataFormatter xmlSupportDataFormatter, PluginAccessor pluginAccessor, SavedExternalResourceService savedExternalResourceService, MailUtility mailUtility, FileSanitizerPatternManager fileSanitizerPatternManager, StorageLocationService storageLocationService, IndexerManager indexerManager, SupportZipBundleAccessor supportZipBundleAccessor) {
        super(applicationProperties, i18nResolver, renderer, supportDataAppenderManager, supportDataXmlKeyResolver, xmlSupportDataFormatter, pluginAccessor, mailUtility, savedExternalResourceService, fileSanitizerPatternManager, supportZipBundleAccessor);
        this.storageLocationService = Objects.requireNonNull(storageLocationService);
        this.indexerManager = Objects.requireNonNull(indexerManager);
        this.servletContextFactory = servletContextFactory;
    }

    @Override
    public List<ScanItem> getApplicationLogFilePaths() {
        String logFilePath = SystemDirectoryWrapper.getLogFilePath();
        File logFile = new File(logFilePath);
        if (logFile.exists()) {
            return Collections.singletonList(ScanItem.createDefaultItem(logFile.getAbsoluteFile().toString()));
        }
        return Collections.emptyList();
    }

    @Override
    public SisyphusPatternSource getPatternSource() {
        return this.getSourceFromCacheable(HerculesRegexResource.BAMBOO_HERCULES_REGEX);
    }

    @Override
    public String getCreateSupportRequestEmail() {
        return "bamboo-support-system@atlassian.com";
    }

    @Override
    public String getMailQueueURL(HttpServletRequest request) {
        return null;
    }

    @Override
    public boolean isMailExceptionAvailable() {
        return true;
    }

    @Override
    public String getMailServerConfigurationURL(HttpServletRequest request) {
        return this.getBaseURL(request) + "/admin/viewMailServer.action";
    }

    @Override
    public FileSanitizer getFileSanitizer() {
        return new FileSanitizer(this.getFileSanitizerPatternManager(), EXECUTABLE_EXTENSIONS, this.getTempDirectory());
    }

    @Override
    public String getApplicationSEN() {
        BambooLicense license = ((BambooLicenseManager)this.licenseManager.get()).getLicense();
        return license.getSupportEntitlementNumber();
    }

    @Override
    public String getApplicationServerID() {
        BambooLicense license = ((BambooLicenseManager)this.licenseManager.get()).getLicense();
        return license.getServerId();
    }

    @Override
    protected PropertyStore internalLoadProperties(SupportDataDetail detail) {
        PropertyStore store = super.internalLoadProperties(detail);
        PropertyStore sysInfo = store.addCategory("stp.properties.system.info");
        SystemInfo systemInfo = (SystemInfo)this.systemInfoReference.get();
        sysInfo.setValue(BAMBOO_HOME, systemInfo.getApplicationHome());
        sysInfo.setValue(BAMBOO_APP_SERVER_CONTAINER, this.servletContextFactory.getServletContext().getServerInfo());
        sysInfo.setValue(BAMBOO_ARTIFACTS_DIRECTORY, systemInfo.getArtifactsDirectory());
        sysInfo.setValue(BAMBOO_BUILD_PATH, systemInfo.getBuildPath());
        sysInfo.setValue(BAMBOO_BUILD_WORK_DIRECTORY, systemInfo.getBuildWorkingDirectory());
        sysInfo.setValue(BAMBOO_CONFIG_PATH, systemInfo.getConfigPath());
        sysInfo.setValue("stp.properties.current.directory", systemInfo.getCurrentDirectory());
        sysInfo.setValue("stp.properties.free.disk.space", systemInfo.getFreeDiskSpace());
        sysInfo.setValue("stp.properties.host.name", systemInfo.getHostName());
        sysInfo.setValue("stp.properties.index.size", systemInfo.getIndexSize());
        sysInfo.setValue("stp.properties.ip.address", systemInfo.getIpAddress());
        sysInfo.setValue("stp.properties.os", systemInfo.getOperatingSystem());
        sysInfo.setValue("stp.properties.os.architecture", systemInfo.getOperatingSystemArchitecture());
        sysInfo.setValue("stp.properties.system.date", systemInfo.getSystemDate());
        sysInfo.setValue("stp.properties.system.encoding", systemInfo.getSystemEncoding());
        sysInfo.setValue("stp.properties.system.time", systemInfo.getSystemTime());
        sysInfo.setValue("stp.properties.system.temp.directory", systemInfo.getTempDir());
        sysInfo.setValue("stp.properties.application.uptime", systemInfo.getUptime());
        sysInfo.setValue("stp.properties.user.home", systemInfo.getUserHome());
        sysInfo.setValue("stp.properties.user.locale", systemInfo.getUserLocale());
        sysInfo.setValue("stp.properties.user.name", systemInfo.getUserName());
        sysInfo.setValue("stp.properties.user.timezone", systemInfo.getUserTimezone());
        sysInfo.setValue("stp.properties.system.available.processors", String.valueOf(systemInfo.getAvailableProcessors()));
        sysInfo.setValue("stp.properties.memory.total", String.valueOf(systemInfo.getTotalMemory()));
        sysInfo.setValue("stp.properties.memory.used", String.valueOf(systemInfo.getUsedMemory()));
        PropertyStore sysProps = store.addCategory("stp.properties.system.info");
        Properties properties = System.getProperties();
        for (Object key : properties.keySet()) {
            sysProps.setValue((String)key, properties.getProperty((String)key));
        }
        PropertyStore pathInfo = store.addCategory("stp.properties.path.info");
        pathInfo.setValue(BAMBOO_HOME, SystemDirectoryWrapper.getApplicationHomePath());
        pathInfo.setValue(BAMBOO_ARTIFACT_ROOT, SystemDirectoryWrapper.getArtifactStorageRootPath());
        pathInfo.setValue(BAMBOO_BASE_BUILD_WORK_DIRECTORY, SystemDirectoryWrapper.getBaseBuildWorkingDirectoryPath());
        pathInfo.setValue(BAMBOO_BUILD_DATA_DIRECTORY, this.storageLocationService.getRootBuildDataDirectory().getAbsolutePath());
        pathInfo.setValue("stp.properties.cache.directory", SystemDirectoryWrapper.getCacheDirectoryPath());
        pathInfo.setValue("stp.properties.config.directory", SystemDirectoryWrapper.getConfigDirectoryPath());
        pathInfo.setValue("stp.properties.log.directory", SystemDirectoryWrapper.getLogDirectoryPath());
        pathInfo.setValue("stp.properties.plugin.cache.directory", SystemDirectoryWrapper.getPluginCacheDirectoryPath());
        pathInfo.setValue("stp.properties.plugin.directory", SystemDirectoryWrapper.getPluginDirectoryPath());
        PropertyStore statsInfo = store.addCategory("stp.properties.statistics");
        SystemStatisticsBean statisticsBean = (SystemStatisticsBean)this.systemStatisticsBean.get();
        statsInfo.setValue(BAMBOO_INDEX_TIME, String.valueOf(this.indexerManager.getEstimatedReindexTime()));
        statsInfo.setValue(BAMBOO_USAGE_PLANS, String.valueOf(statisticsBean.getNumberOfPlans()));
        statsInfo.setValue(BAMBOO_USAGE_RESULTS, String.valueOf(statisticsBean.getNumberOfResults()));
        BambooLicense license = ((BambooLicenseManager)this.licenseManager.get()).getLicense();
        PropertyStore licenseInfo = store.addCategory("stp.properties.license");
        licenseInfo.setValue("stp.properties.license.purchased", license.getPurchaseDate().toString());
        licenseInfo.setValue("stp.properties.license.description", license.getDescription());
        licenseInfo.setValue("stp.properties.license.sen", license.getSupportEntitlementNumber());
        licenseInfo.setValue("stp.properties.license.server.id", license.getServerId());
        licenseInfo.setValue("stp.properties.license.edition", license.getLicenseEdition().name());
        licenseInfo.setValue("stp.properties.license.type", license.getLicenseType().name());
        licenseInfo.setValue("stp.properties.license.expires", license.getExpiryDate() != null ? license.getExpiryDate().toString() : "stp.properties.license.expires.none");
        licenseInfo.setValue(LICENSE_BAMBOO_MAX_LOCAL, String.valueOf(license.getMaximumNumberOfLocalAgents()));
        licenseInfo.setValue(LICENSE_BAMBOO_MAX_REMOTE, String.valueOf(license.getMaximumNumberOfRemoteAgents()));
        licenseInfo.setValue(LICENSE_BAMBOO_MAX_USERS, String.valueOf(license.getMaximumNumberOfUsers()));
        licenseInfo.setValue(LICENSE_BAMBOO_MAX_PLANS, String.valueOf(license.getMaximumNumberOfPlans()));
        return store;
    }

    @Override
    public String getApplicationLogDir() {
        return SystemDirectoryWrapper.getLogDirectoryPath();
    }

    @Override
    public ApplicationLicenseInfo getLicenseInfo() {
        BambooLicense license = ((BambooLicenseManager)this.licenseManager.get()).getLicense();
        return new ProductLicenseInfo((ProductLicense)license);
    }

    @Override
    public String getAdminLicenseUrl() {
        return "/admin/updateLicense.action";
    }

    @Override
    @NotNull
    public File getExportDirectory() {
        return new File(SystemDirectory.getSharedHome(), "export");
    }

    @Override
    public ApplicationType getApplicationType() {
        return ApplicationType.BAMBOO;
    }

    @Override
    public Pattern getApplicationRestartPattern() {
        return Pattern.compile("(Starting\\sbamboo)|(Bamboo\\sis\\sstarting\\sup)");
    }

    public static class SystemDirectoryWrapper {
        public static String getLogDirectoryPath() {
            return String.valueOf(SystemDirectory.getApplicationHome()) + "/logs";
        }

        public static String getDCLogDirectoryPath() {
            return String.valueOf(SystemDirectory.getApplicationHome()) + "/log";
        }

        public static String getCacheDirectoryPath() {
            return SystemDirectory.getCacheDirectory().getAbsolutePath();
        }

        public static String getConfigDirectoryPath() {
            return SystemDirectory.getConfigDirectory().getAbsolutePath();
        }

        public static String getPluginCacheDirectoryPath() {
            return SystemDirectory.getPluginCacheDirectory().getAbsolutePath();
        }

        public static String getPluginDirectoryPath() {
            return SystemDirectory.getPluginDirectory().getAbsolutePath();
        }

        public static String getBaseBuildWorkingDirectoryPath() {
            return SystemDirectory.getBaseBuildWorkingDirectory().getAbsolutePath();
        }

        public static String getApplicationHomePath() {
            return SystemDirectory.getApplicationHome().getAbsolutePath();
        }

        public static String getArtifactStorageRootPath() {
            BootstrapManager bootstrapManager = (BootstrapManager)BootstrapUtils.getBootstrapManager();
            return bootstrapManager.getArtifactsDirectory();
        }

        public static String getLogFilePath() {
            return SystemDirectory.getApplicationHome().getAbsolutePath() + "/logs/atlassian-bamboo.log";
        }
    }
}

