/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.troubleshooting.stp.salext.bundle;

import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.troubleshooting.api.supportzip.BundleCategory;
import com.atlassian.troubleshooting.api.supportzip.SupportZipBundle;
import com.atlassian.troubleshooting.api.supportzip.TempFileSupportZipArtifact;
import com.atlassian.troubleshooting.stp.salext.bundle.AbstractSupportZipBundle;
import com.atlassian.troubleshooting.stp.salext.bundle.BundleManifest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public abstract class CustomisationFileBundle
extends AbstractSupportZipBundle {
    private static final String LAYOUTS = "layouts";

    public CustomisationFileBundle(BundleManifest bundle, String title, String description, I18nResolver i18nResolver) {
        super(i18nResolver, bundle, title, description);
    }

    @Override
    public Collection<SupportZipBundle.Artifact> getArtifacts() {
        ArrayList<SupportZipBundle.Artifact> customisedFiles = new ArrayList<SupportZipBundle.Artifact>();
        customisedFiles.addAll(this.getCustomLayouts());
        customisedFiles.addAll(this.getCustomHtmlArtifacts());
        customisedFiles.addAll(this.getCustomStylesheetArtifacts());
        return customisedFiles;
    }

    protected abstract TreeMap<String, String> getCustomDecorators();

    protected abstract HashMap<String, String> getCustomHtml();

    protected abstract HashMap<String, String> getCustomStylesheet();

    private List<SupportZipBundle.Artifact> getCustomLayouts() {
        TreeMap<String, String> customDecorators = this.getCustomDecorators();
        ArrayList<SupportZipBundle.Artifact> tmpCustomLayouts = new ArrayList<SupportZipBundle.Artifact>();
        StringBuilder customisationsString = new StringBuilder();
        if (customDecorators.isEmpty()) {
            customisationsString.append("No custom layouts");
        }
        for (Map.Entry<String, String> decorator : customDecorators.entrySet()) {
            customisationsString.append(decorator.getKey()).append("\n");
            tmpCustomLayouts.add(new TempFileSupportZipArtifact(decorator.getValue(), decorator.getKey(), LAYOUTS));
        }
        tmpCustomLayouts.add(new TempFileSupportZipArtifact(customisationsString.toString(), "customLayouts.txt", LAYOUTS));
        return tmpCustomLayouts;
    }

    private List<SupportZipBundle.Artifact> getCustomHtmlArtifacts() {
        HashMap<String, String> customHtml = this.getCustomHtml();
        ArrayList<SupportZipBundle.Artifact> tmpCustomHtml = new ArrayList<SupportZipBundle.Artifact>();
        StringBuilder htmlString = new StringBuilder();
        if (customHtml.isEmpty()) {
            htmlString.append("No custom HTML");
        }
        for (Map.Entry<String, String> htmlObj : customHtml.entrySet()) {
            htmlString.append(htmlObj.getKey()).append("\n").append(htmlObj.getValue()).append("\n\n");
        }
        tmpCustomHtml.add(new TempFileSupportZipArtifact(htmlString.toString(), "customHtml.txt", ""));
        return tmpCustomHtml;
    }

    private List<SupportZipBundle.Artifact> getCustomStylesheetArtifacts() {
        HashMap<String, String> customStylesheet = this.getCustomStylesheet();
        ArrayList<SupportZipBundle.Artifact> tmpCustomStylesheet = new ArrayList<SupportZipBundle.Artifact>();
        StringBuilder stylesheetString = new StringBuilder();
        if (customStylesheet.isEmpty()) {
            stylesheetString.append("No custom stylesheet");
        }
        for (Map.Entry<String, String> stylesheetObj : customStylesheet.entrySet()) {
            stylesheetString.append(stylesheetObj.getKey()).append("\n").append(stylesheetObj.getValue()).append("\n\n");
        }
        tmpCustomStylesheet.add(new TempFileSupportZipArtifact(stylesheetString.toString(), "customStylesheet.txt", ""));
        return tmpCustomStylesheet;
    }

    @Override
    public BundleCategory getCategory() {
        return BundleCategory.OTHER;
    }
}

