/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.troubleshooting.instance;

import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.troubleshooting.api.healthcheck.Application;
import com.atlassian.troubleshooting.instance.CloudInstanceEvent;
import com.atlassian.troubleshooting.instance.CloudInstanceMetadataStrategy;
import com.atlassian.troubleshooting.instance.CloudProviderType;
import com.atlassian.troubleshooting.instance.MetadataServiceStrategy;
import java.io.IOException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class CloudInstanceParser {
    private static final Logger LOG = LoggerFactory.getLogger(CloudInstanceParser.class);
    private final ApplicationProperties properties;

    @Autowired
    public CloudInstanceParser(ApplicationProperties properties) {
        this.properties = properties;
    }

    public CloudInstanceEvent getAnalyticsEvent() {
        return new CloudInstanceEvent(Application.byAppDisplayName(this.properties.getDisplayName()), this.getCloudProviderType());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CloudProviderType getCloudProviderType() {
        LOG.debug("Getting cloud provider type....");
        RequestConfig defaultRequestConfig = RequestConfig.custom().setConnectTimeout(300).setSocketTimeout(3000).build();
        try (CloseableHttpClient httpClient = HttpClientBuilder.create().setDefaultRequestConfig(defaultRequestConfig).build();){
            CloudInstanceMetadataStrategy[] strategies;
            CloudInstanceMetadataStrategy[] cloudInstanceMetadataStrategyArray = strategies = new CloudInstanceMetadataStrategy[]{new MetadataServiceStrategy(CloudProviderType.AWS), new MetadataServiceStrategy(CloudProviderType.GCP), new MetadataServiceStrategy(CloudProviderType.AZURE), new MetadataServiceStrategy(CloudProviderType.ORACLE), new MetadataServiceStrategy(CloudProviderType.ALIBABA)};
            int n = cloudInstanceMetadataStrategyArray.length;
            int n2 = 0;
            while (n2 < n) {
                CloudInstanceMetadataStrategy strategy = cloudInstanceMetadataStrategyArray[n2];
                if (strategy.isThisCloudProvider((HttpClient)httpClient)) {
                    CloudProviderType cloudProviderType = strategy.getCloudProviderType();
                    return cloudProviderType;
                }
                ++n2;
            }
            return CloudProviderType.UNKNOWN;
        }
        catch (IOException e) {
            LOG.error("Failed to close HttpClient", (Throwable)e);
        }
        return CloudProviderType.UNKNOWN;
    }
}

