/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.troubleshooting.stp.spi;

import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.descriptors.AbstractModuleDescriptor;
import com.atlassian.plugin.module.Element;
import com.atlassian.plugin.module.ModuleFactory;

public abstract class BaseWeightedModuleDescriptor<T>
extends AbstractModuleDescriptor<T>
implements Comparable<BaseWeightedModuleDescriptor<T>> {
    private int weight;

    public BaseWeightedModuleDescriptor(ModuleFactory moduleFactory, int defaultWeight) {
        super(moduleFactory);
        this.weight = defaultWeight;
    }

    public void init(Plugin plugin, Element element) throws PluginParseException {
        super.init(plugin, element);
        String weightAttr = element.attributeValue("weight");
        if (weightAttr != null) {
            try {
                this.weight = Integer.parseInt(weightAttr);
            }
            catch (NumberFormatException e) {
                throw new PluginParseException("The 'weight' attribute must be a number.", (Throwable)e);
            }
        }
    }

    @Override
    public int compareTo(BaseWeightedModuleDescriptor<T> otherDescriptor) {
        return this.weight - otherDescriptor.weight;
    }
}

