/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.troubleshooting.stp.audit;

import com.atlassian.audit.api.AuditService;
import com.atlassian.audit.entity.AuditAttribute;
import com.atlassian.audit.entity.AuditEvent;
import com.atlassian.audit.entity.AuditType;
import com.atlassian.audit.entity.ChangedValue;
import com.atlassian.audit.entity.CoverageArea;
import com.atlassian.audit.entity.CoverageLevel;
import com.atlassian.troubleshooting.stp.annotations.ConditionalOnClass;
import com.atlassian.troubleshooting.stp.audit.Auditor;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ConditionalOnClass(value={AuditService.class})
public class AuditorImpl
implements Auditor {
    private static final String CATEGORY = "stp.audit.category.system";
    private static final Logger LOGGER = LoggerFactory.getLogger(AuditorImpl.class);
    private final AuditService auditService;

    public AuditorImpl(AuditService auditService) {
        this.auditService = auditService;
    }

    @Override
    public void audit(@Nonnull String summaryKey) {
        try {
            AuditEvent.Builder auditEventBuilder = AuditEvent.builder((AuditType)AuditorImpl.auditType(summaryKey));
            this.auditService.audit(auditEventBuilder.build());
        }
        catch (Throwable t) {
            LOGGER.info("Failed to log audit event '{}'", (Object)summaryKey, (Object)t);
        }
    }

    private static AuditType auditType(@Nonnull String summaryKey) {
        return AuditType.fromI18nKeys((CoverageArea)CoverageArea.AUDIT_LOG, (CoverageLevel)CoverageLevel.BASE, (String)CATEGORY, (String)summaryKey).build();
    }

    @Override
    public void audit(@Nonnull String summaryKey, @Nonnull Map<String, String> extraAttributes, @Nonnull List<ChangedValue> changedValues) {
        try {
            AuditEvent.Builder auditEventBuilder = AuditEvent.builder((AuditType)AuditorImpl.auditType(summaryKey));
            for (Map.Entry<String, String> entry : extraAttributes.entrySet()) {
                auditEventBuilder.extraAttribute(AuditAttribute.fromI18nKeys((String)entry.getKey(), (String)entry.getValue()).build());
            }
            if (!changedValues.isEmpty()) {
                auditEventBuilder.changedValues(changedValues);
            }
            this.auditService.audit(auditEventBuilder.build());
        }
        catch (Throwable t) {
            LOGGER.info("Failed to log audit event '{}'", (Object)summaryKey, (Object)t);
        }
    }
}

