/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.troubleshooting.jfr.scheduler;

import com.atlassian.troubleshooting.analytic.DailyAnalyticsEventSupplier;
import com.atlassian.troubleshooting.jfr.domain.ConfigurationDetails;
import com.atlassian.troubleshooting.jfr.event.JfrSettingsStateAnalyticsEvent;
import com.atlassian.troubleshooting.jfr.event.JfrStateAnalyticsEvent;
import com.atlassian.troubleshooting.jfr.manager.JfrRecordingManager;
import com.atlassian.troubleshooting.jfr.util.JfrConditionUtils;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DailyAnalyticJfrSettings
implements DailyAnalyticsEventSupplier {
    private final JfrRecordingManager jfrRecordingManager;

    @Autowired
    public DailyAnalyticJfrSettings(JfrRecordingManager jfrRecordingManager) {
        this.jfrRecordingManager = Objects.requireNonNull(jfrRecordingManager);
    }

    private JfrSettingsStateAnalyticsEvent getJfrSettingsAnalyticEvent() {
        ConfigurationDetails configurationDetails = this.jfrRecordingManager.getActiveConfiguration();
        return JfrSettingsStateAnalyticsEvent.from(configurationDetails);
    }

    private JfrStateAnalyticsEvent getJfrStateAnalyticEvent() {
        return new JfrStateAnalyticsEvent(JfrConditionUtils.isJavaVersionSupported(), !this.jfrRecordingManager.getRecordingDetails().isEmpty(), this.jfrRecordingManager.isJfrFeatureFlagEnabled());
    }

    @Override
    public List<Object> getDailyAnalyticEvents() {
        return ImmutableList.of((Object)this.getJfrSettingsAnalyticEvent(), (Object)this.getJfrStateAnalyticEvent());
    }
}

