/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.troubleshooting.bamboo.zip;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.sal.api.lifecycle.LifecycleAware;
import com.atlassian.troubleshooting.bamboo.zip.CancelSupportZipEvent;
import com.atlassian.troubleshooting.bamboo.zip.CreateSupportZipEvent;
import com.atlassian.troubleshooting.stp.zip.CreateSupportZipMonitor;
import com.atlassian.troubleshooting.stp.zip.SupportZipRequest;
import com.atlassian.troubleshooting.stp.zip.SupportZipService;
import java.util.Objects;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;

public class SupportZipEventListener
implements LifecycleAware {
    private final EventPublisher eventPublisher;
    private final SupportZipService supportZipService;

    @Autowired
    public SupportZipEventListener(EventPublisher eventPublisher, SupportZipService supportZipService) {
        this.eventPublisher = Objects.requireNonNull(eventPublisher);
        this.supportZipService = Objects.requireNonNull(supportZipService);
    }

    public void onStart() {
        this.eventPublisher.register((Object)this);
    }

    public void onStop() {
        this.eventPublisher.unregister((Object)this);
    }

    @EventListener
    public void handle(CreateSupportZipEvent createSupportZipEvent) {
        SupportZipRequest supportZipRequest = createSupportZipEvent.getSupportZipRequest();
        this.supportZipService.createLocalSupportZipWithoutPermissionCheck(supportZipRequest);
    }

    @EventListener
    public void handle(CancelSupportZipEvent cancelSupportZipEvent) {
        Optional<CreateSupportZipMonitor> maybeMonitor = this.supportZipService.getMonitorWithoutPermissionCheck(cancelSupportZipEvent.getTaskId());
        maybeMonitor.ifPresent(this.supportZipService::cancelSupportZipTaskOnThisNode);
    }
}

